/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.core;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BuiltinModelItemRendererContext;
import fuzs.puzzleslib.api.client.core.v1.context.CoreShadersContext;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicBakingCompletedContext;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicModifyBakingResultContext;
import fuzs.puzzleslib.api.client.event.v1.ModelEvents;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.FabricResourceReloadListener;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.core.DynamicModifyBakingResultContextImpl;
import fuzs.puzzleslib.impl.client.core.context.AdditionalModelsContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockColorProvidersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockEntityRenderersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockRenderTypesContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.BuiltinModelItemRendererContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ClientTooltipComponentsContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.CoreShadersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.DynamicBakingCompletedContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.EntityRenderersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.EntitySpectatorShaderContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.FluidRenderTypesContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemColorProvidersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemDecorationContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemModelPropertiesContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.KeyMappingsContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.LayerDefinitionsContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.LivingEntityRenderLayersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ParticleProvidersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ResourcePackSourcesContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.SearchRegistryContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.SkullRenderersContextFabricImpl;
import fuzs.puzzleslib.impl.core.context.AddReloadListenersContextFabricImpl;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_4013;

public final class FabricClientModConstructor {
    private FabricClientModConstructor() {
    }

    public static void construct(ClientModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        constructor.onConstructMod();
        constructor.onClientSetup();
        constructor.onRegisterEntityRenderers(new EntityRenderersContextFabricImpl());
        constructor.onRegisterBlockEntityRenderers(new BlockEntityRenderersContextFabricImpl());
        constructor.onRegisterClientTooltipComponents(new ClientTooltipComponentsContextFabricImpl());
        constructor.onRegisterParticleProviders(new ParticleProvidersContextFabricImpl());
        constructor.onRegisterLayerDefinitions(new LayerDefinitionsContextFabricImpl());
        constructor.onRegisterSearchTrees(new SearchRegistryContextFabricImpl());
        FabricClientModConstructor.registerModelBakingListeners(constructor::onModifyBakingResult, constructor::onBakingCompleted, modId);
        constructor.onRegisterAdditionalModels(new AdditionalModelsContextFabricImpl());
        constructor.onRegisterItemModelProperties(new ItemModelPropertiesContextFabricImpl());
        constructor.onRegisterEntitySpectatorShaders(new EntitySpectatorShaderContextFabricImpl());
        FabricClientModConstructor.registerBuiltinModelItemRenderers(constructor::onRegisterBuiltinModelItemRenderers, modId);
        constructor.onRegisterResourcePackReloadListeners(new AddReloadListenersContextFabricImpl(class_3264.field_14188, modId));
        constructor.onRegisterLivingEntityRenderLayers(new LivingEntityRenderLayersContextFabricImpl());
        constructor.onRegisterItemDecorations(new ItemDecorationContextFabricImpl());
        constructor.onRegisterSkullRenderers(new SkullRenderersContextFabricImpl());
        constructor.onRegisterKeyMappings(new KeyMappingsContextFabricImpl());
        constructor.onRegisterBlockRenderTypes(new BlockRenderTypesContextFabricImpl());
        constructor.onRegisterFluidRenderTypes(new FluidRenderTypesContextFabricImpl());
        constructor.onRegisterBlockColorProviders(new BlockColorProvidersContextFabricImpl());
        constructor.onRegisterItemColorProviders(new ItemColorProvidersContextFabricImpl());
        constructor.onAddResourcePackFinders(new ResourcePackSourcesContextFabricImpl());
        FabricClientModConstructor.registerCoreShaders(constructor::onRegisterCoreShaders);
    }

    private static void registerModelBakingListeners(Consumer<DynamicModifyBakingResultContext> modifyBakingResultConsumer, Consumer<DynamicBakingCompletedContext> bakingCompletedConsumer, String modId) {
        ModelEvents.modifyBakingResult(null).register((models, modelBakery) -> {
            try {
                modifyBakingResultConsumer.accept(new DynamicModifyBakingResultContextImpl(models, (class_1088)modelBakery.get()));
            }
            catch (Exception e) {
                PuzzlesLib.LOGGER.error("Unable to execute additional resource pack model processing during modify baking result phase provided by {}", (Object)modId, (Object)e);
            }
        });
        ModelEvents.bakingCompleted(null).register((modelManager, models, modelBakery) -> {
            try {
                bakingCompletedConsumer.accept(new DynamicBakingCompletedContextFabricImpl((class_1092)modelManager.get(), models, (class_1088)modelBakery.get()));
            }
            catch (Exception e) {
                PuzzlesLib.LOGGER.error("Unable to execute additional resource pack model processing during baking completed phase provided by {}", (Object)modId, (Object)e);
            }
        });
    }

    private static void registerBuiltinModelItemRenderers(Consumer<BuiltinModelItemRendererContext> consumer, String modId) {
        ArrayList listeners = Lists.newArrayList();
        consumer.accept(new BuiltinModelItemRendererContextFabricImpl(listeners));
        if (listeners.isEmpty()) {
            return;
        }
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new FabricResourceReloadListener(modId, "built_in_model_item_renderers", (class_3302)((class_4013)resourceManager -> {
            for (class_4013 listener : listeners) {
                try {
                    listener.method_14491(resourceManager);
                }
                catch (Exception e) {
                    PuzzlesLib.LOGGER.error("Unable to execute dynamic built-in model item renderers reload provided by {}", (Object)modId, (Object)e);
                }
            }
        }), new class_2960[0]));
    }

    private static void registerCoreShaders(Consumer<CoreShadersContext> modifyBakingResultConsumer) {
        CoreShaderRegistrationCallback.EVENT.register(context -> modifyBakingResultConsumer.accept(new CoreShadersContextFabricImpl(context)));
    }
}

