/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.init;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.client.init.v1.ItemModelDisplayOverrides;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1091;
import net.minecraft.class_811;

public abstract class ItemDisplayOverridesImpl
implements ItemModelDisplayOverrides {
    protected final Map<class_1091, Map<class_811, class_1091>> overrideLocations = Maps.newHashMap();

    @Override
    public final void register(class_1091 itemModel, class_1091 itemModelOverride, class_811 ... defaultContexts) {
        Objects.requireNonNull(itemModel, "item model is null");
        Objects.requireNonNull(itemModelOverride, "item model override is null");
        Preconditions.checkPositionIndex((int)0, (int)(defaultContexts.length - 1), (String)"item display contexts is empty");
        Map overrides = this.overrideLocations.computeIfAbsent(itemModel, $ -> Maps.newEnumMap(class_811.class));
        EnumSet<class_811> contextsToOverride = EnumSet.complementOf(Sets.newEnumSet(Arrays.asList(defaultContexts), class_811.class));
        for (class_811 context : contextsToOverride) {
            if (overrides.put(context, itemModelOverride) == null) continue;
            throw new IllegalStateException("Attempting to register duplicate item model display override for model %s and display context %s".formatted(itemModel, context));
        }
    }
}

