/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.config.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigDataSetImpl<T>
implements ConfigDataSet<T> {
    private static final Set<Class<?>> SUPPORTED_DATA_TYPES = ImmutableSet.of(Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Double.TYPE, Double.class, (Object[])new Class[]{String.class});
    private final class_2378<T> activeRegistry;
    private final List<EntryHolder<?, T>> values = Lists.newArrayList();
    private final BiPredicate<Integer, Object> filter;
    private final int dataSize;
    private Map<T, Object[]> dissolved;

    public ConfigDataSetImpl(class_2378<T> registry, List<String> values, BiPredicate<Integer, Object> filter, Class<?> ... types) {
        this.activeRegistry = registry;
        this.filter = filter;
        for (Class<?> clazz : types) {
            if (SUPPORTED_DATA_TYPES.contains(clazz)) continue;
            throw new IllegalArgumentException("Data type of clazz %s is not supported".formatted(clazz));
        }
        this.dataSize = types.length;
        for (String value : values) {
            this.deserialize(value, types).ifPresent(this.values::add);
        }
    }

    @Override
    public Map<T, Object[]> toMap() {
        this.dissolve();
        return this.dissolved;
    }

    @Override
    public Set<T> toSet() {
        return this.toMap().keySet();
    }

    @Override
    public Iterator<T> iterator() {
        return this.toSet().iterator();
    }

    @Override
    public int size() {
        return this.toMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.toMap().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.toSet().contains(o);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toSet().toArray();
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] a) {
        return this.toSet().toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.toSet().add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.toSet().remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.toSet().containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        return this.toSet().addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.toSet().removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.toSet().retainAll(c);
    }

    @Override
    public void clear() {
        this.toMap().clear();
    }

    @Override
    @Nullable
    public Object[] get(T entry) {
        return this.toMap().get(entry);
    }

    @Override
    public <V> V get(T entry, int index) {
        Preconditions.checkPositionIndex((int)index, (int)(this.dataSize - 1));
        Object[] data = this.get(entry);
        Objects.requireNonNull(data, "data is null");
        return (V)data[index];
    }

    @Override
    public <V> Optional<V> getOptional(T entry, int index) {
        if (index < 0 || index >= this.dataSize) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.get(entry)).map(data -> data[index]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ConfigDataSet)) return false;
        ConfigDataSet impl = (ConfigDataSet)o;
        if (!this.toMap().equals(impl.toMap())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.toMap().hashCode();
    }

    private void dissolve() {
        if (this.dissolved == null) {
            IdentityHashMap map = Maps.newIdentityHashMap();
            for (EntryHolder<?, T> holder : this.values) {
                if (!(holder instanceof TagEntryHolder)) continue;
                this.dissolveHolder(holder, map::putAll);
            }
            for (EntryHolder<?, T> holder : this.values) {
                if (!(holder instanceof RegistryEntryHolder)) continue;
                this.dissolveHolder(holder, map::putAll);
            }
            this.dissolved = Collections.unmodifiableMap(map);
        }
    }

    private void dissolveHolder(EntryHolder<?, T> holder, Consumer<Map<T, Object[]>> builder) {
        HashMap entries = Maps.newHashMap();
        holder.dissolve(entries);
        entries.keySet().removeIf(e -> !this.filter.test(0, e));
        builder.accept(entries);
    }

    private Optional<EntryHolder<?, T>> deserialize(String source, Class<?>[] types) {
        String[] sources = source.trim().split(",");
        Object[] data = new Object[types.length];
        try {
            for (int i = 0; i < types.length; ++i) {
                if (sources.length - 1 <= i) {
                    throw new IllegalArgumentException("Data index out of bounds, index was %s, but length is %s".formatted(i + 1, sources.length));
                }
                data[i] = ConfigDataSetImpl.deserializeData(types[i], sources[i + 1].trim());
                if (this.filter.test(i + 1, data[i])) continue;
                throw new IllegalStateException("Data %s at index %s from source entry %s does not conform to filter".formatted(data[i], i, source));
            }
            return Optional.of(this.deserialize(sources[0].trim()).withData(data));
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.warn("Unable to parse entry {}", (Object)source, (Object)e);
            return Optional.empty();
        }
    }

    private EntryHolder<?, T> deserialize(String source) throws RuntimeException {
        boolean tagHolder = ((String)source).startsWith("#");
        if (tagHolder) {
            source = ((String)source).substring(1);
        }
        if (!((String)source).contains(":")) {
            source = "minecraft:" + (String)source;
        }
        if (tagHolder) {
            return new TagEntryHolder<T>(this.activeRegistry, (String)source);
        }
        return new RegistryEntryHolder<T>(this.activeRegistry, (String)source);
    }

    private static Object deserializeData(Class<?> clazz, String source) throws RuntimeException {
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (source.equals("true")) {
                return true;
            }
            if (source.equals("false")) {
                return false;
            }
            throw new IllegalArgumentException("%s is not a boolean value".formatted(source));
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer.parseInt(source);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double.parseDouble(source);
        }
        if (clazz == String.class) {
            return source;
        }
        throw new IllegalArgumentException("Data type of clazz %s is not supported".formatted(clazz));
    }

    private static abstract class EntryHolder<D, E> {
        protected final class_2378<E> activeRegistry;
        private final String input;
        private Object[] data = new Object[0];

        protected EntryHolder(class_2378<E> registry, String input) {
            this.activeRegistry = registry;
            this.input = input;
        }

        public EntryHolder<D, E> withData(Object[] data) {
            this.data = data;
            return this;
        }

        public final void dissolve(Map<E, Object[]> entries) {
            this.findRegistryMatches(this.input).stream().flatMap(this::dissolveValue).forEach(value -> entries.put(value, this.data));
        }

        private Collection<D> findRegistryMatches(String source) {
            HashSet matches = Sets.newHashSet();
            if (!source.contains("*")) {
                this.toValue(new class_2960(source)).ifPresent(matches::add);
            } else {
                String regexSource = source.replace("*", "[a-z0-9/._-]*");
                this.allValues().filter(entry -> ((class_2960)entry.getKey()).toString().matches(regexSource)).map(Map.Entry::getValue).forEach(matches::add);
            }
            if (this.activeRegistry != null && matches.isEmpty()) {
                PuzzlesLib.LOGGER.warn("Unable to parse entry {}: No matches found in registry {}", (Object)source, (Object)this.activeRegistry.method_30517().method_29177());
            }
            return matches;
        }

        protected abstract Stream<E> dissolveValue(D var1);

        protected abstract Optional<D> toValue(class_2960 var1);

        protected abstract Stream<Map.Entry<class_2960, D>> allValues();
    }

    private static class TagEntryHolder<E>
    extends EntryHolder<class_6862<E>, E> {
        TagEntryHolder(class_2378<E> registry, String source) {
            super(registry, source);
        }

        @Override
        public Stream<E> dissolveValue(class_6862<E> entry) {
            return StreamSupport.stream(this.activeRegistry.method_40286(entry).spliterator(), false).map(class_6880::comp_349);
        }

        @Override
        protected Optional<class_6862<E>> toValue(class_2960 identifier) {
            class_6862 tag = class_6862.method_40092((class_5321)this.activeRegistry.method_30517(), (class_2960)identifier);
            if (this.activeRegistry.method_40266(tag).isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(tag);
        }

        @Override
        protected Stream<Map.Entry<class_2960, class_6862<E>>> allValues() {
            return this.activeRegistry.method_40273().collect(Collectors.toMap(class_6862::comp_327, Function.identity())).entrySet().stream();
        }
    }

    private static class RegistryEntryHolder<E>
    extends EntryHolder<E, E> {
        RegistryEntryHolder(class_2378<E> registry, String source) {
            super(registry, source);
        }

        @Override
        protected Stream<E> dissolveValue(E entry) {
            return Stream.of(entry);
        }

        @Override
        protected Optional<E> toValue(class_2960 identifier) {
            if (!this.activeRegistry.method_10250(identifier)) {
                return Optional.empty();
            }
            return Optional.of(this.activeRegistry.method_10223(identifier));
        }

        @Override
        protected Stream<Map.Entry<class_2960, E>> allValues() {
            return this.activeRegistry.method_29722().stream().collect(Collectors.toMap(e -> ((class_5321)e.getKey()).method_29177(), Map.Entry::getValue)).entrySet().stream();
        }
    }
}

