/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core.context;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.biome.v1.BiomeModificationContext;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.impl.biome.BiomeLoadingContextFabric;
import fuzs.puzzleslib.impl.biome.ClimateSettingsContextFabric;
import fuzs.puzzleslib.impl.biome.GenerationSettingsContextFabric;
import fuzs.puzzleslib.impl.biome.MobSpawnSettingsContextFabric;
import fuzs.puzzleslib.impl.biome.SpecialEffectsContextFabric;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1959;
import net.minecraft.class_2960;

public record BiomeModificationsContextFabricImpl(BiomeModification biomeModification) implements BiomeModificationsContext
{
    private static final Map<BiomeLoadingPhase, ModificationPhase> BIOME_PHASE_CONVERSIONS = Maps.immutableEnumMap((Map)new HashMap<BiomeLoadingPhase, ModificationPhase>(){
        {
            this.put(BiomeLoadingPhase.ADDITIONS, ModificationPhase.ADDITIONS);
            this.put(BiomeLoadingPhase.REMOVALS, ModificationPhase.REMOVALS);
            this.put(BiomeLoadingPhase.MODIFICATIONS, ModificationPhase.REPLACEMENTS);
            this.put(BiomeLoadingPhase.POST_PROCESSING, ModificationPhase.POST_PROCESSING);
        }
    });

    public BiomeModificationsContextFabricImpl(String modId) {
        this(BiomeModifications.create((class_2960)new class_2960(modId, "biome_modifiers")));
    }

    private static BiomeModificationContext getBiomeModificationContext(net.fabricmc.fabric.api.biome.v1.BiomeModificationContext modificationContext, class_1959 biome) {
        ClimateSettingsContextFabric climateSettings = new ClimateSettingsContextFabric(biome, modificationContext.getWeather());
        SpecialEffectsContextFabric specialEffects = new SpecialEffectsContextFabric(biome.method_24377(), modificationContext.getEffects());
        GenerationSettingsContextFabric generationSettings = new GenerationSettingsContextFabric(biome.method_30970(), modificationContext.getGenerationSettings());
        MobSpawnSettingsContextFabric mobSpawnSettings = new MobSpawnSettingsContextFabric(biome.method_30966(), modificationContext.getSpawnSettings());
        return new BiomeModificationContext(climateSettings, specialEffects, generationSettings, mobSpawnSettings);
    }

    private static void registerBiomeModification(BiomeModification biomeModification, BiomeLoadingPhase phase, Predicate<BiomeLoadingContext> selector, Consumer<BiomeModificationContext> modifier) {
        ModificationPhase modificationPhase = BIOME_PHASE_CONVERSIONS.get((Object)phase);
        Objects.requireNonNull(modificationPhase, "modification phase is null");
        biomeModification.add(modificationPhase, selectionContext -> selector.test(BiomeLoadingContextFabric.create(selectionContext)), (selectionContext, modificationContext) -> modifier.accept(BiomeModificationsContextFabricImpl.getBiomeModificationContext(modificationContext, selectionContext.getBiome())));
    }

    @Override
    public void register(BiomeLoadingPhase phase, Predicate<BiomeLoadingContext> selector, Consumer<BiomeModificationContext> modifier) {
        BiomeModificationsContextFabricImpl.registerBiomeModification(this.biomeModification, phase, selector, modifier);
    }
}

