/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.event;

import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1320;
import net.minecraft.class_1322;

public final class AttributeModifiersMultimap
extends ForwardingMultimap<class_1320, class_1322> {
    private final Supplier<Multimap<class_1320, class_1322>> getModifiers;
    private final BiPredicate<class_1320, class_1322> addModifier;
    private final BiPredicate<class_1320, class_1322> removeModifier;
    private final Function<class_1320, Collection<class_1322>> removeAttribute;
    private final Runnable clearModifiers;

    public AttributeModifiersMultimap(Supplier<Multimap<class_1320, class_1322>> getModifiers, BiPredicate<class_1320, class_1322> addModifier, BiPredicate<class_1320, class_1322> removeModifier, Function<class_1320, Collection<class_1322>> removeAttribute, Runnable clearModifiers) {
        this.getModifiers = getModifiers;
        this.addModifier = addModifier;
        this.removeModifier = removeModifier;
        this.removeAttribute = removeAttribute;
        this.clearModifiers = clearModifiers;
    }

    protected Multimap<class_1320, class_1322> delegate() {
        return this.getModifiers.get();
    }

    public void clear() {
        this.clearModifiers.run();
    }

    public boolean put(class_1320 key, class_1322 value) {
        return this.addModifier.test(key, value);
    }

    @Deprecated
    public boolean putAll(class_1320 key, Iterable<? extends class_1322> values) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean putAll(Multimap<? extends class_1320, ? extends class_1322> multimap) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean remove(Object key, Object value) {
        if (!(key instanceof class_1320)) return false;
        class_1320 attribute = (class_1320)key;
        if (!(value instanceof class_1322)) return false;
        class_1322 attributeModifier = (class_1322)value;
        if (!this.removeModifier.test(attribute, attributeModifier)) return false;
        return true;
    }

    public Collection<class_1322> removeAll(Object key) {
        Collection<class_1322> collection;
        if (key instanceof class_1320) {
            class_1320 attribute = (class_1320)key;
            collection = this.removeAttribute.apply(attribute);
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    @Deprecated
    public Collection<class_1322> replaceValues(class_1320 key, Iterable<? extends class_1322> values) {
        throw new UnsupportedOperationException();
    }
}

