/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import fuzs.puzzleslib.impl.core.FabricProxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2792;
import net.minecraft.class_2960;

public class NetworkHandlerFabricV2
implements NetworkHandlerV2 {
    private final Map<Class<? extends MessageV2<?>>, MessageData> messages = Maps.newIdentityHashMap();
    private final String modId;
    private final AtomicInteger discriminator = new AtomicInteger();

    public NetworkHandlerFabricV2(String modId) {
        this.modId = modId;
    }

    @Override
    public <T extends MessageV2<T>> void register(Class<? extends T> clazz, Supplier<T> supplier, MessageDirection direction) {
        class_2960 channelName = this.nextIdentifier();
        this.messages.put(clazz, new MessageData(clazz, channelName, direction));
        Function<class_2540, MessageV2> decode = buf -> (MessageV2)class_156.method_654((Object)((MessageV2)supplier.get()), message -> message.read((class_2540)buf));
        switch (direction) {
            case TO_CLIENT: {
                ((FabricProxy)Proxy.INSTANCE).registerLegacyClientReceiver(channelName, decode);
                break;
            }
            case TO_SERVER: {
                ((FabricProxy)Proxy.INSTANCE).registerLegacyServerReceiver(channelName, decode);
            }
        }
    }

    private class_2960 nextIdentifier() {
        return new class_2960(this.modId, "play/" + this.discriminator.getAndIncrement());
    }

    @Override
    public class_2596<class_2792> toServerboundPacket(MessageV2<?> message) {
        if (this.messages.get(message.getClass()).direction() != MessageDirection.TO_SERVER) {
            throw new IllegalStateException("Attempted sending message to wrong side, expected %s, was %s".formatted(new Object[]{MessageDirection.TO_SERVER, MessageDirection.TO_CLIENT}));
        }
        return this.toPacket(ClientPlayNetworking::createC2SPacket, message);
    }

    @Override
    public class_2596<class_2602> toClientboundPacket(MessageV2<?> message) {
        if (this.messages.get(message.getClass()).direction() != MessageDirection.TO_CLIENT) {
            throw new IllegalStateException("Attempted sending message to wrong side, expected %s, was %s".formatted(new Object[]{MessageDirection.TO_CLIENT, MessageDirection.TO_SERVER}));
        }
        return this.toPacket(ServerPlayNetworking::createS2CPacket, message);
    }

    private <T extends class_2547> class_2596<T> toPacket(BiFunction<class_2960, class_2540, class_2596<T>> packetFactory, MessageV2<?> message) {
        class_2960 identifier = this.messages.get(message.getClass()).identifier();
        class_2540 byteBuf = PacketByteBufs.create();
        message.write(byteBuf);
        return packetFactory.apply(identifier, byteBuf);
    }

    private record MessageData(Class<? extends MessageV2<?>> clazz, class_2960 identifier, MessageDirection direction) {
    }
}

