/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.model.OcelotTailModel;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_5601;
import net.minecraft.class_5605;
import net.minecraft.class_5607;
import net.minecraft.class_582;
import net.minecraftforge.common.ForgeConfigSpec;

public class OcelotTailElement
extends ModelElement {
    public static int tailLength;
    public static int animationSpeed;
    private final class_5601 animatedOcelot;

    public OcelotTailElement(BiFunction<String, String, class_5601> factory) {
        this.animatedOcelot = factory.apply("animated_ocelot", "main");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"Takes away the stick tails of the current ocelots and gives them something nicer instead.", "Fully animated flowing tails that move while they stand or run."};
    }

    @Override
    void onRegisterAnimatedModels(ModelElement.AnimatedModelsContext context, ModelElement.EntityModelBakery bakery) {
        context.registerAnimatedModel(class_582.class, () -> new OcelotTailModel(bakery.bakeLayer(this.animatedOcelot)));
    }

    @Override
    public void onRegisterLayerDefinitions(BiConsumer<class_5601, Supplier<class_5607>> context) {
        context.accept(this.animatedOcelot, () -> OcelotTailModel.createAnimatedBodyMesh(class_5605.field_27715));
    }

    @Override
    public void setupModelConfig(ForgeConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Define tail length.").defineInRange("tail_length", 15, 1, 15), v -> {
            tailLength = v;
        });
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Animation swing speed for tail.").defineInRange("animation_speed", 7, 1, 20), v -> {
            animationSpeed = v;
        });
    }
}

