/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.pipe.item.SpeedUpgrade;
import aztech.modern_industrialization.blocks.OreBlock;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.items.PortableStorageUnit;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricBlastFurnaceBlockEntity;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.nuclear.NuclearAbsorbable;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.util.TextHelper;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;

public class MITooltips {
    public static final PriorityQueue<TooltipAttachment> TOOLTIPS = new PriorityQueue();
    public static final class_2583 DEFAULT_STYLE = class_2583.field_24360.method_27703(class_5251.method_27717((int)0xA9A9A9)).method_10978(Boolean.valueOf(false));
    public static final class_2583 NUMBER_TEXT = class_2583.field_24360.method_27703(class_5251.method_27717((int)16768637)).method_10978(Boolean.valueOf(false));
    private static final Map<Class<?>, class_2583> DEFAULT_ARGUMENT_STYLE = new HashMap();
    public static final Parser<Object> DEFAULT_PARSER;
    public static final Parser<Number> EU_PER_TICK_PARSER;
    public static final Parser<Number> EU_PARSER;
    public static final Parser<NumberWithMax> EU_MAXED_PARSER;
    public static final Parser<class_3611> FLUID_PARSER;
    public static final Parser<Double> RATIO_PERCENTAGE_PARSER;
    public static final Parser<Double> INVERTED_RATIO_PERCENTAGE_PARSER;
    public static final Parser<class_2680> BLOCK_STATE_PARSER;
    public static final Parser<class_1792> ITEM_PARSER;
    public static final TooltipAttachment BATTERIES;
    public static final TooltipAttachment CABLES;
    public static final TooltipAttachment COILS;
    public static final TooltipAttachment CREATIVE_FLIGHT;
    public static final TooltipAttachment ENERGY_STORED_ITEM;
    public static final TooltipAttachment LUBRICANT_BUCKET;
    public static final TooltipAttachment GUNPOWDER;
    public static final TooltipAttachment MACHINE_TOOLTIPS;
    public static final TooltipAttachment NUCLEAR;
    public static final TooltipAttachment ORES;
    public static final TooltipAttachment SPEED_UPGRADES;
    public static final TooltipAttachment UPGRADES;
    public static final TooltipAttachment STEAM_DRILL;
    public static final TooltipAttachment CONFIG_CARD_HELP;
    public static final Map<String, String> TOOLTIPS_ENGLISH_TRANSLATION;

    public static int colorFromProgress(double progress, boolean zeroIsGreen) {
        progress = Math.max(0.0, Math.min(1.0, progress));
        if (!zeroIsGreen) {
            progress = 1.0 - progress;
        }
        double r = Math.min(2.0 * progress, 1.0);
        double g = Math.min(1.0, 2.0 - 2.0 * progress);
        return (int)(r * 255.0) << 16 | (int)(g * 255.0) << 8;
    }

    public static class_2583 styleFromProgress(double progress, boolean zeroIsGreen) {
        return class_2583.field_24360.method_27703(class_5251.method_27717((int)MITooltips.colorFromProgress(progress, zeroIsGreen))).method_10978(Boolean.valueOf(false));
    }

    public static void attachTooltip(class_1799 stack, List<class_2561> lines) {
        block3: {
            class_1792 item = stack.method_7909();
            if (item == null) break block3;
            boolean hasPrintRequiredShift = false;
            for (TooltipAttachment tooltip : TOOLTIPS) {
                Optional<List<? extends class_2561>> maybeComponents;
                block5: {
                    block4: {
                        maybeComponents = tooltip.tooltipLines.apply(stack, stack.method_7909());
                        if (!tooltip.requiresShift) break block4;
                        if (!CommonProxy.INSTANCE.hasShiftDown()) break block5;
                    }
                    maybeComponents.ifPresent(lines::addAll);
                    continue;
                }
                if (!tooltip.requiresShift || hasPrintRequiredShift || !maybeComponents.isPresent()) continue;
                lines.add((class_2561)MIText.TooltipsShiftRequired.text().method_10862(DEFAULT_STYLE));
                hasPrintRequiredShift = true;
            }
        }
    }

    private static void add(Predicate<class_1935> attachTo, String translationId, String ... englishTooltipsLine) {
        int lineCount = englishTooltipsLine.length;
        Preconditions.checkArgument((lineCount > 0 ? 1 : 0) != 0);
        String[] translationKey = (String[])IntStream.range(0, lineCount).mapToObj(l -> "item_tooltip.modern_industrialization." + translationId + ".line_" + l).toArray(String[]::new);
        for (int i = 0; i < lineCount; ++i) {
            TOOLTIPS_ENGLISH_TRANSLATION.put(translationKey[i], englishTooltipsLine[i]);
        }
        TooltipAttachment.ofMultilines((itemStack, item) -> {
            if (attachTo.test((class_1935)item)) {
                return Optional.of(Arrays.stream(translationKey).map(class_2561::method_43471).collect(Collectors.toList()));
            }
            return Optional.empty();
        });
    }

    private static void add(class_1935 itemLike, String ... englishTooltipsLine) {
        MITooltips.add((class_1935 item) -> itemLike.method_8389() == item, class_7923.field_41178.method_10221((Object)itemLike.method_8389()).method_12832(), englishTooltipsLine);
    }

    private static void add(String itemId, String ... englishTooltipsLine) {
        MITooltips.add((class_1935)class_7923.field_41178.method_10223((class_2960)new MIIdentifier(itemId)), englishTooltipsLine);
    }

    public static Line line(MIText baseText) {
        return new Line(baseText);
    }

    public static Line line(MIText baseText, class_2583 style) {
        return new Line(baseText, style);
    }

    static {
        DEFAULT_ARGUMENT_STYLE.put(Integer.class, NUMBER_TEXT);
        DEFAULT_ARGUMENT_STYLE.put(Long.class, NUMBER_TEXT);
        DEFAULT_ARGUMENT_STYLE.put(Float.class, NUMBER_TEXT);
        DEFAULT_ARGUMENT_STYLE.put(Double.class, NUMBER_TEXT);
        DEFAULT_PARSER = new Parser<Object>(){

            @Override
            public class_2561 parse(Object o) {
                class_2583 style = DEFAULT_STYLE;
                for (Map.Entry<Class<?>, class_2583> entry : DEFAULT_ARGUMENT_STYLE.entrySet()) {
                    if (!o.getClass().isAssignableFrom(entry.getKey())) continue;
                    style = entry.getValue();
                    break;
                }
                if (o instanceof class_3611) {
                    class_3611 f = (class_3611)o;
                    return FLUID_PARSER.parse(f);
                }
                if (o instanceof FluidLike) {
                    FluidLike f = (FluidLike)o;
                    return FLUID_PARSER.parse(f.asFluid());
                }
                if (o instanceof class_1792) {
                    return ITEM_PARSER.parse((class_1792)o);
                }
                if (o instanceof class_1935) {
                    return ITEM_PARSER.parse(((class_1935)o).method_8389());
                }
                return class_2561.method_43470((String)String.valueOf(o)).method_27696(style);
            }
        };
        EU_PER_TICK_PARSER = new Parser<Number>(){

            @Override
            public class_2561 parse(Number number) {
                TextHelper.Amount amount = TextHelper.getAmountGeneric(number);
                return MIText.EuT.text(amount.digit(), amount.unit()).method_27696(NUMBER_TEXT);
            }
        };
        EU_PARSER = new Parser<Number>(){

            @Override
            public class_2561 parse(Number number) {
                TextHelper.Amount amount = TextHelper.getAmountGeneric(number);
                return MIText.Eu.text(amount.digit(), amount.unit()).method_27696(NUMBER_TEXT);
            }
        };
        EU_MAXED_PARSER = new Parser<NumberWithMax>(){

            @Override
            public class_2561 parse(NumberWithMax numberWithMax) {
                class_5250 component = TextHelper.getEuTextMaxed(numberWithMax.number, numberWithMax.max);
                return component.method_27696(NUMBER_TEXT);
            }
        };
        FLUID_PARSER = new Parser<class_3611>(){

            @Override
            public class_2561 parse(class_3611 fluid) {
                return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid));
            }
        };
        RATIO_PERCENTAGE_PARSER = new Parser<Double>(){

            @Override
            public class_2561 parse(Double ratio) {
                String percentage = String.format("%.1f", ratio * 100.0);
                return class_2561.method_43470((String)(percentage + "%")).method_27696(MITooltips.styleFromProgress(ratio, false));
            }
        };
        INVERTED_RATIO_PERCENTAGE_PARSER = new Parser<Double>(){

            @Override
            public class_2561 parse(Double ratio) {
                String percentage = String.format("%.1f", ratio * 100.0);
                return class_2561.method_43470((String)(percentage + "%")).method_27696(MITooltips.styleFromProgress(ratio, true));
            }
        };
        BLOCK_STATE_PARSER = state -> state.method_26204().method_9518().method_27696(NUMBER_TEXT);
        ITEM_PARSER = state -> state.method_7854().method_7964().method_27661().method_27696(NUMBER_TEXT);
        BATTERIES = TooltipAttachment.of((itemStack, item) -> {
            if (PortableStorageUnit.CAPACITY_PER_BATTERY.containsKey(item)) {
                Long capacity = PortableStorageUnit.CAPACITY_PER_BATTERY.get((Object)itemStack.method_7909());
                return Optional.of(new Line(MIText.BatteryInStorageUnit).arg(capacity, EU_PARSER).build());
            }
            return Optional.empty();
        });
        CABLES = TooltipAttachment.of((itemStack, item) -> {
            PipeItem pipe;
            if (item instanceof PipeItem && MIPipes.ELECTRICITY_PIPE_TIER.containsKey((Object)(pipe = (PipeItem)((Object)item)))) {
                CableTier tier = MIPipes.ELECTRICITY_PIPE_TIER.get((Object)((PipeItem)itemStack.method_7909()));
                return Optional.of(new Line(MIText.EuCable).arg(tier.englishName).arg(tier.getMaxTransfer(), EU_PER_TICK_PARSER).build());
            }
            return Optional.empty();
        });
        COILS = TooltipAttachment.of((itemStack, item) -> {
            class_1747 blockItem;
            if (item instanceof class_1747 && ElectricBlastFurnaceBlockEntity.tiersByCoil.containsKey(class_7923.field_41175.method_10221((Object)(blockItem = (class_1747)item).method_7711()))) {
                long eu = ElectricBlastFurnaceBlockEntity.tiersByCoil.get(class_7923.field_41175.method_10221((Object)((class_1747)itemStack.method_7909()).method_7711())).maxBaseEu();
                return Optional.of(new Line(MIText.EbfMaxEu).arg(eu).build());
            }
            return Optional.empty();
        });
        CREATIVE_FLIGHT = TooltipAttachment.of((itemStack, item) -> {
            if (item == MIItem.QUANTUM_CHESTPLATE.method_8389() || item == MIItem.GRAVICHESTPLATE.method_8389()) {
                return Optional.of(new Line(MIText.AllowCreativeFlight).build());
            }
            return Optional.empty();
        }).noShiftRequired();
        ENERGY_STORED_ITEM = TooltipAttachment.of((itemStack, item) -> {
            long capacity;
            EnergyStorage energyStorage;
            if (class_7923.field_41178.method_10221(item).method_12836().equals("modern_industrialization") && (energyStorage = (EnergyStorage)ContainerItemContext.withConstant((class_1799)itemStack).find(EnergyApi.ITEM)) != null && (capacity = energyStorage.getCapacity()) > 0L) {
                return Optional.of(new Line(MIText.EnergyStored).arg(new NumberWithMax(energyStorage.getAmount(), capacity), EU_MAXED_PARSER).build());
            }
            return Optional.empty();
        }).noShiftRequired();
        LUBRICANT_BUCKET = TooltipAttachment.of((class_1935)MIFluids.LUBRICANT.getBucket(), new Line(MIText.LubricantTooltip).arg(25));
        GUNPOWDER = TooltipAttachment.of((class_1935)class_1802.field_8054, MIText.GunpowderUpgrade);
        MACHINE_TOOLTIPS = TooltipAttachment.ofMultilines((itemStack, item) -> {
            MachineBlock machineBlock;
            class_1747 blockItem;
            class_2248 patt12208$temp;
            if (item instanceof class_1747 && (patt12208$temp = (blockItem = (class_1747)item).method_7711()) instanceof MachineBlock && !(machineBlock = (MachineBlock)patt12208$temp).getBlockEntityInstance().getTooltips().isEmpty()) {
                return Optional.of(((MachineBlock)((class_1747)itemStack.method_7909()).method_7711()).getBlockEntityInstance().getTooltips());
            }
            return Optional.empty();
        });
        NUCLEAR = TooltipAttachment.ofMultilines((itemStack, item) -> {
            if (item instanceof NuclearAbsorbable) {
                LinkedList<class_5250> tooltips = new LinkedList<class_5250>();
                long remAbs = ((NuclearAbsorbable)itemStack.method_7909()).getRemainingDesintegrations((class_1799)itemStack);
                tooltips.add(new Line(MIText.RemAbsorption).arg(remAbs).arg(((NuclearAbsorbable)itemStack.method_7909()).desintegrationMax).build());
                class_1792 patt13182$temp = itemStack.method_7909();
                if (patt13182$temp instanceof NuclearFuel) {
                    NuclearFuel fuel = (NuclearFuel)patt13182$temp;
                    long totalEu = (long)fuel.totalEUbyDesintegration * (long)fuel.desintegrationMax;
                    tooltips.add(new Line(MIText.BaseEuTotalStored).arg(totalEu, EU_PARSER).build());
                }
                return Optional.of(tooltips);
            }
            return Optional.empty();
        });
        ORES = TooltipAttachment.ofMultilines((itemStack, item) -> {
            class_1747 blockItem;
            if (item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof OreBlock) {
                OreBlock oreBlock = (OreBlock)((class_1747)itemStack.method_7909()).method_7711();
                LinkedList<class_5250> lines = new LinkedList<class_5250>();
                MIConfig config = MIConfig.getConfig();
                if (config.enableDefaultOreGenTooltips) {
                    if (oreBlock.params.generate) {
                        lines.add(new Line(MIText.OreGenerationTooltipY).arg(-64).arg(oreBlock.params.maxYLevel).build());
                        lines.add(new Line(MIText.OreGenerationTooltipVeinFrequency).arg(oreBlock.params.veinsPerChunk).build());
                        lines.add(new Line(MIText.OreGenerationTooltipVeinSize).arg(oreBlock.params.veinSize).build());
                    } else {
                        lines.add(new Line(MIText.OreNotGenerated).build());
                    }
                    return Optional.of(lines);
                }
            }
            return Optional.empty();
        });
        SPEED_UPGRADES = TooltipAttachment.of((itemStack, item) -> {
            if (SpeedUpgrade.UPGRADES.containsKey(item)) {
                return Optional.of(new Line(MIText.TooltipSpeedUpgrade).arg(SpeedUpgrade.UPGRADES.get(item)).build());
            }
            return Optional.empty();
        });
        UPGRADES = TooltipAttachment.ofMultilines((itemStack, item) -> {
            if (UpgradeComponent.getExtraEu((class_1935)item) > 0L) {
                LinkedList<class_5250> lines = new LinkedList<class_5250>();
                lines.add(new Line(MIText.MachineUpgrade).arg(UpgradeComponent.getExtraEu((class_1935)itemStack.method_7909()), EU_PER_TICK_PARSER).build());
                if (itemStack.method_7947() > 1) {
                    lines.add(new Line(MIText.MachineUpgradeStack).arg((long)itemStack.method_7947() * UpgradeComponent.getExtraEu((class_1935)itemStack.method_7909()), EU_PER_TICK_PARSER).build());
                }
                return Optional.of(lines);
            }
            return Optional.empty();
        });
        STEAM_DRILL = TooltipAttachment.ofMultilines(MIItem.STEAM_MINING_DRILL, MIText.SteamDrillWaterHelp, MIText.SteamDrillFuelHelp, MIText.SteamDrillProfit, MIText.SteamDrillToggle);
        CONFIG_CARD_HELP = TooltipAttachment.ofMultilines(MIItem.CONFIG_CARD, MIText.ConfigCardHelpCamouflage1, MIText.ConfigCardHelpCamouflage2, MIText.ConfigCardHelpCamouflage3, MIText.ConfigCardHelpCamouflage4, MIText.ConfigCardHelpCamouflage5, MIText.ConfigCardHelpCamouflage6, MIText.ConfigCardHelpCamouflage7, MIText.ConfigCardHelpCamouflage8, MIText.ConfigCardHelpItems1, MIText.ConfigCardHelpItems2, MIText.ConfigCardHelpItems3, MIText.ConfigCardHelpItems4, MIText.ConfigCardHelpItems5, MIText.ConfigCardHelpClear);
        TOOLTIPS_ENGLISH_TRANSLATION = new HashMap<String, String>();
        MITooltips.add(MIBlock.FORGE_HAMMER, "Use it to increase the yield of your ore blocks early game!", "(Use the Steam Mining Drill for an easy to get Silk Touch.)");
        MITooltips.add("stainless_steel_dust", "Use Slot-Locking with REI to differentiate its recipe from the invar dust");
        MITooltips.add("steam_blast_furnace", "Needs at least one Steel or higher tier", "hatch for 3 and 4 EU/t recipes");
        MITooltips.add(MIBlock.TRASH_CAN, "Will delete any item or fluid sent into it.", "Can also be used to empty a fluid slot", "by Right-Clicking on it with a Trash Can");
        MITooltips.add((class_1935 itemLike) -> {
            PipeItem pipe;
            class_1792 patt19156$temp = itemLike.method_8389();
            return patt19156$temp instanceof PipeItem && ((pipe = (PipeItem)patt19156$temp).isItemPipe() || pipe.isFluidPipe());
        }, "pipe", "Can be instantly retrieved by", "Right-Clicking with any Wrench.", "Use Shift + Right-Click to connect ", "directly the pipe to the target block.");
        MITooltips.add((class_1935 itemLike) -> {
            PipeItem pipe;
            class_1792 patt19460$temp = itemLike.method_8389();
            return patt19460$temp instanceof PipeItem && (pipe = (PipeItem)patt19460$temp).isCable();
        }, "cable", " ", "Can power blocks from any mod, but can", "only extract energy from Modern", "Industrialization blocks and machines.", "They also are the only cables able", "to power Modern Industrialization machines.");
    }

    public static class TooltipAttachment
    implements Comparable<TooltipAttachment> {
        public final BiFunction<class_1799, class_1792, Optional<List<? extends class_2561>>> tooltipLines;
        public boolean requiresShift = true;
        public int priority = 0;

        public static TooltipAttachment of(class_1935 itemLike, MIText text) {
            return TooltipAttachment.of(itemLike, new Line(text));
        }

        public static TooltipAttachment of(class_1935 itemLike, Line line) {
            return new TooltipAttachment((itemStack, item) -> itemStack.method_7909() == itemLike.method_8389() ? Optional.of(List.of(line.build())) : Optional.empty());
        }

        public static TooltipAttachment of(BiFunction<class_1799, class_1792, Optional<? extends class_2561>> tooltipLines) {
            return new TooltipAttachment((itemStack, item) -> ((Optional)tooltipLines.apply((class_1799)itemStack, (class_1792)item)).map(List::of));
        }

        public static TooltipAttachment ofMultilines(BiFunction<class_1799, class_1792, Optional<List<? extends class_2561>>> tooltipLines) {
            return new TooltipAttachment(tooltipLines);
        }

        public static TooltipAttachment ofMultilines(class_1935 itemLike, List<? extends class_2561> tooltipLines) {
            return new TooltipAttachment((itemStack, item) -> {
                if (itemStack.method_7909() == itemLike.method_8389()) {
                    return Optional.of(tooltipLines);
                }
                return Optional.empty();
            });
        }

        public static TooltipAttachment ofMultilines(class_1935 itemLike, MIText ... tooltipLines) {
            return TooltipAttachment.ofMultilines(itemLike, Arrays.stream(tooltipLines).map(MIText::text).collect(Collectors.toList()));
        }

        private TooltipAttachment(BiFunction<class_1799, class_1792, Optional<List<? extends class_2561>>> tooltipLines) {
            this.tooltipLines = tooltipLines;
            TOOLTIPS.add(this);
        }

        public TooltipAttachment noShiftRequired() {
            this.requiresShift = false;
            return this;
        }

        public TooltipAttachment setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public int compareTo(@NotNull TooltipAttachment o) {
            return -Integer.compare(this.priority, o.priority);
        }
    }

    public static class Line {
        public final MIText baseText;
        public final class_2583 baseStyle;
        public final List<class_2561> args = new LinkedList<class_2561>();

        public Line(MIText baseText, class_2583 style) {
            this.baseText = baseText;
            this.baseStyle = style;
        }

        public Line(MIText baseText) {
            this(baseText, DEFAULT_STYLE);
        }

        public <T> Line arg(T arg, Parser<T> parser) {
            this.args.add(parser.parse(arg));
            return this;
        }

        public Line arg(Object arg) {
            this.arg(arg, DEFAULT_PARSER);
            return this;
        }

        public class_5250 build() {
            return this.baseText.text(this.args.toArray()).method_27696(this.baseStyle);
        }
    }

    @FunctionalInterface
    public static interface Parser<T> {
        public class_2561 parse(T var1);
    }

    public record NumberWithMax(Number number, Number max) {
    }
}

