/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.forgehammer;

import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.items.ForgeTool;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_7923;

public class ForgeHammerScreenHandler
extends class_1703 {
    private final class_3915 selectedRecipe;
    private final List<MachineRecipe> availableRecipes;
    public final class_1735 output;
    public final class_1735 tool;
    public final class_1735 input;
    private final class_3914 context;
    private final class_1937 world;
    private final class_1657 player;
    private long lastSoundTime = 0L;
    private class_1799 inputStackCache = class_1799.field_8037;
    private class_1799 toolStackCache = class_1799.field_8037;

    public ForgeHammerScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public ForgeHammerScreenHandler(int syncId, class_1661 playerInventory, final class_3914 context) {
        super(ModernIndustrialization.SCREEN_HANDLER_FORGE_HAMMER, syncId);
        this.context = context;
        this.selectedRecipe = class_3915.method_17403();
        this.availableRecipes = new ArrayList<MachineRecipe>();
        this.world = playerInventory.field_7546.method_37908();
        this.player = playerInventory.field_7546;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, i * 9 + j + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.method_7621(new class_1735((class_1263)playerInventory, j, 8 + j * 18, 142));
        }
        this.input = new class_1735((class_1263)new class_1277(1){

            public void method_5431() {
                super.method_5431();
                ForgeHammerScreenHandler.this.method_7609((class_1263)this);
            }
        }, 0, 34, 33);
        this.tool = new class_1735((class_1263)new class_1277(1){

            public void method_5431() {
                super.method_5431();
                ForgeHammerScreenHandler.this.method_7609((class_1263)this);
            }
        }, 0, 8, 33){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31573(ForgeTool.TAG);
            }
        };
        this.output = new class_1735((class_1263)new class_1731(), 0, 143, 32){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                ForgeHammerScreenHandler.this.onCraft();
                context.method_17393((world, pos) -> {
                    if (ForgeHammerScreenHandler.this.lastSoundTime < world.method_8510()) {
                        world.method_8396(null, pos, class_3417.field_22463, class_3419.field_15245, 1.0f, 1.0f);
                        ForgeHammerScreenHandler.this.lastSoundTime = world.method_8510();
                    }
                });
            }
        };
        this.method_7621(this.input);
        this.method_7621(this.tool);
        this.method_7621(this.output);
        this.method_17362(this.selectedRecipe);
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.method_17407();
    }

    public List<MachineRecipe> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public int getAvailableRecipeCount() {
        return this.availableRecipes.size();
    }

    private boolean isInBounds(int id) {
        return id >= 0 && id < this.availableRecipes.size();
    }

    public void method_7609(class_1263 inventory) {
        if (!class_1799.method_7973((class_1799)this.inputStackCache, (class_1799)this.input.method_7677()) || !class_1799.method_7973((class_1799)this.toolStackCache, (class_1799)this.tool.method_7677())) {
            this.updateStatus();
        }
        super.method_7609(inventory);
    }

    public void updateStatus() {
        this.inputStackCache = this.input.method_7677().method_7972();
        this.toolStackCache = this.tool.method_7677().method_7972();
        MachineRecipe old = this.isInBounds(this.selectedRecipe.method_17407()) ? this.availableRecipes.get(this.selectedRecipe.method_17407()) : null;
        this.availableRecipes.clear();
        this.selectedRecipe.method_17404(-1);
        this.output.method_7673(class_1799.field_8037);
        if (!this.input.method_7677().method_7960()) {
            HashMap<class_2960, MachineRecipe> recipeMap = new HashMap<class_2960, MachineRecipe>();
            for (MachineRecipe recipe : MIMachineRecipeTypes.FORGE_HAMMER.getRecipes(this.world)) {
                MachineRecipe.ItemInput recipeInput = recipe.itemInputs.get(0);
                if (!recipeInput.matches(this.input.method_7677()) || recipeInput.amount > this.input.method_7677().method_7947()) continue;
                class_2960 idOutput = class_7923.field_41178.method_10221((Object)recipe.itemOutputs.get((int)0).item);
                if (recipe.eu != 0 && !this.tool.method_7677().method_7960()) {
                    recipeMap.put(idOutput, recipe);
                    continue;
                }
                if (recipe.eu != 0 || recipeMap.containsKey(idOutput)) continue;
                recipeMap.put(idOutput, recipe);
            }
            this.availableRecipes.addAll(recipeMap.values());
            this.availableRecipes.sort(Comparator.comparing(MachineRecipe::method_8114));
            for (int i = 0; i < this.availableRecipes.size(); ++i) {
                if (old != this.availableRecipes.get(i)) continue;
                this.selectedRecipe.method_17404(i);
                break;
            }
            this.populateResult();
        }
    }

    void populateResult() {
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.selectedRecipe.method_17407())) {
            MachineRecipe current = this.availableRecipes.get(this.getSelectedRecipe());
            if (current.eu == 0 || !this.tool.method_7677().method_7960() && this.tool.method_7677().method_7919() < this.tool.method_7677().method_7936()) {
                this.output.method_7673(current.method_8110(this.world.method_30349()));
            } else {
                this.output.method_7673(class_1799.field_8037);
            }
        } else {
            this.output.method_7673(class_1799.field_8037);
        }
        this.method_7623();
    }

    public boolean method_7604(class_1657 player, int id) {
        if (this.isInBounds(id)) {
            this.selectedRecipe.method_17404(id);
            this.populateResult();
        }
        return true;
    }

    private void onCraft() {
        MachineRecipe current = this.availableRecipes.get(this.selectedRecipe.method_17407());
        this.input.method_7677().method_7934(current.itemInputs.get((int)0).amount);
        if (!this.tool.method_7677().method_7960()) {
            if (!this.world.method_8608()) {
                this.tool.method_7677().method_7970(current.eu, this.world.method_8409(), (class_3222)this.player);
            }
            if (this.tool.method_7677().method_7919() >= this.tool.method_7677().method_7936()) {
                this.tool.method_7673(class_1799.field_8037);
                this.context.method_17393((world, pos) -> world.method_8396(null, pos, class_3417.field_15075, class_3419.field_15245, 1.0f, 1.0f));
            }
        } else if (current.eu > 0) {
            throw new IllegalStateException("Forge Hammer Exception : Tool crafting without a tool");
        }
        this.updateStatus();
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            class_1792 item = itemStack2.method_7909();
            itemStack = itemStack2.method_7972();
            if (index == 38) {
                item.method_7843(itemStack2, player.method_37908(), player);
                if (!this.method_7616(itemStack2, 0, 36, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemStack2, itemStack);
            } else if (index == 37 || index == 36) {
                if (!this.method_7616(itemStack2, 0, 36, false)) {
                    return class_1799.field_8037;
                }
            } else if (index < 36 && !this.method_7616(itemStack2, 36, 38, true)) {
                if (index < 27) {
                    if (!this.method_7616(itemStack2, 27, 36, false)) {
                        return class_1799.field_8037;
                    }
                } else {
                    return class_1799.field_8037;
                }
            }
            if (itemStack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            }
            slot.method_7668();
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
            this.method_7623();
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, blockPos) -> {
            this.method_7607(player, this.input.field_7871);
            this.method_7607(player, this.tool.field_7871);
        });
    }

    public void moveRecipe(class_2960 recipeId, int fillAction, int amount) {
        MachineRecipe recipe = MIMachineRecipeTypes.FORGE_HAMMER.getRecipe(this.world, recipeId);
        if (recipe == null) {
            return;
        }
        MachineRecipe.ItemInput recipeInput = recipe.itemInputs.get(0);
        boolean firstPass = true;
        while (amount > 0) {
            boolean didSomething = false;
            if (recipeInput.matches(this.input.method_7677())) {
                int targetAmount = firstPass ? recipeInput.amount : this.input.method_7677().method_7947() + recipeInput.amount;
                int delta = targetAmount - this.input.method_7677().method_7947();
                if (delta < 0) {
                    this.player.method_31548().method_7398(this.input.method_7671(-delta));
                    didSomething = true;
                } else {
                    toPull = delta;
                    for (i = 0; i < 36; ++i) {
                        slot = (class_1735)this.field_7761.get(i);
                        if (!class_1799.method_31577((class_1799)slot.method_7677(), (class_1799)this.input.method_7677()) || (toMove = Math.min(toPull, this.input.method_7676(this.input.method_7677()) - this.input.method_7677().method_7947())) <= 0) continue;
                        removed = slot.method_7671(toMove);
                        this.input.method_7677().method_7933(removed.method_7947());
                        this.input.method_7668();
                        toPull -= removed.method_7947();
                        didSomething = true;
                    }
                }
            } else {
                class_1799 oldInput = this.input.method_7671(this.input.method_7677().method_7947());
                this.player.method_31548().method_7398(oldInput);
                class_1799 matchingStack = class_1799.field_8037;
                for (int i = 0; i < 36 && matchingStack.method_7960(); ++i) {
                    class_1735 slot = (class_1735)this.field_7761.get(i);
                    if (!recipeInput.matches(slot.method_7677())) continue;
                    matchingStack = slot.method_7677().method_7972();
                }
                if (matchingStack.method_7960()) {
                    return;
                }
                toPull = recipeInput.amount;
                this.input.method_7673(matchingStack.method_7972());
                this.input.method_7677().method_7939(0);
                for (i = 0; i < 36; ++i) {
                    slot = (class_1735)this.field_7761.get(i);
                    if (!class_1799.method_31577((class_1799)slot.method_7677(), (class_1799)matchingStack) || (toMove = Math.min(toPull, this.input.method_7676(this.input.method_7677()) - this.input.method_7677().method_7947())) <= 0) continue;
                    removed = slot.method_7671(toMove);
                    this.input.method_7677().method_7933(removed.method_7947());
                    this.input.method_7668();
                    toPull -= removed.method_7947();
                    didSomething = true;
                }
            }
            if (recipe.eu > 0 && !this.tool.method_7681()) {
                for (int i = 0; i < 36; ++i) {
                    class_1735 slot = (class_1735)this.field_7761.get(i);
                    if (!slot.method_7677().method_31573(ForgeTool.TAG)) continue;
                    this.tool.method_7673(slot.method_7671(1));
                    didSomething = true;
                    break;
                }
            }
            int recipeIndex = -1;
            for (int i = 0; i < this.availableRecipes.size(); ++i) {
                if (!this.availableRecipes.get(i).method_8114().equals((Object)recipeId)) continue;
                recipeIndex = i;
                break;
            }
            if (recipeIndex == -1) {
                return;
            }
            if (this.selectedRecipe.method_17407() != recipeIndex) {
                this.selectedRecipe.method_17404(recipeIndex);
                didSomething = true;
            }
            this.populateResult();
            class_1799 oldOutput = this.output.method_7677().method_7972();
            switch (fillAction) {
                case 1: {
                    this.method_7593(this.output.field_7874, 0, class_1713.field_7790, this.player);
                    break;
                }
                case 2: {
                    this.method_7593(this.output.field_7874, 0, class_1713.field_7794, this.player);
                }
            }
            if (!class_1799.method_7973((class_1799)oldOutput, (class_1799)this.output.method_7677())) {
                didSomething = true;
            }
            --amount;
            if (!didSomething && !firstPass) break;
            firstPass = false;
        }
    }
}

