/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.usage;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.EnergyBarClient;
import aztech.modern_industrialization.machines.guicomponents.ProgressBarClient;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.RecipeConversions;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_3962;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class MachineCategory
extends ViewerCategory<MachineRecipe> {
    private final MachineCategoryParams params;

    public static MachineCategory create(MachineCategoryParams params) {
        int x = 1000;
        int X = 0;
        int y = 1000;
        int Y = 0;
        for (SlotPositions positions : new SlotPositions[]{params.itemInputs, params.itemOutputs, params.fluidInputs, params.fluidOutputs}) {
            for (int i = 0; i < positions.size(); ++i) {
                x = Math.min(x, positions.getX(i));
                X = Math.max(X, positions.getX(i) + 16);
                y = Math.min(y, positions.getY(i));
                Y = Math.max(Y, positions.getY(i) + 16);
            }
        }
        int width = Math.max(X - x + 15, 120);
        int height = Y - y + 25;
        return new MachineCategory(params, width, height);
    }

    private MachineCategory(MachineCategoryParams params, int width, int height) {
        super(MachineRecipe.class, (class_2960)new MIIdentifier(params.category), (class_2561)class_2561.method_43471((String)("rei_categories.modern_industrialization." + params.category)), ((class_1792)class_7923.field_41178.method_10223(params.workstations.get(0))).method_7854(), width, height);
        this.params = params;
    }

    @Override
    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
        for (class_2960 workstation : this.params.workstations) {
            consumer.accept((class_1935)class_7923.field_41178.method_10223(workstation));
        }
    }

    @Override
    public void buildRecipes(class_1863 recipeManager, class_5455 registryAccess, Consumer<MachineRecipe> consumer) {
        List<MachineRecipe> machineRecipes = recipeManager.method_8126().stream().filter(r -> r instanceof MachineRecipe).map(r -> (MachineRecipe)r).toList();
        machineRecipes.stream().filter(this.params.recipePredicate).sorted(Comparator.comparing(MachineRecipe::method_8114)).forEach(consumer);
        switch (this.params.category) {
            case "bronze_furnace": {
                recipeManager.method_30027(class_3956.field_17546).stream().map(r -> RecipeConversions.of(r, MIMachineRecipeTypes.FURNACE, registryAccess)).forEach(consumer);
                break;
            }
            case "bronze_cutting_machine": {
                recipeManager.method_30027(class_3956.field_17641).stream().map(r -> RecipeConversions.of(r, MIMachineRecipeTypes.CUTTING_MACHINE, registryAccess)).forEach(consumer);
                break;
            }
            case "centrifuge": {
                class_3962.field_17566.keySet().stream().map(RecipeConversions::ofCompostable).filter(Objects::nonNull).forEach(consumer);
            }
        }
    }

    @Override
    public void buildLayout(MachineRecipe recipe, ViewerCategory.LayoutBuilder builder) {
        this.addItemInputs(builder, recipe);
        this.addItemOutputs(builder, recipe);
        this.addFluidInputs(builder, recipe);
        this.addFluidOutputs(builder, recipe);
    }

    private void addItemInputs(ViewerCategory.LayoutBuilder builder, MachineRecipe recipe) {
        DrawOffset offset = this.getOffset();
        SlotPositions positions = this.params.itemInputs;
        for (int i = 0; i < positions.size(); ++i) {
            int x = offset.x + positions.getX(i);
            int y = offset.y + positions.getY(i);
            ViewerCategory.SlotBuilder slot = builder.inputSlot(x, y);
            if (i >= recipe.itemInputs.size()) continue;
            MachineRecipe.ItemInput input = recipe.itemInputs.get(i);
            slot.ingredient(input.ingredient, input.amount, input.probability);
        }
    }

    private void addItemOutputs(ViewerCategory.LayoutBuilder builder, MachineRecipe recipe) {
        DrawOffset offset = this.getOffset();
        SlotPositions positions = this.params.itemOutputs;
        for (int i = 0; i < positions.size(); ++i) {
            int x = offset.x + positions.getX(i);
            int y = offset.y + positions.getY(i);
            ViewerCategory.SlotBuilder slot = builder.outputSlot(x, y);
            if (i >= recipe.itemOutputs.size()) continue;
            MachineRecipe.ItemOutput output = recipe.itemOutputs.get(i);
            slot.item(output.getStack(), output.probability);
        }
    }

    private void addFluidInputs(ViewerCategory.LayoutBuilder builder, MachineRecipe recipe) {
        DrawOffset offset = this.getOffset();
        SlotPositions positions = this.params.fluidInputs;
        for (int i = 0; i < positions.size(); ++i) {
            int x = offset.x + positions.getX(i);
            int y = offset.y + positions.getY(i);
            ViewerCategory.SlotBuilder slot = builder.inputSlot(x, y);
            if (i < recipe.fluidInputs.size()) {
                MachineRecipe.FluidInput input = recipe.fluidInputs.get(i);
                slot.fluid(FluidVariant.of((class_3611)input.fluid), input.amount, input.probability);
                continue;
            }
            slot.variant((TransferVariant<?>)FluidVariant.blank());
        }
    }

    private void addFluidOutputs(ViewerCategory.LayoutBuilder builder, MachineRecipe recipe) {
        DrawOffset offset = this.getOffset();
        SlotPositions positions = this.params.fluidOutputs;
        for (int i = 0; i < positions.size(); ++i) {
            int x = offset.x + positions.getX(i);
            int y = offset.y + positions.getY(i);
            ViewerCategory.SlotBuilder slot = builder.outputSlot(x, y);
            if (i < recipe.fluidOutputs.size()) {
                MachineRecipe.FluidOutput output = recipe.fluidOutputs.get(i);
                slot.fluid(FluidVariant.of((class_3611)output.fluid), output.amount, output.probability);
                continue;
            }
            slot.variant((TransferVariant<?>)FluidVariant.blank());
        }
    }

    @Override
    public void buildWidgets(MachineRecipe recipe, ViewerCategory.WidgetList widgets) {
        boolean conditionsRequired;
        DrawOffset offset = this.getOffset();
        double recipeMillis = this.getSeconds(recipe) * 1000.0;
        widgets.drawable(matrices -> ProgressBarClient.renderProgress(matrices, offset.x, offset.y, this.params.progressBarParams, (float)((double)System.currentTimeMillis() / recipeMillis % 1.0)));
        widgets.drawable(guiGraphics -> {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(5.0f, 5.0f, 0.0f);
            guiGraphics.method_51448().method_22905(0.5f, 0.5f, 0.5f);
            switch (this.params.steamMode) {
                case BOTH: {
                    guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, -2, -2, 80, 18, 20, 20);
                    break;
                }
                case STEAM_ONLY: {
                    guiGraphics.method_25290((class_2960)new MIIdentifier("textures/item/steam_bucket.png"), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                    break;
                }
                case ELECTRIC_ONLY: {
                    EnergyBarClient.Renderer.renderEnergy(guiGraphics, 0, 0, 1.0f);
                }
            }
            guiGraphics.method_51448().method_22909();
        });
        widgets.text((class_2561)TextHelper.getEuTextTick(recipe.eu), 15 + (this.params.steamMode.steam ? 2 : 0), 5.0f, ViewerCategory.TextAlign.LEFT, false, true, null);
        widgets.text((class_2561)MIText.BaseDurationSeconds.text(this.getSeconds(recipe)), this.width - 5, 5.0f, ViewerCategory.TextAlign.RIGHT, false, true, null);
        boolean steelHatchRequired = this.params.steamMode.steam && this.params.isMultiblock && recipe.eu > MachineTier.BRONZE.getMaxEu();
        int upgradeEuRequired = recipe.eu - (this.params.isMultiblock ? MachineTier.MULTIBLOCK : MachineTier.LV).getMaxEu();
        if (upgradeEuRequired > 0 && this.id.method_12832().equals("fusion_reactor")) {
            upgradeEuRequired = 0;
        }
        boolean bl = conditionsRequired = recipe.conditions.size() > 0;
        if (steelHatchRequired || upgradeEuRequired > 0 || conditionsRequired) {
            Object displayedItem = steelHatchRequired ? (class_1935)class_7923.field_41178.method_10223((class_2960)new MIIdentifier("steel_item_input_hatch")) : (conditionsRequired ? MIItem.WRENCH : MIItem.BASIC_UPGRADE);
            widgets.item((float)this.width / 2.0f - 3.0f, 3.75, 10.8, 10.8, (class_1935)displayedItem);
        }
        ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
        tooltips.add((class_2561)MIText.BaseEuTotal.text(TextHelper.getEuText((long)recipe.duration * (long)recipe.eu)));
        if (this.params.steamMode.steam) {
            tooltips.add((class_2561)(this.params.steamMode.electric ? MIText.AcceptsSteamToo : MIText.AcceptsSteam).text().method_27692(class_124.field_1080));
            if (steelHatchRequired) {
                tooltips.add((class_2561)MIText.RequiresSteelHatch0.text().method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true))));
                tooltips.add((class_2561)MIText.RequiresSteelHatch1.text().method_27692(class_124.field_1080));
            }
        }
        if (upgradeEuRequired > 0) {
            tooltips.add((class_2561)new MITooltips.Line(MIText.RequiresUpgrades).arg(upgradeEuRequired, MITooltips.EU_PER_TICK_PARSER).build());
        }
        if (conditionsRequired) {
            for (MachineProcessCondition condition : recipe.conditions) {
                condition.appendDescription(tooltips);
            }
        }
        widgets.tooltip(2, 5, this.width - 10, 11, tooltips);
    }

    private double getSeconds(MachineRecipe recipe) {
        return (double)recipe.duration / 20.0;
    }

    private DrawOffset getOffset() {
        int x = 1000;
        int X = 0;
        int y = 1000;
        int Y = 0;
        for (SlotPositions positions : new SlotPositions[]{this.params.itemInputs, this.params.itemOutputs, this.params.fluidInputs, this.params.fluidOutputs}) {
            for (int i = 0; i < positions.size(); ++i) {
                x = Math.min(x, positions.getX(i));
                X = Math.max(X, positions.getX(i) + 16);
                y = Math.min(y, positions.getY(i));
                Y = Math.max(Y, positions.getY(i) + 16);
            }
        }
        int xoffset = (this.width - X + x) / 2 - x;
        int yoffset = 17 - y;
        return new DrawOffset(xoffset, yoffset);
    }

    @Environment(value=EnvType.CLIENT)
    private record DrawOffset(int x, int y) {
    }
}

