/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class CasingComponent
implements IComponent {
    private CableTier tierCasing;
    private final CableTier defaultCasing;
    public static final BiMap<class_2248, CableTier> blockCasing = HashBiMap.create();

    public CasingComponent(CableTier defaultCasing) {
        this.defaultCasing = defaultCasing;
        this.tierCasing = defaultCasing;
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10582("casing", this.tierCasing.name);
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.tierCasing = CableTier.getTier(tag.method_10558("casing"));
        if (this.tierCasing == null) {
            this.tierCasing = this.defaultCasing;
        }
    }

    @Override
    public void writeClientNbt(class_2487 tag) {
        tag.method_10582("casing", this.tierCasing.name);
    }

    @Override
    public void readClientNbt(class_2487 tag) {
        this.tierCasing = CableTier.getTier(tag.method_10558("casing"));
        if (this.tierCasing == null) {
            this.tierCasing = this.defaultCasing;
        }
    }

    public void dropCasing(class_1937 world, class_2338 pos) {
        class_1799 stack = new class_1799((class_1935)((class_2248)blockCasing.inverse().get((Object)this.tierCasing)).method_8389(), 1);
        class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack);
    }

    public class_1269 onUse(MachineBlockEntity be, class_1657 player, class_1268 hand) {
        CableTier newTier;
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_7947() >= 1 && (newTier = CasingComponent.getCasingTier(stackInHand.method_7909())) != null && newTier != this.defaultCasing && newTier != this.tierCasing) {
            if (this.defaultCasing != this.tierCasing) {
                this.dropCasing(be.method_10997(), be.method_11016());
            }
            this.tierCasing = newTier;
            if (!player.method_7337()) {
                stackInHand.method_7934(1);
            }
            be.method_5431();
            if (!be.method_10997().method_8608()) {
                be.sync();
            }
            this.playCasingPlaceSound(be);
            return class_1269.method_29236((boolean)be.method_10997().field_9236);
        }
        return class_1269.field_5811;
    }

    private void playCasingPlaceSound(MachineBlockEntity be) {
        if (this.tierCasing == this.defaultCasing) {
            return;
        }
        class_2680 casingState = ((class_2248)blockCasing.inverse().get((Object)this.tierCasing)).method_9564();
        class_2498 group = casingState.method_26231();
        class_3414 sound = group.method_10595();
        be.method_10997().method_8396(null, be.method_11016(), sound, class_3419.field_15245, (group.method_10597() + 1.0f) / 4.0f, group.method_10599() * 0.8f);
    }

    @Nullable
    private static CableTier getCasingTier(class_1792 item) {
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            return (CableTier)((Object)blockCasing.get((Object)blockItem.method_7711()));
        }
        return null;
    }

    public class_1799 getDrop() {
        if (this.tierCasing != this.defaultCasing) {
            return new class_1799((class_1935)((class_2248)blockCasing.inverse().get((Object)this.tierCasing)).method_8389(), 1);
        }
        return class_1799.field_8037;
    }

    public void setCasingServer(MachineBlockEntity be, class_1799 casing) {
        CableTier tier;
        if (casing.method_7960()) {
            this.tierCasing = this.defaultCasing;
            be.method_5431();
            be.sync();
            be.method_10997().method_8408(be.method_11016(), class_2246.field_10124);
        }
        if ((tier = CasingComponent.getCasingTier(casing.method_7909())) != null && tier != this.defaultCasing) {
            this.tierCasing = tier;
            be.method_5431();
            be.sync();
            be.method_10997().method_8408(be.method_11016(), class_2246.field_10124);
        }
        this.playCasingPlaceSound(be);
    }

    public MachineCasing getCasing() {
        return MachineCasings.casingFromCableTier(this.tierCasing);
    }

    public boolean canInsertEu(CableTier tier) {
        return tier == this.tierCasing;
    }

    public long getEuCapacity() {
        return this.tierCasing.getEu() * 100L;
    }

    static {
        blockCasing.put((Object)MIBlock.BASIC_MACHINE_HULL.asBlock(), (Object)CableTier.LV);
        blockCasing.put((Object)MIBlock.ADVANCED_MACHINE_HULL.asBlock(), (Object)CableTier.MV);
        blockCasing.put((Object)MIBlock.TURBO_MACHINE_HULL.asBlock(), (Object)CableTier.HV);
        blockCasing.put((Object)MIBlock.HIGHLY_ADVANCED_MACHINE_HULL.asBlock(), (Object)CableTier.EV);
        blockCasing.put((Object)MIBlock.QUANTUM_MACHINE_HULL.asBlock(), (Object)CableTier.SUPERCONDUCTOR);
    }
}

