/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class ShapeSelection {

    public static class Server
    implements GuiComponent.Server<int[]> {
        public final Behavior behavior;
        private final List<LineInfo> lines;

        public Server(Behavior behavior, LineInfo ... lines) {
            Preconditions.checkArgument((lines.length > 0 ? 1 : 0) != 0);
            this.behavior = behavior;
            this.lines = List.of(lines);
        }

        @Override
        public int[] copyData() {
            return IntStream.range(0, this.lines.size()).map(this.behavior::getCurrentIndex).toArray();
        }

        @Override
        public boolean needsSync(int[] cachedData) {
            for (int i = 0; i < this.lines.size(); ++i) {
                if (cachedData[i] == this.behavior.getCurrentIndex(i)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            buf.method_10804(this.lines.size());
            for (LineInfo line : this.lines) {
                buf.method_10804(line.numValues);
                for (class_2561 class_25612 : line.translations) {
                    buf.method_10805(class_25612);
                }
                buf.writeBoolean(line.useArrows);
            }
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            for (int i = 0; i < this.lines.size(); ++i) {
                buf.method_10804(this.behavior.getCurrentIndex(i));
            }
        }

        @Override
        public class_2960 getId() {
            return GuiComponents.SHAPE_SELECTION;
        }
    }

    public record LineInfo(int numValues, List<? extends class_2561> translations, boolean useArrows) {
        public LineInfo {
            Preconditions.checkArgument((numValues == translations.size() ? 1 : 0) != 0);
        }
    }

    public static interface Behavior {
        public void handleClick(int var1, int var2);

        public int getCurrentIndex(int var1);
    }
}

