/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.inventory.HackySlot;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SlotPanel {
    public static int getSlotX(MachineGuiParameters guiParameters) {
        return guiParameters.backgroundWidth + 6;
    }

    public static int getSlotY(int slotIndex) {
        return 19 + slotIndex * 20;
    }

    public static enum SlotType {
        UPGRADES(SlotGroup.UPGRADES, 64, stack -> UpgradeComponent.getExtraEu((class_1935)stack.method_7909()) > 0L, 0, 80, MIText.AcceptsUpgrades),
        CASINGS(SlotGroup.CASING, 1, stack -> {
            class_1747 block;
            class_1792 patt5108$temp = stack.method_7909();
            if (patt5108$temp instanceof class_1747 && (block = (class_1747)patt5108$temp) != MIBlock.BASIC_MACHINE_HULL.method_8389()) {
                return CasingComponent.blockCasing.containsKey((Object)block.method_7711());
            }
            return false;
        }, 18, 80, MIText.AcceptsMachineHull);

        public final SlotGroup group;
        public final int slotLimit;
        public final Predicate<class_1799> insertionChecker;
        public final int u;
        public final int v;
        public final MIText tooltip;

        private SlotType(SlotGroup group, int slotLimit, Predicate<class_1799> insertionChecker, int u, int v, MIText tooltip) {
            this.group = group;
            this.slotLimit = slotLimit;
            this.insertionChecker = insertionChecker;
            this.u = u;
            this.v = v;
            this.tooltip = tooltip;
        }

        public boolean mayPlace(class_1799 stack) {
            return this.insertionChecker.test(stack);
        }
    }

    public static class Server
    implements GuiComponent.ServerNoData {
        private final MachineBlockEntity machine;
        private final List<Consumer<GuiComponent.MenuFacade>> slotFactories = new ArrayList<Consumer<GuiComponent.MenuFacade>>();
        private final List<SlotType> slotTypes = new ArrayList<SlotType>();

        public Server(MachineBlockEntity machine) {
            this.machine = machine;
        }

        public Server withUpgrades(UpgradeComponent upgradeComponent) {
            return this.addSlot(SlotType.UPGRADES, () -> upgradeComponent.getDrop().method_7972(), upgradeComponent::setStackServer);
        }

        public Server withCasing(CasingComponent casingComponent) {
            return this.addSlot(SlotType.CASINGS, () -> casingComponent.getDrop().method_7972(), casingComponent::setCasingServer);
        }

        private Server addSlot(final SlotType type, final Supplier<class_1799> getStack, final BiConsumer<MachineBlockEntity, class_1799> setStack) {
            int slotIndex = this.slotTypes.size();
            this.slotFactories.add(facade -> facade.addSlotToMenu(new HackySlot(SlotPanel.getSlotX(this.machine.guiParams), SlotPanel.getSlotY(slotIndex)){

                @Override
                protected class_1799 getRealStack() {
                    return (class_1799)getStack.get();
                }

                @Override
                protected void setRealStack(class_1799 stack) {
                    setStack.accept(machine, stack);
                }

                public boolean method_7680(class_1799 stack) {
                    return type.mayPlace(stack);
                }

                public int method_7675() {
                    return type.slotLimit;
                }
            }, type.group));
            this.slotTypes.add(type);
            return this;
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            buf.method_10804(this.slotFactories.size());
            for (SlotType type : this.slotTypes) {
                buf.method_10817((Enum)type);
            }
        }

        @Override
        public class_2960 getId() {
            return GuiComponents.SLOT_PANEL;
        }

        @Override
        public void setupMenu(GuiComponent.MenuFacade menu) {
            for (Consumer<GuiComponent.MenuFacade> factory : this.slotFactories) {
                factory.accept(menu);
            }
        }
    }
}

