/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartEnglishNameFormatter;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import org.jetbrains.annotations.Nullable;

public class CasingPart
implements PartKeyProvider {
    public final String englishName;
    public final PartKey key;

    public CasingPart(String englishName, String key) {
        this.englishName = englishName;
        this.key = new PartKey(key);
    }

    @Override
    public PartKey key() {
        return this.key;
    }

    public PartTemplate of(PartEnglishNameFormatter formatter, @Nullable String path, float resistance) {
        PartTemplate regPart = new PartTemplate(formatter, this.key).asBlock(SortOrder.CASINGS, new TextureGenParams.CasingBlock(this.equals(MIParts.MACHINE_CASING)), 5.0f, resistance, 1, false);
        if (path != null) {
            return regPart.withCustomPath(path, path);
        }
        return regPart;
    }

    public PartTemplate of(String englishName, String path, float resistance) {
        return this.of(new PartEnglishNameFormatter.Overridden(englishName), path, resistance);
    }

    public PartTemplate of(String englishName, String path) {
        return this.of(new PartEnglishNameFormatter.Overridden(englishName), path, 6.0f);
    }

    public PartTemplate of(float resistance) {
        return this.of(new PartEnglishNameFormatter.Default(this.englishName), null, resistance);
    }

    public PartTemplate of() {
        return this.of(6.0f);
    }
}

