/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.electricity;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.pipes.PipeStatsCollector;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkData;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_3218;
import team.reborn.energy.api.EnergyStorage;

public class ElectricityNetwork
extends PipeNetwork {
    private static final List<MIEnergyStorage> STORAGES_CACHE = new ArrayList<MIEnergyStorage>();
    final CableTier tier;
    final PipeStatsCollector stats = new PipeStatsCollector();

    public ElectricityNetwork(int id, PipeNetworkData data, CableTier tier) {
        super(id, data == null ? new ElectricityNetworkData() : data);
        this.tier = tier;
    }

    @Override
    public void tick(class_3218 world) {
        List<MIEnergyStorage> storages = STORAGES_CACHE;
        long networkAmount = 0L;
        int loadedNodeCount = 0;
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            ElectricityNetworkNode node = (ElectricityNetworkNode)entry.getNode();
            node.appendAttributes(world, entry.getPos(), this.tier, storages);
            networkAmount += node.eu;
            ++loadedNodeCount;
        }
        storages.removeIf(s -> !s.canConnect(this.tier));
        long networkCapacity = (long)loadedNodeCount * this.tier.getMaxTransfer();
        try (Transaction tx = Transaction.openOuter();){
            long extractMaxAmount = Math.min(this.tier.getMaxTransfer(), networkCapacity - networkAmount);
            long extracted = ElectricityNetwork.transferForTargets(EnergyStorage::extract, storages, extractMaxAmount, (TransactionContext)tx);
            long insertMaxAmount = Math.min(this.tier.getMaxTransfer(), networkAmount += extracted);
            long inserted = ElectricityNetwork.transferForTargets(EnergyStorage::insert, storages, insertMaxAmount, (TransactionContext)tx);
            networkAmount -= inserted;
            tx.commit();
            this.stats.addValue(Math.max(extracted, inserted));
        }
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            ElectricityNetworkNode electricityNode = (ElectricityNetworkNode)entry.getNode();
            electricityNode.eu = networkAmount / (long)loadedNodeCount;
            networkAmount -= electricityNode.eu;
            --loadedNodeCount;
        }
        storages.clear();
    }

    private static long transferForTargets(TransferOperation operation, List<MIEnergyStorage> targets, long maxAmount, TransactionContext transaction) {
        ArrayList<EnergyTarget> sortableTargets = new ArrayList<EnergyTarget>(targets.size());
        for (MIEnergyStorage mIEnergyStorage : targets) {
            sortableTargets.add(new EnergyTarget(mIEnergyStorage));
        }
        Collections.shuffle(sortableTargets);
        for (EnergyTarget energyTarget : sortableTargets) {
            Transaction nested = transaction.openNested();
            try {
                energyTarget.simulationResult = operation.transfer(energyTarget.target, maxAmount, (TransactionContext)nested);
            }
            finally {
                if (nested == null) continue;
                nested.close();
            }
        }
        sortableTargets.sort(Comparator.comparingLong(t -> t.simulationResult));
        long transferredAmount = 0L;
        for (int i = 0; i < sortableTargets.size(); ++i) {
            EnergyTarget target = (EnergyTarget)sortableTargets.get(i);
            int remainingTargets = sortableTargets.size() - i;
            long remainingAmount = maxAmount - transferredAmount;
            long targetMaxAmount = remainingAmount / (long)remainingTargets;
            transferredAmount += operation.transfer(target.target, targetMaxAmount, transaction);
        }
        return transferredAmount;
    }

    @FunctionalInterface
    private static interface TransferOperation {
        public long transfer(MIEnergyStorage var1, long var2, TransactionContext var4);
    }

    private static class EnergyTarget {
        final MIEnergyStorage target;
        long simulationResult;

        EnergyTarget(MIEnergyStorage target) {
            this.target = target;
        }
    }
}

