/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.peripheral;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;

public final class PeripheralType {
    private static final PeripheralType UNTYPED = new PeripheralType(null, Collections.emptySet());
    @Nullable
    private final String type;
    private final Set<String> additionalTypes;

    public PeripheralType(@Nullable String type, Set<String> additionalTypes) {
        this.type = type;
        this.additionalTypes = additionalTypes;
        for (String item : additionalTypes) {
            if (item != null) continue;
            throw new NullPointerException("All additional types must be non-null");
        }
    }

    public static PeripheralType untyped() {
        return UNTYPED;
    }

    public static PeripheralType ofType(String type) {
        PeripheralType.checkTypeName("type cannot be null or empty");
        return new PeripheralType(type, Collections.emptySet());
    }

    public static PeripheralType ofType(String type, Collection<String> additionalTypes) {
        PeripheralType.checkTypeName("type cannot be null or empty");
        return new PeripheralType(type, PeripheralType.getTypes(additionalTypes));
    }

    public static PeripheralType ofType(String type, String ... additionalTypes) {
        PeripheralType.checkTypeName(type);
        return new PeripheralType(type, Set.of(additionalTypes));
    }

    public static PeripheralType ofAdditional(Collection<String> additionalTypes) {
        return new PeripheralType(null, PeripheralType.getTypes(additionalTypes));
    }

    public static PeripheralType ofAdditional(String ... additionalTypes) {
        return new PeripheralType(null, Set.of(additionalTypes));
    }

    @Nullable
    public String getPrimaryType() {
        return this.type;
    }

    public Set<String> getAdditionalTypes() {
        return this.additionalTypes;
    }

    private static void checkTypeName(@Nullable String type) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("type cannot be null or empty");
        }
    }

    private static Set<String> getTypes(Collection<String> types) {
        if (types.isEmpty()) {
            return Collections.emptySet();
        }
        if (types.size() == 1) {
            return Collections.singleton(types.iterator().next());
        }
        return Set.copyOf(types);
    }
}

