/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.pocket;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PocketComputerData {
    private final NetworkedTerminal terminal;
    private ComputerState state = ComputerState.OFF;
    private int lightColour = -1;

    public PocketComputerData(boolean colour) {
        this.terminal = new NetworkedTerminal(Config.pocketTermWidth, Config.pocketTermHeight, colour);
    }

    public int getLightState() {
        return this.state != ComputerState.OFF ? this.lightColour : -1;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public ComputerState getState() {
        return this.state;
    }

    public void setState(ComputerState state, int lightColour) {
        this.state = state;
        this.lightColour = lightColour;
    }

    public void setTerminal(TerminalState state) {
        state.apply(this.terminal);
    }
}

