/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.CoreConfig;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.TableHelper;
import dan200.computercraft.core.apis.http.CheckUrl;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import dan200.computercraft.core.apis.http.Resource;
import dan200.computercraft.core.apis.http.ResourceGroup;
import dan200.computercraft.core.apis.http.ResourceQueue;
import dan200.computercraft.core.apis.http.request.HttpRequest;
import dan200.computercraft.core.apis.http.websocket.Websocket;
import dan200.computercraft.core.apis.http.websocket.WebsocketClient;
import dan200.computercraft.core.util.ArgumentHelpers;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class HTTPAPI
implements ILuaAPI {
    private static final double DEFAULT_TIMEOUT = 30.0;
    private static final double MAX_TIMEOUT = 60.0;
    private final IAPIEnvironment apiEnvironment;
    private final ResourceGroup<CheckUrl> checkUrls = new ResourceGroup(() -> 512);
    private final ResourceGroup<HttpRequest> requests = new ResourceQueue<HttpRequest>(() -> CoreConfig.httpMaxRequests);
    private final ResourceGroup<Websocket> websockets = new ResourceGroup(() -> CoreConfig.httpMaxWebsockets);

    public HTTPAPI(IAPIEnvironment environment) {
        this.apiEnvironment = environment;
    }

    @Override
    public String[] getNames() {
        return new String[]{"http"};
    }

    @Override
    public void startup() {
        this.checkUrls.startup();
        this.requests.startup();
        this.websockets.startup();
    }

    @Override
    public void shutdown() {
        this.checkUrls.shutdown();
        this.requests.shutdown();
        this.websockets.shutdown();
    }

    @Override
    public void update() {
        Resource.cleanup();
    }

    @LuaFunction
    public final Object[] request(IArguments args) throws LuaException {
        HttpMethod httpMethod;
        Optional<Double> timeoutArg;
        boolean redirect;
        String requestMethod;
        boolean binary;
        Map<Object, Object> headerTable;
        String postString;
        String address;
        if (args.get(0) instanceof Map) {
            Map<?, ?> options = args.getTable(0);
            address = TableHelper.getStringField(options, "url");
            postString = TableHelper.optStringField(options, "body", null);
            headerTable = TableHelper.optTableField(options, "headers", Collections.emptyMap());
            binary = TableHelper.optBooleanField(options, "binary", false);
            requestMethod = TableHelper.optStringField(options, "method", null);
            redirect = TableHelper.optBooleanField(options, "redirect", true);
            timeoutArg = TableHelper.optRealField(options, "timeout");
        } else {
            address = args.getString(0);
            postString = args.optString(1, null);
            headerTable = args.optTable(2, Collections.emptyMap());
            binary = args.optBoolean(3, false);
            requestMethod = null;
            redirect = true;
            timeoutArg = Optional.empty();
        }
        HttpHeaders headers = this.getHeaders(headerTable);
        int timeout = HTTPAPI.getTimeout(timeoutArg);
        if (requestMethod == null) {
            httpMethod = postString == null ? HttpMethod.GET : HttpMethod.POST;
        } else {
            httpMethod = HttpMethod.valueOf((String)requestMethod.toUpperCase(Locale.ROOT));
            if (httpMethod == null || requestMethod.equalsIgnoreCase("CONNECT")) {
                throw new LuaException("Unsupported HTTP method");
            }
        }
        try {
            URI uri = HttpRequest.checkUri(address);
            HttpRequest request = new HttpRequest(this.requests, this.apiEnvironment, address, postString, headers, binary, redirect, timeout);
            if (!request.queue(r -> r.request(uri, httpMethod))) {
                throw new LuaException("Too many ongoing HTTP requests");
            }
            return new Object[]{true};
        }
        catch (HTTPRequestException e) {
            return new Object[]{false, e.getMessage()};
        }
    }

    @LuaFunction
    public final Object[] checkURL(String address) throws LuaException {
        try {
            URI uri = HttpRequest.checkUri(address);
            if (!new CheckUrl(this.checkUrls, this.apiEnvironment, address, uri).queue(CheckUrl::run)) {
                throw new LuaException("Too many ongoing checkUrl calls");
            }
            return new Object[]{true};
        }
        catch (HTTPRequestException e) {
            return new Object[]{false, e.getMessage()};
        }
    }

    @LuaFunction
    public final Object[] websocket(IArguments args) throws LuaException {
        Optional<Double> timeoutArg;
        Map<Object, Object> headerTable;
        String address;
        if (!CoreConfig.httpWebsocketEnabled) {
            throw new LuaException("Websocket connections are disabled");
        }
        if (args.get(0) instanceof Map) {
            Map<?, ?> options = args.getTable(0);
            address = TableHelper.getStringField(options, "url");
            headerTable = TableHelper.optTableField(options, "headers", Collections.emptyMap());
            timeoutArg = TableHelper.optRealField(options, "timeout");
        } else {
            address = args.getString(0);
            headerTable = args.optTable(1, Collections.emptyMap());
            timeoutArg = Optional.empty();
        }
        HttpHeaders headers = this.getHeaders(headerTable);
        int timeout = HTTPAPI.getTimeout(timeoutArg);
        try {
            URI uri = WebsocketClient.parseUri(address);
            if (!new Websocket(this.websockets, this.apiEnvironment, uri, address, headers, timeout).queue(Websocket::connect)) {
                throw new LuaException("Too many websockets already open");
            }
            return new Object[]{true};
        }
        catch (HTTPRequestException e) {
            return new Object[]{false, e.getMessage()};
        }
    }

    private HttpHeaders getHeaders(Map<?, ?> headerTable) throws LuaException {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        for (Map.Entry<?, ?> entry : headerTable.entrySet()) {
            Object value = entry.getValue();
            if (!(entry.getKey() instanceof String) || !(value instanceof String)) continue;
            try {
                headers.add((String)entry.getKey(), value);
            }
            catch (IllegalArgumentException e) {
                throw new LuaException(e.getMessage());
            }
        }
        if (!headers.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.apiEnvironment.getGlobalEnvironment().getUserAgent());
        }
        return headers;
    }

    private static int getTimeout(Optional<Double> timeoutArg) throws LuaException {
        double timeout = timeoutArg.orElse(30.0);
        ArgumentHelpers.assertBetween(timeout, 0.0, 60.0, "timeout out of range (%s)");
        return (int)(timeout * 1000.0);
    }
}

