/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.core.apis.handles.HandleGeneric;
import dan200.computercraft.core.filesystem.TrackingCloseable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Optional;
import javax.annotation.Nullable;

public class BinaryWritableHandle
extends HandleGeneric {
    final SeekableByteChannel channel;
    private final ByteBuffer single = ByteBuffer.allocate(1);

    protected BinaryWritableHandle(SeekableByteChannel channel, TrackingCloseable closeable) {
        super(closeable);
        this.channel = channel;
    }

    public static BinaryWritableHandle of(SeekableByteChannel channel, TrackingCloseable closeable, boolean canSeek) {
        return canSeek ? new Seekable(channel, closeable) : new BinaryWritableHandle(channel, closeable);
    }

    @LuaFunction
    public final void write(IArguments arguments) throws LuaException {
        block4: {
            this.checkOpen();
            try {
                Object arg = arguments.get(0);
                if (arg instanceof Number) {
                    int number = ((Number)arg).intValue();
                    this.single.clear();
                    this.single.put((byte)number);
                    this.single.flip();
                    this.channel.write(this.single);
                    break block4;
                }
                if (arg instanceof String) {
                    this.channel.write(arguments.getBytes(0));
                    break block4;
                }
                throw LuaValues.badArgumentOf(arguments, 0, "string or number");
            }
            catch (IOException e) {
                throw new LuaException(e.getMessage());
            }
        }
    }

    @LuaFunction
    public final void flush() throws LuaException {
        this.checkOpen();
        try {
            SeekableByteChannel seekableByteChannel = this.channel;
            if (seekableByteChannel instanceof FileChannel) {
                FileChannel channel = (FileChannel)seekableByteChannel;
                channel.force(false);
            }
        }
        catch (IOException e) {
            throw new LuaException(e.getMessage());
        }
    }

    public static class Seekable
    extends BinaryWritableHandle {
        public Seekable(SeekableByteChannel channel, TrackingCloseable closeable) {
            super(channel, closeable);
        }

        @Nullable
        @LuaFunction
        public final Object[] seek(Optional<String> whence, Optional<Long> offset) throws LuaException {
            this.checkOpen();
            return Seekable.handleSeek(this.channel, whence, offset);
        }
    }
}

