/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.filesystem.TrackingCloseable;
import dan200.computercraft.core.util.IoUtil;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class HandleGeneric {
    @Nullable
    private TrackingCloseable closeable;

    protected HandleGeneric(TrackingCloseable closeable) {
        this.closeable = closeable;
    }

    protected void checkOpen() throws LuaException {
        TrackingCloseable closeable = this.closeable;
        if (closeable == null || !closeable.isOpen()) {
            throw new LuaException("attempt to use a closed file");
        }
    }

    protected final void close() {
        IoUtil.closeQuietly(this.closeable);
        this.closeable = null;
    }

    @LuaFunction(value={"close"})
    public final void doClose() throws LuaException {
        this.checkOpen();
        this.close();
    }

    @Nullable
    protected static Object[] handleSeek(SeekableByteChannel channel, Optional<String> whence, Optional<Long> offset) throws LuaException {
        long actualOffset = offset.orElse(0L);
        try {
            switch (whence.orElse("cur")) {
                case "set": {
                    channel.position(actualOffset);
                    break;
                }
                case "cur": {
                    channel.position(channel.position() + actualOffset);
                    break;
                }
                case "end": {
                    channel.position(channel.size() + actualOffset);
                    break;
                }
                default: {
                    throw new LuaException("bad argument #1 to 'seek' (invalid option '" + whence + "'");
                }
            }
            return new Object[]{channel.position()};
        }
        catch (IllegalArgumentException e) {
            return new Object[]{null, "Position is negative"};
        }
        catch (IOException e) {
            return null;
        }
    }
}

