/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.websocket;

import com.google.common.base.Objects;
import dan200.computercraft.api.lua.Coerced;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.core.apis.http.websocket.WebsocketClient;
import java.util.Arrays;
import java.util.Optional;

public class WebsocketHandle {
    private final IAPIEnvironment environment;
    private final String address;
    private final WebsocketClient websocket;
    private final Options options;

    public WebsocketHandle(IAPIEnvironment environment, String address, WebsocketClient websocket, Options options) {
        this.environment = environment;
        this.address = address;
        this.websocket = websocket;
        this.options = options;
    }

    @LuaFunction
    public final MethodResult receive(Optional<Double> timeout) throws LuaException {
        this.checkOpen();
        int timeoutId = timeout.isPresent() ? this.environment.startTimer(Math.round(LuaValues.checkFinite(0, timeout.get()) / 0.05)) : -1;
        return (WebsocketHandle)this.new ReceiveCallback((int)timeoutId).pull;
    }

    @LuaFunction
    public final void send(Coerced<String> message, Optional<Boolean> binary) throws LuaException {
        this.checkOpen();
        String text = message.value();
        if (this.options.websocketMessage() != 0 && text.length() > this.options.websocketMessage()) {
            throw new LuaException("Message is too large");
        }
        if (binary.orElse(false).booleanValue()) {
            this.websocket.sendBinary(LuaValues.encode(text));
        } else {
            this.websocket.sendText(text);
        }
    }

    @LuaFunction
    public final void close() {
        this.websocket.close();
    }

    private void checkOpen() throws LuaException {
        if (this.websocket.isClosed()) {
            throw new LuaException("attempt to use a closed file");
        }
    }

    private final class ReceiveCallback
    implements ILuaCallback {
        final MethodResult pull = MethodResult.pullEvent(null, this);
        private final int timeoutId;

        ReceiveCallback(int timeoutId) {
            this.timeoutId = timeoutId;
        }

        @Override
        public MethodResult resume(Object[] event) {
            Number id;
            Object object;
            if (event.length >= 3 && Objects.equal((Object)event[0], (Object)"websocket_message") && Objects.equal((Object)event[1], (Object)WebsocketHandle.this.address)) {
                return MethodResult.of(Arrays.copyOfRange(event, 2, event.length));
            }
            if (event.length >= 2 && Objects.equal((Object)event[0], (Object)"websocket_closed") && Objects.equal((Object)event[1], (Object)WebsocketHandle.this.address) && WebsocketHandle.this.websocket.isClosed()) {
                return MethodResult.of();
            }
            if (event.length >= 2 && this.timeoutId != -1 && Objects.equal((Object)event[0], (Object)"timer") && (object = event[1]) instanceof Number && (id = (Number)object).intValue() == this.timeoutId) {
                return MethodResult.of();
            }
            return this.pull;
        }
    }
}

