/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import dan200.computercraft.api.lua.Coerced;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.asm.Reflect;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Generator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Generator.class);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final String METHOD_NAME = "apply";
    private static final String[] EXCEPTIONS = new String[]{org.objectweb.asm.Type.getInternalName(LuaException.class)};
    private static final String INTERNAL_METHOD_RESULT = org.objectweb.asm.Type.getInternalName(MethodResult.class);
    private static final String DESC_METHOD_RESULT = org.objectweb.asm.Type.getDescriptor(MethodResult.class);
    private static final String INTERNAL_ARGUMENTS = org.objectweb.asm.Type.getInternalName(IArguments.class);
    private static final String DESC_ARGUMENTS = org.objectweb.asm.Type.getDescriptor(IArguments.class);
    private static final String INTERNAL_COERCED = org.objectweb.asm.Type.getInternalName(Coerced.class);
    private static final ConstantDynamic METHOD_CONSTANT = new ConstantDynamic("_", MethodHandle.class.descriptorString(), new Handle(6, org.objectweb.asm.Type.getInternalName(MethodHandles.class), "classData", MethodType.methodType(Object.class, MethodHandles.Lookup.class, String.class, Class.class).descriptorString(), false), new Object[0]);
    private final Class<T> base;
    private final List<Class<?>> context;
    private final String[] interfaces;
    private final String methodDesc;
    private final String classPrefix;
    private final java.util.function.Function<T, T> wrap;
    private final LoadingCache<Method, Optional<T>> methodCache = CacheBuilder.newBuilder().build(CacheLoader.from(Generator.catching(this::build, Optional.empty())));

    Generator(Class<T> base, List<Class<?>> context, java.util.function.Function<T, T> wrap) {
        this.base = base;
        this.context = context;
        this.interfaces = new String[]{org.objectweb.asm.Type.getInternalName(base)};
        this.wrap = wrap;
        StringBuilder methodDesc = new StringBuilder().append("(Ljava/lang/Object;");
        for (Class<?> klass : context) {
            methodDesc.append(org.objectweb.asm.Type.getDescriptor(klass));
        }
        methodDesc.append(DESC_ARGUMENTS).append(")").append(DESC_METHOD_RESULT);
        this.methodDesc = methodDesc.toString();
        this.classPrefix = Generator.class.getPackageName() + "." + base.getSimpleName() + "$";
    }

    Optional<T> getMethod(Method method) {
        return (Optional)this.methodCache.getUnchecked((Object)method);
    }

    private Optional<T> build(Method method) {
        Class<?>[] exceptions;
        String name = method.getDeclaringClass().getName() + "." + method.getName();
        int modifiers = method.getModifiers();
        if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
            LOG.warn("Lua Method {} should be final.", (Object)name);
        }
        if (!Modifier.isPublic(modifiers)) {
            LOG.error("Lua Method {} should be a public method.", (Object)name);
            return Optional.empty();
        }
        if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            LOG.error("Lua Method {} should be on a public class.", (Object)name);
            return Optional.empty();
        }
        LOG.debug("Generating method wrapper for {}.", (Object)name);
        for (Class<?> exception : exceptions = method.getExceptionTypes()) {
            if (exception == LuaException.class) continue;
            LOG.error("Lua Method {} cannot throw {}.", (Object)name, (Object)exception.getName());
            return Optional.empty();
        }
        LuaFunction annotation = method.getAnnotation(LuaFunction.class);
        if (annotation.unsafe() && annotation.mainThread()) {
            LOG.error("Lua Method {} cannot use unsafe and mainThread", (Object)name);
            return Optional.empty();
        }
        Class<?> target = Modifier.isStatic(modifiers) ? method.getParameterTypes()[0] : method.getDeclaringClass();
        try {
            MethodHandle handle = LOOKUP.unreflect(method);
            MethodHandle widenedHandle = handle.asType(Generator.widenMethodType(handle.type(), target));
            byte[] bytes = this.generate(this.classPrefix + method.getName(), target, method, widenedHandle.type().descriptorString(), annotation.unsafe());
            if (bytes == null) {
                return Optional.empty();
            }
            Class<?> klass = LOOKUP.defineHiddenClassWithClassData(bytes, widenedHandle, true, new MethodHandles.Lookup.ClassOption[0]).lookupClass();
            T instance = klass.asSubclass(this.base).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return Optional.of(annotation.mainThread() ? this.wrap.apply(instance) : instance);
        }
        catch (ClassFormatError | ReflectiveOperationException | RuntimeException e) {
            LOG.error("Error generating wrapper for {}.", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    private static MethodType widenMethodType(MethodType source, Class<?> target) {
        Class<?>[] args = source.parameterArray();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != target) continue;
            args[i] = Object.class;
        }
        TypeDescriptor.OfField ret = source.returnType();
        return ret == Void.TYPE || ret == MethodResult.class || ret == Object[].class ? MethodType.methodType(ret, args) : MethodType.methodType(Object.class, args);
    }

    @Nullable
    private byte[] generate(String className, Class<?> target, Method targetMethod, String targetDescriptor, boolean unsafe) {
        String internalName = className.replace(".", "/");
        ClassWriter cw = new ClassWriter(3);
        cw.visit(61, 17, internalName, null, "java/lang/Object", this.interfaces);
        cw.visitSource("CC generated method", null);
        MethodVisitor mw = cw.visitMethod(1, "<init>", "()V", null, null);
        mw.visitCode();
        mw.visitVarInsn(25, 0);
        mw.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mw.visitInsn(177);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
        mw = cw.visitMethod(1, METHOD_NAME, this.methodDesc, null, EXCEPTIONS);
        mw.visitCode();
        mw.visitLdcInsn((Object)METHOD_CONSTANT);
        if (!Modifier.isStatic(targetMethod.getModifiers())) {
            mw.visitVarInsn(25, 1);
        }
        int argIndex = 0;
        for (Type genericArg : targetMethod.getGenericParameterTypes()) {
            Boolean loadedArg = this.loadArg(mw, target, targetMethod, unsafe, genericArg, argIndex);
            if (loadedArg == null) {
                return null;
            }
            if (!loadedArg.booleanValue()) continue;
            ++argIndex;
        }
        mw.visitMethodInsn(182, "java/lang/invoke/MethodHandle", "invokeExact", targetDescriptor, false);
        Class<?> ret = targetMethod.getReturnType();
        if (ret != MethodResult.class) {
            if (ret == Void.TYPE) {
                mw.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "of", "()" + DESC_METHOD_RESULT, false);
            } else if (ret == Object[].class) {
                mw.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "of", "([Ljava/lang/Object;)" + DESC_METHOD_RESULT, false);
            } else {
                mw.visitMethodInsn(184, INTERNAL_METHOD_RESULT, "of", "(Ljava/lang/Object;)" + DESC_METHOD_RESULT, false);
            }
        }
        mw.visitInsn(176);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    @Nullable
    private Boolean loadArg(MethodVisitor mw, Class<?> target, Method method, boolean unsafe, Type genericArg, int argIndex) {
        String name;
        Class<?> klass;
        if (genericArg == target) {
            mw.visitVarInsn(25, 1);
            return false;
        }
        Class<?> arg = Reflect.getRawType(method, genericArg, true);
        if (arg == null) {
            return null;
        }
        if (arg == IArguments.class) {
            mw.visitVarInsn(25, 2 + this.context.size());
            return false;
        }
        int idx = this.context.indexOf(arg);
        if (idx >= 0) {
            mw.visitVarInsn(25, 2 + idx);
            return false;
        }
        if (arg == Coerced.class) {
            klass = Reflect.getRawType(method, TypeToken.of((Type)genericArg).resolveType(Reflect.COERCED_IN).getType(), false);
            if (klass == null) {
                return null;
            }
            if (klass == String.class) {
                mw.visitTypeInsn(187, INTERNAL_COERCED);
                mw.visitInsn(89);
                mw.visitVarInsn(25, 2 + this.context.size());
                Reflect.loadInt(mw, argIndex);
                mw.visitMethodInsn(185, INTERNAL_ARGUMENTS, "getStringCoerced", "(I)Ljava/lang/String;", true);
                mw.visitMethodInsn(183, INTERNAL_COERCED, "<init>", "(Ljava/lang/Object;)V", false);
                return true;
            }
        }
        if (arg == Optional.class) {
            klass = Reflect.getRawType(method, TypeToken.of((Type)genericArg).resolveType(Reflect.OPTIONAL_IN).getType(), false);
            if (klass == null) {
                return null;
            }
            if (Enum.class.isAssignableFrom(klass) && klass != Enum.class) {
                mw.visitVarInsn(25, 2 + this.context.size());
                Reflect.loadInt(mw, argIndex);
                mw.visitLdcInsn((Object)org.objectweb.asm.Type.getType(klass));
                mw.visitMethodInsn(185, INTERNAL_ARGUMENTS, "optEnum", "(ILjava/lang/Class;)Ljava/util/Optional;", true);
                return true;
            }
            String name2 = Reflect.getLuaName(Primitives.unwrap(klass), unsafe);
            if (name2 != null) {
                mw.visitVarInsn(25, 2 + this.context.size());
                Reflect.loadInt(mw, argIndex);
                mw.visitMethodInsn(185, INTERNAL_ARGUMENTS, "opt" + name2, "(I)Ljava/util/Optional;", true);
                return true;
            }
        }
        if (Enum.class.isAssignableFrom(arg) && arg != Enum.class) {
            mw.visitVarInsn(25, 2 + this.context.size());
            Reflect.loadInt(mw, argIndex);
            mw.visitLdcInsn((Object)org.objectweb.asm.Type.getType(arg));
            mw.visitMethodInsn(185, INTERNAL_ARGUMENTS, "getEnum", "(ILjava/lang/Class;)Ljava/lang/Enum;", true);
            mw.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(arg));
            return true;
        }
        String string = name = arg == Object.class ? "" : Reflect.getLuaName(arg, unsafe);
        if (name != null) {
            if (Reflect.getRawType(method, genericArg, false) == null) {
                return null;
            }
            mw.visitVarInsn(25, 2 + this.context.size());
            Reflect.loadInt(mw, argIndex);
            mw.visitMethodInsn(185, INTERNAL_ARGUMENTS, "get" + name, "(I)" + org.objectweb.asm.Type.getDescriptor(arg), true);
            return true;
        }
        LOG.error("Unknown parameter type {} for method {}.{}.", new Object[]{arg.getName(), method.getDeclaringClass().getName(), method.getName()});
        return null;
    }

    static <T, U> Function<T, U> catching(java.util.function.Function<T, U> function, U def) {
        return x -> {
            try {
                return function.apply(x);
            }
            catch (Exception | LinkageError e) {
                LOG.error("Error generating @LuaFunctions", e);
                return def;
            }
        };
    }
}

