/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import dan200.computercraft.core.computer.ComputerThread;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class TimeoutState {
    static final long TIMEOUT = TimeUnit.MILLISECONDS.toNanos(7000L);
    static final long ABORT_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(1500L);
    public static final String ABORT_MESSAGE = "Too long without yielding";
    private final ComputerThread scheduler;
    @GuardedBy(value="this")
    private final List<Runnable> listeners = new ArrayList<Runnable>(0);
    private boolean paused;
    private boolean softAbort;
    private volatile boolean hardAbort;
    private long cumulativeStart;
    private long cumulativeElapsed;
    private long currentStart;
    private long currentDeadline;

    public TimeoutState(ComputerThread scheduler) {
        this.scheduler = scheduler;
    }

    long nanoCumulative() {
        return System.nanoTime() - this.cumulativeStart;
    }

    long nanoCurrent() {
        return System.nanoTime() - this.currentStart;
    }

    public synchronized void refresh() {
        long now = System.nanoTime();
        boolean changed = false;
        if (!this.paused && (this.paused = this.currentDeadline - now <= 0L && this.scheduler.hasPendingWork())) {
            changed = true;
        }
        if (!this.softAbort && (this.softAbort = now - this.cumulativeStart - TIMEOUT >= 0L)) {
            changed = true;
        }
        if (changed) {
            this.updateListeners();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isSoftAborted() {
        return this.softAbort;
    }

    public boolean isHardAborted() {
        return this.hardAbort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hardAbort() {
        this.hardAbort = true;
        this.softAbort = true;
        TimeoutState timeoutState = this;
        synchronized (timeoutState) {
            this.updateListeners();
        }
    }

    void startTimer() {
        long now;
        this.currentStart = now = System.nanoTime();
        this.currentDeadline = now + this.scheduler.scaledPeriod();
        this.cumulativeStart = now - this.cumulativeElapsed;
    }

    synchronized void pauseTimer() {
        this.cumulativeElapsed = System.nanoTime() - this.cumulativeStart;
        this.paused = false;
        this.updateListeners();
    }

    synchronized void stopTimer() {
        this.cumulativeElapsed = 0L;
        this.hardAbort = false;
        this.softAbort = false;
        this.paused = false;
        this.updateListeners();
    }

    @GuardedBy(value="this")
    private void updateListeners() {
        for (Runnable listener : this.listeners) {
            listener.run();
        }
    }

    public synchronized void addListener(Runnable listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        this.listeners.add(listener);
        listener.run();
    }

    public synchronized void removeListener(Runnable listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        this.listeners.remove(listener);
    }
}

