/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.pocket.PocketUpgradeDataProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleUpgradeDataProvider;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.data.RecipeWrapper;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.platform.RegistryWrappers;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.ColourUtils;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2246;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2456;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7784;
import net.minecraft.class_7800;
import net.minecraft.class_7924;

class RecipeProvider
extends class_2446 {
    private final RecipeIngredients ingredients = PlatformHelper.get().getRecipeIngredients();
    private final TurtleUpgradeDataProvider turtleUpgrades;
    private final PocketUpgradeDataProvider pocketUpgrades;

    RecipeProvider(class_7784 output, TurtleUpgradeDataProvider turtleUpgrades, PocketUpgradeDataProvider pocketUpgrades) {
        super(output);
        this.turtleUpgrades = turtleUpgrades;
        this.pocketUpgrades = pocketUpgrades;
    }

    public void method_10419(Consumer<class_2444> add) {
        this.basicRecipes(add);
        this.diskColours(add);
        this.pocketUpgrades(add);
        this.turtleUpgrades(add);
        this.turtleOverlays(add);
        RecipeProvider.addSpecial(add, (class_1866)ModRegistry.RecipeSerializers.PRINTOUT.get());
        RecipeProvider.addSpecial(add, (class_1866)ModRegistry.RecipeSerializers.DISK.get());
        RecipeProvider.addSpecial(add, (class_1866)ModRegistry.RecipeSerializers.DYEABLE_ITEM.get());
        RecipeProvider.addSpecial(add, (class_1866)ModRegistry.RecipeSerializers.DYEABLE_ITEM_CLEAR.get());
        RecipeProvider.addSpecial(add, (class_1866)ModRegistry.RecipeSerializers.TURTLE_UPGRADE.get());
        RecipeProvider.addSpecial(add, (class_1866)ModRegistry.RecipeSerializers.POCKET_COMPUTER_UPGRADE.get());
    }

    private void diskColours(Consumer<class_2444> add) {
        for (Colour colour : Colour.VALUES) {
            class_2450.method_10447((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.DISK.get())).method_10451(this.ingredients.redstone()).method_10454((class_1935)class_1802.field_8407).method_10454((class_1935)class_1769.method_7803((class_1767)RecipeProvider.ofColour(colour))).method_10452("computercraft:disk").method_10442("has_drive", (class_184)RecipeProvider.inventoryChange((class_1935)ModRegistry.Blocks.DISK_DRIVE.get())).method_17972((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPELESS.get(), add).withResultTag(x -> x.method_10569("Color", colour.getHex())), new class_2960("computercraft", "disk_" + (colour.ordinal() + 1)));
        }
    }

    private static List<TurtleItem> turtleItems() {
        return List.of((TurtleItem)ModRegistry.Items.TURTLE_NORMAL.get(), (TurtleItem)ModRegistry.Items.TURTLE_ADVANCED.get());
    }

    private void turtleUpgrades(Consumer<class_2444> add) {
        for (TurtleItem turtleItem : RecipeProvider.turtleItems()) {
            class_1799 base = turtleItem.create(-1, null, -1, null, null, 0, null);
            String nameId = turtleItem.getFamily().name().toLowerCase(Locale.ROOT);
            for (ITurtleUpgrade upgrade : this.turtleUpgrades.getGeneratedUpgrades()) {
                class_1799 result = turtleItem.create(-1, null, -1, null, UpgradeData.ofDefault(upgrade), -1, null);
                class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)result.method_7909()).method_10435(String.format("%s:turtle_%s", "computercraft", nameId)).method_10439("#T").method_10434(Character.valueOf('T'), (class_1935)base.method_7909()).method_10434(Character.valueOf('#'), (class_1935)upgrade.getCraftingItem().method_7909()).method_10429("has_items", (class_184)RecipeProvider.inventoryChange(new class_1935[]{base.method_7909(), upgrade.getCraftingItem().method_7909()})).method_17972((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPED.get(), add).withResultTag(result.method_7969()), new class_2960("computercraft", String.format("turtle_%s/%s/%s", nameId, upgrade.getUpgradeID().method_12836(), upgrade.getUpgradeID().method_12832())));
            }
        }
    }

    private static List<PocketComputerItem> pocketComputerItems() {
        return List.of((PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get(), (PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get());
    }

    private void pocketUpgrades(Consumer<class_2444> add) {
        for (PocketComputerItem pocket : RecipeProvider.pocketComputerItems()) {
            class_1799 base = pocket.create(-1, null, -1, null);
            if (base.method_7960()) continue;
            String nameId = pocket.getFamily().name().toLowerCase(Locale.ROOT);
            for (IPocketUpgrade upgrade : this.pocketUpgrades.getGeneratedUpgrades()) {
                class_1799 result = pocket.create(-1, null, -1, UpgradeData.ofDefault(upgrade));
                class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)result.method_7909()).method_10435(String.format("%s:pocket_%s", "computercraft", nameId)).method_10439("#").method_10439("P").method_10434(Character.valueOf('P'), (class_1935)base.method_7909()).method_10434(Character.valueOf('#'), (class_1935)upgrade.getCraftingItem().method_7909()).method_10429("has_items", (class_184)RecipeProvider.inventoryChange(new class_1935[]{base.method_7909(), upgrade.getCraftingItem().method_7909()})).method_17972((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPED.get(), add).withResultTag(result.method_7969()), new class_2960("computercraft", String.format("pocket_%s/%s/%s", nameId, upgrade.getUpgradeID().method_12836(), upgrade.getUpgradeID().method_12832())));
            }
        }
    }

    private void turtleOverlays(Consumer<class_2444> add) {
        this.turtleOverlay(add, "turtle_trans_overlay", x -> x.method_10442("has_dye", (class_184)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.dye()))).method_10446(ColourUtils.getDyeTag(class_1767.field_7951)).method_10446(ColourUtils.getDyeTag(class_1767.field_7954)).method_10446(ColourUtils.getDyeTag(class_1767.field_7952)).method_10454((class_1935)class_1802.field_8600));
        this.turtleOverlay(add, "turtle_rainbow_overlay", x -> x.method_10442("has_dye", (class_184)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.dye()))).method_10446(ColourUtils.getDyeTag(class_1767.field_7964)).method_10446(ColourUtils.getDyeTag(class_1767.field_7946)).method_10446(ColourUtils.getDyeTag(class_1767.field_7947)).method_10446(ColourUtils.getDyeTag(class_1767.field_7942)).method_10446(ColourUtils.getDyeTag(class_1767.field_7966)).method_10446(ColourUtils.getDyeTag(class_1767.field_7945)).method_10454((class_1935)class_1802.field_8600));
    }

    private void turtleOverlay(Consumer<class_2444> add, String overlay, Consumer<class_2450> build) {
        for (TurtleItem turtleItem : RecipeProvider.turtleItems()) {
            class_1799 base = turtleItem.create(-1, null, -1, null, null, 0, null);
            String nameId = turtleItem.getFamily().name().toLowerCase(Locale.ROOT);
            String group = "%s:turtle_%s_overlay".formatted("computercraft", nameId);
            class_2450 builder = class_2450.method_10447((class_7800)class_7800.field_40636, (class_1935)base.method_7909()).method_10452(group).method_10442("has_turtle", (class_184)RecipeProvider.inventoryChange(new class_1935[]{base.method_7909()}));
            build.accept(builder);
            builder.method_10454((class_1935)base.method_7909()).method_17972((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.TURTLE_OVERLAY.get(), add).withExtraData(x -> x.addProperty("overlay", new class_2960("computercraft", "block/" + overlay).toString())), new class_2960("computercraft", "turtle_%s_overlays/%s".formatted(nameId, overlay)));
        }
    }

    private void basicRecipes(Consumer<class_2444> add) {
        class_2447.method_10436((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.CABLE.get()), (int)6).method_10439(" # ").method_10439("#R#").method_10439(" # ").method_10428(Character.valueOf('#'), this.ingredients.stone()).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_modem", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.COMPUTER_NORMAL.get())).method_10439("###").method_10439("#R#").method_10439("#G#").method_10428(Character.valueOf('#'), this.ingredients.stone()).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_redstone", (class_184)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.redstone()))).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.COMPUTER_ADVANCED.get())).method_10439("###").method_10439("#R#").method_10439("#G#").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_components", (class_184)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.redstone()), RecipeProvider.itemPredicate(this.ingredients.goldIngot()))).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.COMPUTER_ADVANCED.get())).method_10439("###").method_10439("#C#").method_10439("# #").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10434(Character.valueOf('C'), (class_1935)ModRegistry.Items.COMPUTER_NORMAL.get()).method_10429("has_components", (class_184)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((class_1935)ModRegistry.Items.COMPUTER_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot()))).method_17972((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.COMPUTER_UPGRADE.get(), add).withExtraData(RecipeProvider.family(ComputerFamily.ADVANCED)), new class_2960("computercraft", "computer_advanced_upgrade"));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.COMPUTER_COMMAND.get())).method_10439("###").method_10439("#R#").method_10439("#G#").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10434(Character.valueOf('R'), (class_1935)class_2246.field_10525).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_components", (class_184)RecipeProvider.inventoryChange(new class_1935[]{class_2246.field_10525})).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.TURTLE_NORMAL.get())).method_10439("###").method_10439("#C#").method_10439("#I#").method_10428(Character.valueOf('#'), this.ingredients.ironIngot()).method_10434(Character.valueOf('C'), (class_1935)ModRegistry.Items.COMPUTER_NORMAL.get()).method_10428(Character.valueOf('I'), this.ingredients.woodenChest()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.COMPUTER_NORMAL.get())).method_10431((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.TURTLE.get(), add).withExtraData(RecipeProvider.family(ComputerFamily.NORMAL)));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.TURTLE_ADVANCED.get())).method_10439("###").method_10439("#C#").method_10439("#I#").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10434(Character.valueOf('C'), (class_1935)ModRegistry.Items.COMPUTER_ADVANCED.get()).method_10428(Character.valueOf('I'), this.ingredients.woodenChest()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.COMPUTER_NORMAL.get())).method_10431((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.TURTLE.get(), add).withExtraData(RecipeProvider.family(ComputerFamily.ADVANCED)));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.TURTLE_ADVANCED.get())).method_10439("###").method_10439("#C#").method_10439(" B ").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10434(Character.valueOf('C'), (class_1935)ModRegistry.Items.TURTLE_NORMAL.get()).method_10428(Character.valueOf('B'), this.ingredients.goldBlock()).method_10429("has_components", (class_184)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((class_1935)ModRegistry.Items.TURTLE_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot()))).method_17972((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.COMPUTER_UPGRADE.get(), add).withExtraData(RecipeProvider.family(ComputerFamily.ADVANCED)), new class_2960("computercraft", "turtle_advanced_upgrade"));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.DISK_DRIVE.get())).method_10439("###").method_10439("#R#").method_10439("#R#").method_10428(Character.valueOf('#'), this.ingredients.stone()).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.MONITOR_NORMAL.get())).method_10439("###").method_10439("#G#").method_10439("###").method_10428(Character.valueOf('#'), this.ingredients.stone()).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10436((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.MONITOR_ADVANCED.get()), (int)4).method_10439("###").method_10439("#G#").method_10439("###").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get())).method_10439("###").method_10439("#A#").method_10439("#G#").method_10428(Character.valueOf('#'), this.ingredients.stone()).method_10434(Character.valueOf('A'), (class_1935)class_1802.field_8463).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_apple", (class_184)RecipeProvider.inventoryChange(new class_1935[]{class_1802.field_8463})).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get())).method_10439("###").method_10439("#A#").method_10439("#G#").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10434(Character.valueOf('A'), (class_1935)class_1802.field_8463).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_apple", (class_184)RecipeProvider.inventoryChange(new class_1935[]{class_1802.field_8463})).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get())).method_10439("###").method_10439("#C#").method_10439("# #").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10434(Character.valueOf('C'), (class_1935)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()).method_10429("has_components", (class_184)RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((class_1935)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot()))).method_17972((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.COMPUTER_UPGRADE.get(), add).withExtraData(RecipeProvider.family(ComputerFamily.ADVANCED)), new class_2960("computercraft", "pocket_computer_advanced_upgrade"));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.PRINTER.get())).method_10439("###").method_10439("#R#").method_10439("#D#").method_10428(Character.valueOf('#'), this.ingredients.stone()).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10428(Character.valueOf('D'), this.ingredients.dye()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.SPEAKER.get())).method_10439("###").method_10439("#N#").method_10439("#R#").method_10428(Character.valueOf('#'), this.ingredients.stone()).method_10434(Character.valueOf('N'), (class_1935)class_2246.field_10179).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.WIRED_MODEM.get())).method_10439("###").method_10439("#R#").method_10439("###").method_10428(Character.valueOf('#'), this.ingredients.stone()).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_cable", (class_184)RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.CABLE.get())).method_10431(add);
        class_2450.method_10447((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.WIRED_MODEM_FULL.get())).method_10454((class_1935)ModRegistry.Items.WIRED_MODEM.get()).method_10442("has_modem", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).method_17972(add, new class_2960("computercraft", "wired_modem_full_from"));
        class_2450.method_10447((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.WIRED_MODEM.get())).method_10454((class_1935)ModRegistry.Blocks.WIRED_MODEM_FULL.get()).method_10442("has_modem", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).method_17972(add, new class_2960("computercraft", "wired_modem_full_to"));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.WIRELESS_MODEM_NORMAL.get())).method_10439("###").method_10439("#E#").method_10439("###").method_10428(Character.valueOf('#'), this.ingredients.stone()).method_10428(Character.valueOf('E'), this.ingredients.enderPearl()).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Blocks.WIRELESS_MODEM_ADVANCED.get())).method_10439("###").method_10439("#E#").method_10439("###").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10434(Character.valueOf('E'), (class_1935)class_1802.field_8449).method_10429("has_computer", (class_184)RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_wireless", (class_184)RecipeProvider.inventoryChange((class_1935)ModRegistry.Blocks.WIRELESS_MODEM_NORMAL.get())).method_10431(add);
        class_2450.method_10447((class_7800)class_7800.field_40635, (class_1935)class_1802.field_8575).method_10451(this.ingredients.head()).method_10454((class_1935)ModRegistry.Items.MONITOR_NORMAL.get()).method_10442("has_monitor", (class_184)RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.MONITOR_NORMAL.get())).method_17972((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.SHAPELESS.get(), add).withResultTag(RecipeProvider.playerHead("Cloudhunter", "6d074736-b1e9-4378-a99b-bd8777821c9c")), new class_2960("computercraft", "skull_cloudy"));
        class_2450.method_10447((class_7800)class_7800.field_40635, (class_1935)class_1802.field_8575).method_10451(this.ingredients.head()).method_10454((class_1935)ModRegistry.Items.COMPUTER_ADVANCED.get()).method_10442("has_computer", (class_184)RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.COMPUTER_ADVANCED.get())).method_17972((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.SHAPELESS.get(), add).withResultTag(RecipeProvider.playerHead("dan200", "f3c8d69b-0776-4512-8434-d1b2165909eb")), new class_2960("computercraft", "skull_dan200"));
        class_2450.method_10447((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.PRINTED_PAGES.get())).method_10449((class_1935)ModRegistry.Items.PRINTED_PAGE.get(), 2).method_10451(this.ingredients.string()).method_10442("has_printer", (class_184)RecipeProvider.inventoryChange((class_1935)ModRegistry.Blocks.PRINTER.get())).method_10431((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPELESS.get(), add));
        class_2450.method_10447((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.PRINTED_BOOK.get())).method_10451(this.ingredients.leather()).method_10449((class_1935)ModRegistry.Items.PRINTED_PAGE.get(), 1).method_10451(this.ingredients.string()).method_10442("has_printer", (class_184)RecipeProvider.inventoryChange((class_1935)ModRegistry.Blocks.PRINTER.get())).method_10431((Consumer)RecipeWrapper.wrap((class_1865)ModRegistry.RecipeSerializers.IMPOSTOR_SHAPELESS.get(), add));
    }

    private static class_1767 ofColour(Colour colour) {
        return class_1767.method_7791((int)(15 - colour.ordinal()));
    }

    private static class_2066.class_2068 inventoryChange(class_6862<class_1792> stack) {
        return class_2066.class_2068.method_8957((class_2073[])new class_2073[]{RecipeProvider.itemPredicate(stack)});
    }

    private static class_2066.class_2068 inventoryChange(class_1935 ... stack) {
        return class_2066.class_2068.method_8959((class_1935[])stack);
    }

    private static class_2066.class_2068 inventoryChange(class_2073 ... items) {
        return class_2066.class_2068.method_8957((class_2073[])items);
    }

    private static class_2073 itemPredicate(class_1935 item) {
        return class_2073.class_2074.method_8973().method_8977(new class_1935[]{item}).method_8976();
    }

    private static class_2073 itemPredicate(class_6862<class_1792> item) {
        return class_2073.class_2074.method_8973().method_8975(item).method_8976();
    }

    private static class_2073 itemPredicate(class_1856 ingredient) {
        JsonElement json = ingredient.method_8089();
        if (!(json instanceof JsonObject)) {
            throw new IllegalStateException("Unknown ingredient " + json);
        }
        JsonObject object = (JsonObject)json;
        if (object.has("item")) {
            return RecipeProvider.itemPredicate((class_1935)class_1869.method_8155((JsonObject)object));
        }
        if (object.has("tag")) {
            return RecipeProvider.itemPredicate((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(class_3518.method_15265((JsonObject)object, (String)"tag"))));
        }
        throw new IllegalArgumentException("Unknown ingredient " + json);
    }

    private static class_2487 playerHead(String name, String uuid) {
        class_2487 owner = class_2512.method_10684((class_2487)new class_2487(), (GameProfile)new GameProfile(UUID.fromString(uuid), name));
        class_2487 tag = new class_2487();
        tag.method_10566("SkullOwner", (class_2520)owner);
        return tag;
    }

    private static Consumer<JsonObject> family(ComputerFamily family) {
        return json -> json.addProperty("family", family.method_15434());
    }

    private static void addSpecial(Consumer<class_2444> add, class_1866<?> special) {
        class_2456.method_10476(special).method_10475(add, RegistryWrappers.RECIPE_SERIALIZERS.getKey((class_1865<?>)special).toString());
    }
}

