/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl.network.wired;

import com.google.common.collect.ImmutableMap;
import dan200.computercraft.api.network.Packet;
import dan200.computercraft.api.network.wired.WiredNetwork;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.impl.network.wired.InvariantChecker;
import dan200.computercraft.impl.network.wired.WiredNetworkChangeImpl;
import dan200.computercraft.impl.network.wired.WiredNodeImpl;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.class_1937;
import net.minecraft.class_243;

final class WiredNetworkImpl
implements WiredNetwork {
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    Set<WiredNodeImpl> nodes;
    private Map<String, IPeripheral> peripherals = new HashMap<String, IPeripheral>();

    WiredNetworkImpl(WiredNodeImpl node) {
        this.nodes = new HashSet<WiredNodeImpl>(1);
        this.nodes.add(node);
    }

    private WiredNetworkImpl(Set<WiredNodeImpl> nodes) {
        this.nodes = nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(WiredNode nodeU, WiredNode nodeV) {
        WiredNodeImpl wiredU = WiredNetworkImpl.checkNode(nodeU);
        WiredNodeImpl wiredV = WiredNetworkImpl.checkNode(nodeV);
        if (nodeU == nodeV) {
            throw new IllegalArgumentException("Cannot add a connection to oneself.");
        }
        this.lock.writeLock().lock();
        try {
            boolean added;
            boolean hasV;
            if (this.nodes.isEmpty()) {
                throw new IllegalStateException("Cannot add a connection to an empty network.");
            }
            boolean hasU = wiredU.network == this;
            boolean bl = hasV = wiredV.network == this;
            if (!hasU && !hasV) {
                throw new IllegalArgumentException("Neither node is in the network.");
            }
            if (!hasU || !hasV) {
                WiredNetworkImpl other = hasU ? wiredV.network : wiredU.network;
                other.lock.writeLock().lock();
                try {
                    Map<String, IPeripheral> otherPeripherals = other.peripherals;
                    HashMap<String, IPeripheral> thisPeripherals = otherPeripherals.isEmpty() ? this.peripherals : new HashMap<String, IPeripheral>(this.peripherals);
                    Collection<WiredNodeImpl> thisNodes = otherPeripherals.isEmpty() ? this.nodes : new ArrayList<WiredNodeImpl>(this.nodes);
                    Set<WiredNodeImpl> otherNodes = other.nodes;
                    this.nodes.addAll(otherNodes);
                    for (WiredNodeImpl node : otherNodes) {
                        node.network = this;
                    }
                    other.nodes = Collections.emptySet();
                    other.peripherals = Collections.emptyMap();
                    this.peripherals.putAll(otherPeripherals);
                    if (!thisPeripherals.isEmpty()) {
                        WiredNetworkChangeImpl.added(thisPeripherals).broadcast(otherNodes);
                    }
                    if (!otherPeripherals.isEmpty()) {
                        WiredNetworkChangeImpl.added(otherPeripherals).broadcast(thisNodes);
                    }
                }
                finally {
                    other.lock.writeLock().unlock();
                }
            }
            if (added = wiredU.neighbours.add(wiredV)) {
                wiredV.neighbours.add(wiredU);
            }
            InvariantChecker.checkNetwork(this);
            InvariantChecker.checkNode(wiredU);
            InvariantChecker.checkNode(wiredV);
            boolean bl2 = added;
            return bl2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnect(WiredNode nodeU, WiredNode nodeV) {
        WiredNodeImpl wiredU = WiredNetworkImpl.checkNode(nodeU);
        WiredNodeImpl wiredV = WiredNetworkImpl.checkNode(nodeV);
        if (nodeU == nodeV) {
            throw new IllegalArgumentException("Cannot remove a connection to oneself.");
        }
        this.lock.writeLock().lock();
        try {
            boolean hasV;
            boolean hasU = wiredU.network == this;
            boolean bl = hasV = wiredV.network == this;
            if (!hasU || !hasV) {
                throw new IllegalArgumentException("One node is not in the network.");
            }
            if (!wiredU.neighbours.remove(wiredV)) {
                boolean bl2 = false;
                return bl2;
            }
            wiredV.neighbours.remove(wiredU);
            ArrayDeque<WiredNodeImpl> enqueued = new ArrayDeque<WiredNodeImpl>();
            HashSet<WiredNodeImpl> reachableU = new HashSet<WiredNodeImpl>();
            reachableU.add(wiredU);
            enqueued.add(wiredU);
            while (!enqueued.isEmpty()) {
                WiredNodeImpl node = (WiredNodeImpl)enqueued.remove();
                for (WiredNodeImpl neighbour : node.neighbours) {
                    if (neighbour == wiredV) {
                        boolean bl3 = true;
                        return bl3;
                    }
                    if (!reachableU.add(neighbour)) continue;
                    enqueued.add(neighbour);
                }
            }
            WiredNetworkImpl networkU = new WiredNetworkImpl(reachableU);
            networkU.lock.writeLock().lock();
            try {
                this.nodes.removeAll(reachableU);
                for (WiredNodeImpl node : reachableU) {
                    node.network = networkU;
                    networkU.peripherals.putAll(node.peripherals);
                    this.peripherals.keySet().removeAll(node.peripherals.keySet());
                }
                if (!this.peripherals.isEmpty()) {
                    WiredNetworkChangeImpl.removed(this.peripherals).broadcast(networkU.nodes);
                }
                if (!networkU.peripherals.isEmpty()) {
                    WiredNetworkChangeImpl.removed(networkU.peripherals).broadcast(this.nodes);
                }
                InvariantChecker.checkNetwork(this);
                InvariantChecker.checkNetwork(networkU);
                InvariantChecker.checkNode(wiredU);
                InvariantChecker.checkNode(wiredV);
                boolean bl4 = true;
                networkU.lock.writeLock().unlock();
                return bl4;
            }
            catch (Throwable throwable) {
                networkU.lock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(WiredNode node) {
        WiredNodeImpl wired = WiredNetworkImpl.checkNode(node);
        this.lock.writeLock().lock();
        try {
            if (this.nodes.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            if (this.nodes.size() <= 1) {
                boolean bl = false;
                return bl;
            }
            if (wired.network != this) {
                boolean bl = false;
                return bl;
            }
            HashSet<WiredNodeImpl> neighbours = wired.neighbours;
            this.nodes.remove(wired);
            for (WiredNodeImpl neighbour : neighbours) {
                neighbour.neighbours.remove(wired);
            }
            WiredNetworkImpl wiredNetwork = new WiredNetworkImpl(wired);
            if (neighbours.size() == 1) {
                this.removeSingleNode(wired, wiredNetwork);
                InvariantChecker.checkNode(wired);
                InvariantChecker.checkNetwork(wiredNetwork);
                boolean neighbour = true;
                return neighbour;
            }
            Set<WiredNodeImpl> reachable = WiredNetworkImpl.reachableNodes(neighbours.iterator().next());
            if (reachable.size() == this.nodes.size()) {
                this.removeSingleNode(wired, wiredNetwork);
                InvariantChecker.checkNode(wired);
                InvariantChecker.checkNetwork(wiredNetwork);
                boolean bl = true;
                return bl;
            }
            neighbours.removeAll(reachable);
            ArrayList<WiredNetworkImpl> maximals = new ArrayList<WiredNetworkImpl>(neighbours.size() + 1);
            maximals.add(wiredNetwork);
            maximals.add(new WiredNetworkImpl(reachable));
            while (!neighbours.isEmpty()) {
                reachable = WiredNetworkImpl.reachableNodes(neighbours.iterator().next());
                neighbours.removeAll(reachable);
                maximals.add(new WiredNetworkImpl(reachable));
            }
            for (WiredNetworkImpl network : maximals) {
                network.lock.writeLock().lock();
            }
            try {
                wired.network = wiredNetwork;
                wired.peripherals = Collections.emptyMap();
                for (WiredNetworkImpl network : maximals) {
                    for (WiredNodeImpl child : network.nodes) {
                        child.network = network;
                        network.peripherals.putAll(child.peripherals);
                    }
                }
                for (WiredNetworkImpl network : maximals) {
                    InvariantChecker.checkNetwork(network);
                }
                InvariantChecker.checkNode(wired);
                for (WiredNetworkImpl network : maximals) {
                    WiredNetworkChangeImpl.changeOf(this.peripherals, network.peripherals).broadcast(network.nodes);
                }
            }
            catch (Throwable throwable) {
                for (WiredNetworkImpl network : maximals) {
                    network.lock.writeLock().unlock();
                }
                throw throwable;
            }
            for (WiredNetworkImpl network : maximals) {
                network.lock.writeLock().unlock();
            }
            this.nodes.clear();
            this.peripherals.clear();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePeripherals(WiredNode node, Map<String, IPeripheral> newPeripherals) {
        WiredNodeImpl wired = WiredNetworkImpl.checkNode(node);
        Objects.requireNonNull(this.peripherals, "peripherals cannot be null");
        this.lock.writeLock().lock();
        try {
            if (wired.network != this) {
                throw new IllegalStateException("Node is not on this network");
            }
            Map<String, IPeripheral> oldPeripherals = wired.peripherals;
            WiredNetworkChangeImpl change = WiredNetworkChangeImpl.changeOf(oldPeripherals, newPeripherals);
            if (change.isEmpty()) {
                return;
            }
            wired.peripherals = ImmutableMap.copyOf(newPeripherals);
            this.peripherals.keySet().removeAll(change.peripheralsRemoved().keySet());
            this.peripherals.putAll(change.peripheralsAdded());
            change.broadcast(this.nodes);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    static void transmitPacket(WiredNodeImpl start, Packet packet, double range, boolean interdimensional) {
        TransmitPoint point;
        HashMap<WiredNodeImpl, TransmitPoint> points = new HashMap<WiredNodeImpl, TransmitPoint>();
        TreeSet<TransmitPoint> transmitTo = new TreeSet<TransmitPoint>();
        TransmitPoint startEntry = start.element.getLevel() != packet.sender().getLevel() ? new TransmitPoint(start, Double.POSITIVE_INFINITY, true) : new TransmitPoint(start, start.element.getPosition().method_1022(packet.sender().getPosition()), false);
        points.put(start, startEntry);
        transmitTo.add(startEntry);
        while ((point = (TransmitPoint)transmitTo.pollFirst()) != null) {
            class_1937 world = point.node.element.getLevel();
            class_243 position = point.node.element.getPosition();
            for (WiredNodeImpl neighbour : point.node.neighbours) {
                double newDistance;
                boolean newInterdimensional;
                TransmitPoint neighbourPoint = (TransmitPoint)points.get(neighbour);
                if (world != neighbour.element.getLevel()) {
                    newInterdimensional = true;
                    newDistance = Double.POSITIVE_INFINITY;
                } else {
                    newInterdimensional = false;
                    newDistance = point.distance + position.method_1022(neighbour.element.getPosition());
                }
                if (neighbourPoint == null) {
                    TransmitPoint nextPoint = new TransmitPoint(neighbour, newDistance, newInterdimensional);
                    points.put(neighbour, nextPoint);
                    transmitTo.add(nextPoint);
                    continue;
                }
                if (!(newDistance < neighbourPoint.distance)) continue;
                transmitTo.remove(neighbourPoint);
                neighbourPoint.distance = newDistance;
                neighbourPoint.interdimensional = newInterdimensional;
                transmitTo.add(neighbourPoint);
            }
        }
        for (TransmitPoint point2 : points.values()) {
            point2.node.tryTransmit(packet, point2.distance, point2.interdimensional, range, interdimensional);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSingleNode(WiredNodeImpl wired, WiredNetworkImpl wiredNetwork) {
        wiredNetwork.lock.writeLock().lock();
        try {
            HashMap<String, IPeripheral> wiredPeripherals = new HashMap<String, IPeripheral>(wired.peripherals);
            wired.network = wiredNetwork;
            wired.neighbours.clear();
            wired.peripherals = Collections.emptyMap();
            if (!this.peripherals.isEmpty()) {
                WiredNetworkChangeImpl.removed(this.peripherals).broadcast(wired);
            }
            this.peripherals.keySet().removeAll(wiredPeripherals.keySet());
            if (!wiredPeripherals.isEmpty()) {
                WiredNetworkChangeImpl.removed(wiredPeripherals).broadcast(this.nodes);
            }
        }
        finally {
            wiredNetwork.lock.writeLock().unlock();
        }
    }

    private static WiredNodeImpl checkNode(WiredNode node) {
        if (node instanceof WiredNodeImpl) {
            return (WiredNodeImpl)node;
        }
        throw new IllegalArgumentException("Unknown implementation of IWiredNode: " + node);
    }

    private static Set<WiredNodeImpl> reachableNodes(WiredNodeImpl start) {
        WiredNodeImpl node;
        ArrayDeque<WiredNodeImpl> enqueued = new ArrayDeque<WiredNodeImpl>();
        HashSet<WiredNodeImpl> reachable = new HashSet<WiredNodeImpl>();
        reachable.add(start);
        enqueued.add(start);
        while ((node = (WiredNodeImpl)enqueued.poll()) != null) {
            for (WiredNodeImpl neighbour : node.neighbours) {
                if (!reachable.add(neighbour)) continue;
                enqueued.add(neighbour);
            }
        }
        return reachable;
    }

    private static class TransmitPoint
    implements Comparable<TransmitPoint> {
        final WiredNodeImpl node;
        double distance;
        boolean interdimensional;

        TransmitPoint(WiredNodeImpl node, double distance, boolean interdimensional) {
            this.node = node;
            this.distance = distance;
            this.interdimensional = interdimensional;
        }

        @Override
        public int compareTo(TransmitPoint o) {
            return this.distance == o.distance ? Integer.compare(this.node.hashCode(), o.node.hashCode()) : Double.compare(this.distance, o.distance);
        }
    }
}

