/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl.network.wired;

import dan200.computercraft.api.network.Packet;
import dan200.computercraft.api.network.PacketReceiver;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNetwork;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.network.wired.WiredSender;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.impl.network.wired.WiredNetworkImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;

public final class WiredNodeImpl
implements WiredNode {
    @Nullable
    private Set<PacketReceiver> receivers;
    final WiredElement element;
    Map<String, IPeripheral> peripherals = Collections.emptyMap();
    final HashSet<WiredNodeImpl> neighbours = new HashSet();
    volatile WiredNetworkImpl network;

    public WiredNodeImpl(WiredElement element) {
        this.element = element;
        this.network = new WiredNetworkImpl(this);
    }

    @Override
    public synchronized void addReceiver(PacketReceiver receiver) {
        if (this.receivers == null) {
            this.receivers = new HashSet<PacketReceiver>();
        }
        this.receivers.add(receiver);
    }

    @Override
    public synchronized void removeReceiver(PacketReceiver receiver) {
        if (this.receivers != null) {
            this.receivers.remove(receiver);
        }
    }

    synchronized void tryTransmit(Packet packet, double packetDistance, boolean packetInterdimensional, double range, boolean interdimensional) {
        if (this.receivers == null) {
            return;
        }
        for (PacketReceiver receiver : this.receivers) {
            if (!packetInterdimensional) {
                double receiveRange = Math.max(range, receiver.getRange());
                if (!interdimensional && !receiver.isInterdimensional() && !(packetDistance < receiveRange)) continue;
                receiver.receiveSameDimension(packet, packetDistance + this.element.getPosition().method_1022(receiver.getPosition()));
                continue;
            }
            if (!interdimensional && !receiver.isInterdimensional()) continue;
            receiver.receiveDifferentDimension(packet);
        }
    }

    @Override
    public boolean isWireless() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmitSameDimension(Packet packet, double range) {
        Objects.requireNonNull(packet, "packet cannot be null");
        if (!(packet.sender() instanceof WiredSender) || ((WiredSender)packet.sender()).getNode() != this) {
            throw new IllegalArgumentException("Sender is not in the network");
        }
        this.acquireReadLock();
        try {
            WiredNetworkImpl.transmitPacket(this, packet, range, false);
        }
        finally {
            this.network.lock.readLock().unlock();
        }
    }

    @Override
    public void transmitInterdimensional(Packet packet) {
        Objects.requireNonNull(packet, "packet cannot be null");
        if (!(packet.sender() instanceof WiredSender) || ((WiredSender)packet.sender()).getNode() != this) {
            throw new IllegalArgumentException("Sender is not in the network");
        }
        this.acquireReadLock();
        try {
            WiredNetworkImpl.transmitPacket(this, packet, 0.0, true);
        }
        finally {
            this.network.lock.readLock().unlock();
        }
    }

    @Override
    public WiredElement getElement() {
        return this.element;
    }

    @Override
    public WiredNetwork getNetwork() {
        return this.network;
    }

    public String toString() {
        return "WiredNode{@" + this.element.getPosition() + " (" + this.element.getClass().getSimpleName() + ")}";
    }

    private void acquireReadLock() {
        WiredNetworkImpl currentNetwork = this.network;
        while (true) {
            Lock lock = currentNetwork.lock.readLock();
            lock.lock();
            if (currentNetwork == this.network) {
                return;
            }
            lock.unlock();
        }
    }
}

