/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.mojang.brigadier.arguments.ArgumentType;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.PocketUpgradeSerialiser;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.arguments.ComputerArgumentType;
import dan200.computercraft.shared.command.arguments.ComputersArgumentType;
import dan200.computercraft.shared.command.arguments.RepeatArgumentType;
import dan200.computercraft.shared.command.arguments.TrackingFieldArgumentType;
import dan200.computercraft.shared.common.ClearColourRecipe;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.common.HeldItemMenu;
import dan200.computercraft.shared.computer.blocks.CommandComputerBlock;
import dan200.computercraft.shared.computer.blocks.CommandComputerBlockEntity;
import dan200.computercraft.shared.computer.blocks.ComputerBlock;
import dan200.computercraft.shared.computer.blocks.ComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.inventory.ViewComputerMenu;
import dan200.computercraft.shared.computer.items.CommandComputerItem;
import dan200.computercraft.shared.computer.items.ComputerItem;
import dan200.computercraft.shared.computer.recipe.ComputerUpgradeRecipe;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.ConstantLootConditionSerializer;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.details.BlockDetails;
import dan200.computercraft.shared.details.ItemDetails;
import dan200.computercraft.shared.integration.PermissionRegistry;
import dan200.computercraft.shared.media.items.DiskItem;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.media.items.RecordMedia;
import dan200.computercraft.shared.media.items.TreasureDiskItem;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.network.container.HeldItemContainerData;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlockEntity;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveMenu;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockItem;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlock;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.printer.PrinterBlock;
import dan200.computercraft.shared.peripheral.printer.PrinterBlockEntity;
import dan200.computercraft.shared.peripheral.printer.PrinterMenu;
import dan200.computercraft.shared.peripheral.speaker.SpeakerBlock;
import dan200.computercraft.shared.peripheral.speaker.SpeakerBlockEntity;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RegistrationHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.pocket.peripherals.PocketModem;
import dan200.computercraft.shared.pocket.peripherals.PocketSpeaker;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.recipe.CustomShapedRecipe;
import dan200.computercraft.shared.recipe.CustomShapelessRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapedRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapelessRecipe;
import dan200.computercraft.shared.turtle.FurnaceRefuelHandler;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.turtle.recipes.TurtleOverlayRecipe;
import dan200.computercraft.shared.turtle.recipes.TurtleRecipe;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.turtle.upgrades.TurtleCraftingTable;
import dan200.computercraft.shared.turtle.upgrades.TurtleModem;
import dan200.computercraft.shared.turtle.upgrades.TurtleSpeaker;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import dan200.computercraft.shared.turtle.upgrades.TurtleToolSerialiser;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_5342;
import net.minecraft.class_5620;
import net.minecraft.class_7701;
import net.minecraft.class_7924;

public final class ModRegistry {
    private ModRegistry() {
    }

    public static void register() {
        Blocks.REGISTRY.register();
        BlockEntities.REGISTRY.register();
        Items.REGISTRY.register();
        TurtleSerialisers.REGISTRY.register();
        PocketUpgradeSerialisers.REGISTRY.register();
        Menus.REGISTRY.register();
        ArgumentTypes.REGISTRY.register();
        LootItemConditionTypes.REGISTRY.register();
        RecipeSerializers.REGISTRY.register();
        Permissions.REGISTRY.register();
        CreativeTabs.REGISTRY.register();
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerRefuelHandler(new FurnaceRefuelHandler());
        ComputerCraftAPI.registerMediaProvider(stack -> {
            class_1792 item = stack.method_7909();
            if (item instanceof IMedia) {
                IMedia media = (IMedia)item;
                return media;
            }
            if (item instanceof class_1813) {
                return RecordMedia.INSTANCE;
            }
            return null;
        });
        VanillaDetailRegistries.ITEM_STACK.addProvider(ItemDetails::fill);
        VanillaDetailRegistries.BLOCK_IN_WORLD.addProvider(BlockDetails::fill);
    }

    public static void registerMainThread() {
        class_5620.field_27776.put((class_1792)Items.TURTLE_NORMAL.get(), TurtleItem.CAULDRON_INTERACTION);
        class_5620.field_27776.put((class_1792)Items.TURTLE_ADVANCED.get(), TurtleItem.CAULDRON_INTERACTION);
    }

    private static void addTurtle(class_1761.class_7704 out, TurtleItem turtle) {
        out.method_45420(turtle.create(-1, null, -1, null, null, 0, null));
        TurtleUpgrades.getVanillaUpgrades().map(x -> turtle.create(-1, null, -1, null, UpgradeData.ofDefault(x), 0, null)).forEach(arg_0 -> ((class_1761.class_7704)out).method_45420(arg_0));
    }

    private static void addPocket(class_1761.class_7704 out, PocketComputerItem pocket) {
        out.method_45420(pocket.create(-1, null, -1, null));
        PocketUpgrades.getVanillaUpgrades().map(x -> pocket.create(-1, null, -1, UpgradeData.ofDefault(x))).forEach(arg_0 -> ((class_1761.class_7704)out).method_45420(arg_0));
    }

    public static final class Blocks {
        static final RegistrationHelper<class_2248> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41254);
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_NORMAL = REGISTRY.register("computer_normal", () -> new ComputerBlock(Blocks.computerProperties().method_31710(class_3620.field_16023), ComputerFamily.NORMAL, BlockEntities.COMPUTER_NORMAL));
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_ADVANCED = REGISTRY.register("computer_advanced", () -> new ComputerBlock(Blocks.computerProperties().method_31710(class_3620.field_15994), ComputerFamily.ADVANCED, BlockEntities.COMPUTER_ADVANCED));
        public static final RegistryEntry<ComputerBlock<CommandComputerBlockEntity>> COMPUTER_COMMAND = REGISTRY.register("computer_command", () -> new CommandComputerBlock(Blocks.computerProperties().method_9629(-1.0f, 6000000.0f), ComputerFamily.COMMAND, BlockEntities.COMPUTER_COMMAND));
        public static final RegistryEntry<TurtleBlock> TURTLE_NORMAL = REGISTRY.register("turtle_normal", () -> new TurtleBlock(Blocks.turtleProperties().method_31710(class_3620.field_16023), ComputerFamily.NORMAL, BlockEntities.TURTLE_NORMAL));
        public static final RegistryEntry<TurtleBlock> TURTLE_ADVANCED = REGISTRY.register("turtle_advanced", () -> new TurtleBlock(Blocks.turtleProperties().method_31710(class_3620.field_15994), ComputerFamily.ADVANCED, BlockEntities.TURTLE_ADVANCED));
        public static final RegistryEntry<SpeakerBlock> SPEAKER = REGISTRY.register("speaker", () -> new SpeakerBlock(Blocks.properties().method_31710(class_3620.field_16023)));
        public static final RegistryEntry<DiskDriveBlock> DISK_DRIVE = REGISTRY.register("disk_drive", () -> new DiskDriveBlock(Blocks.properties().method_31710(class_3620.field_16023)));
        public static final RegistryEntry<PrinterBlock> PRINTER = REGISTRY.register("printer", () -> new PrinterBlock(Blocks.properties().method_31710(class_3620.field_16023)));
        public static final RegistryEntry<MonitorBlock> MONITOR_NORMAL = REGISTRY.register("monitor_normal", () -> new MonitorBlock(Blocks.properties().method_31710(class_3620.field_16023), BlockEntities.MONITOR_NORMAL));
        public static final RegistryEntry<MonitorBlock> MONITOR_ADVANCED = REGISTRY.register("monitor_advanced", () -> new MonitorBlock(Blocks.properties().method_31710(class_3620.field_15994), BlockEntities.MONITOR_ADVANCED));
        public static final RegistryEntry<WirelessModemBlock> WIRELESS_MODEM_NORMAL = REGISTRY.register("wireless_modem_normal", () -> new WirelessModemBlock(Blocks.properties().method_31710(class_3620.field_16023), BlockEntities.WIRELESS_MODEM_NORMAL));
        public static final RegistryEntry<WirelessModemBlock> WIRELESS_MODEM_ADVANCED = REGISTRY.register("wireless_modem_advanced", () -> new WirelessModemBlock(Blocks.properties().method_31710(class_3620.field_15994), BlockEntities.WIRELESS_MODEM_ADVANCED));
        public static final RegistryEntry<WiredModemFullBlock> WIRED_MODEM_FULL = REGISTRY.register("wired_modem_full", () -> new WiredModemFullBlock(Blocks.modemProperties().method_31710(class_3620.field_16023)));
        public static final RegistryEntry<CableBlock> CABLE = REGISTRY.register("cable", () -> new CableBlock(Blocks.modemProperties().method_31710(class_3620.field_16023)));

        private static class_4970.class_2251 properties() {
            return class_4970.class_2251.method_9637().method_9632(2.0f);
        }

        private static class_4970.class_2251 computerProperties() {
            return Blocks.properties().method_26236((block, level, blockPos) -> false);
        }

        private static class_4970.class_2251 turtleProperties() {
            return class_4970.class_2251.method_9637().method_9632(2.5f);
        }

        private static class_4970.class_2251 modemProperties() {
            return class_4970.class_2251.method_9637().method_9632(1.5f);
        }
    }

    public static class BlockEntities {
        static final RegistrationHelper<class_2591<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41255);
        public static final RegistryEntry<class_2591<MonitorBlockEntity>> MONITOR_NORMAL = BlockEntities.ofBlock(Blocks.MONITOR_NORMAL, (p, s) -> new MonitorBlockEntity((class_2591<? extends MonitorBlockEntity>)((class_2591)MONITOR_NORMAL.get()), (class_2338)p, (class_2680)s, false));
        public static final RegistryEntry<class_2591<MonitorBlockEntity>> MONITOR_ADVANCED = BlockEntities.ofBlock(Blocks.MONITOR_ADVANCED, (p, s) -> new MonitorBlockEntity((class_2591<? extends MonitorBlockEntity>)((class_2591)MONITOR_ADVANCED.get()), (class_2338)p, (class_2680)s, true));
        public static final RegistryEntry<class_2591<ComputerBlockEntity>> COMPUTER_NORMAL = BlockEntities.ofBlock(Blocks.COMPUTER_NORMAL, (p, s) -> new ComputerBlockEntity((class_2591<? extends ComputerBlockEntity>)((class_2591)COMPUTER_NORMAL.get()), (class_2338)p, (class_2680)s, ComputerFamily.NORMAL));
        public static final RegistryEntry<class_2591<ComputerBlockEntity>> COMPUTER_ADVANCED = BlockEntities.ofBlock(Blocks.COMPUTER_ADVANCED, (p, s) -> new ComputerBlockEntity((class_2591<? extends ComputerBlockEntity>)((class_2591)COMPUTER_ADVANCED.get()), (class_2338)p, (class_2680)s, ComputerFamily.ADVANCED));
        public static final RegistryEntry<class_2591<CommandComputerBlockEntity>> COMPUTER_COMMAND = BlockEntities.ofBlock(Blocks.COMPUTER_COMMAND, (p, s) -> new CommandComputerBlockEntity((class_2591<? extends ComputerBlockEntity>)((class_2591)COMPUTER_COMMAND.get()), (class_2338)p, (class_2680)s));
        public static final RegistryEntry<class_2591<TurtleBlockEntity>> TURTLE_NORMAL = BlockEntities.ofBlock(Blocks.TURTLE_NORMAL, (p, s) -> new TurtleBlockEntity((class_2591<? extends TurtleBlockEntity>)((class_2591)TURTLE_NORMAL.get()), (class_2338)p, (class_2680)s, ComputerFamily.NORMAL));
        public static final RegistryEntry<class_2591<TurtleBlockEntity>> TURTLE_ADVANCED = BlockEntities.ofBlock(Blocks.TURTLE_ADVANCED, (p, s) -> new TurtleBlockEntity((class_2591<? extends TurtleBlockEntity>)((class_2591)TURTLE_ADVANCED.get()), (class_2338)p, (class_2680)s, ComputerFamily.ADVANCED));
        public static final RegistryEntry<class_2591<SpeakerBlockEntity>> SPEAKER = BlockEntities.ofBlock(Blocks.SPEAKER, (p, s) -> new SpeakerBlockEntity((class_2591<SpeakerBlockEntity>)((class_2591)SPEAKER.get()), (class_2338)p, (class_2680)s));
        public static final RegistryEntry<class_2591<DiskDriveBlockEntity>> DISK_DRIVE = BlockEntities.ofBlock(Blocks.DISK_DRIVE, (p, s) -> new DiskDriveBlockEntity((class_2591<DiskDriveBlockEntity>)((class_2591)DISK_DRIVE.get()), (class_2338)p, (class_2680)s));
        public static final RegistryEntry<class_2591<PrinterBlockEntity>> PRINTER = BlockEntities.ofBlock(Blocks.PRINTER, (p, s) -> new PrinterBlockEntity((class_2591<PrinterBlockEntity>)((class_2591)PRINTER.get()), (class_2338)p, (class_2680)s));
        public static final RegistryEntry<class_2591<WiredModemFullBlockEntity>> WIRED_MODEM_FULL = BlockEntities.ofBlock(Blocks.WIRED_MODEM_FULL, (p, s) -> new WiredModemFullBlockEntity((class_2591<WiredModemFullBlockEntity>)((class_2591)WIRED_MODEM_FULL.get()), (class_2338)p, (class_2680)s));
        public static final RegistryEntry<class_2591<CableBlockEntity>> CABLE = BlockEntities.ofBlock(Blocks.CABLE, (p, s) -> new CableBlockEntity((class_2591<? extends CableBlockEntity>)((class_2591)CABLE.get()), (class_2338)p, (class_2680)s));
        public static final RegistryEntry<class_2591<WirelessModemBlockEntity>> WIRELESS_MODEM_NORMAL = BlockEntities.ofBlock(Blocks.WIRELESS_MODEM_NORMAL, (p, s) -> new WirelessModemBlockEntity((class_2591<? extends WirelessModemBlockEntity>)((class_2591)WIRELESS_MODEM_NORMAL.get()), (class_2338)p, (class_2680)s, false));
        public static final RegistryEntry<class_2591<WirelessModemBlockEntity>> WIRELESS_MODEM_ADVANCED = BlockEntities.ofBlock(Blocks.WIRELESS_MODEM_ADVANCED, (p, s) -> new WirelessModemBlockEntity((class_2591<? extends WirelessModemBlockEntity>)((class_2591)WIRELESS_MODEM_ADVANCED.get()), (class_2338)p, (class_2680)s, true));

        private static <T extends class_2586> RegistryEntry<class_2591<T>> ofBlock(RegistryEntry<? extends class_2248> block, BiFunction<class_2338, class_2680, T> factory) {
            return REGISTRY.register(block.id().method_12832(), () -> PlatformHelper.get().createBlockEntityType(factory, (class_2248)block.get()));
        }
    }

    public static final class Items {
        static final RegistrationHelper<class_1792> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41197);
        public static final RegistryEntry<ComputerItem> COMPUTER_NORMAL = Items.ofBlock(Blocks.COMPUTER_NORMAL, ComputerItem::new);
        public static final RegistryEntry<ComputerItem> COMPUTER_ADVANCED = Items.ofBlock(Blocks.COMPUTER_ADVANCED, ComputerItem::new);
        public static final RegistryEntry<ComputerItem> COMPUTER_COMMAND = Items.ofBlock(Blocks.COMPUTER_COMMAND, CommandComputerItem::new);
        public static final RegistryEntry<PocketComputerItem> POCKET_COMPUTER_NORMAL = REGISTRY.register("pocket_computer_normal", () -> new PocketComputerItem(Items.properties().method_7889(1), ComputerFamily.NORMAL));
        public static final RegistryEntry<PocketComputerItem> POCKET_COMPUTER_ADVANCED = REGISTRY.register("pocket_computer_advanced", () -> new PocketComputerItem(Items.properties().method_7889(1), ComputerFamily.ADVANCED));
        public static final RegistryEntry<TurtleItem> TURTLE_NORMAL = Items.ofBlock(Blocks.TURTLE_NORMAL, TurtleItem::new);
        public static final RegistryEntry<TurtleItem> TURTLE_ADVANCED = Items.ofBlock(Blocks.TURTLE_ADVANCED, TurtleItem::new);
        public static final RegistryEntry<DiskItem> DISK = REGISTRY.register("disk", () -> new DiskItem(Items.properties().method_7889(1)));
        public static final RegistryEntry<TreasureDiskItem> TREASURE_DISK = REGISTRY.register("treasure_disk", () -> new TreasureDiskItem(Items.properties().method_7889(1)));
        public static final RegistryEntry<PrintoutItem> PRINTED_PAGE = REGISTRY.register("printed_page", () -> new PrintoutItem(Items.properties().method_7889(1), PrintoutItem.Type.PAGE));
        public static final RegistryEntry<PrintoutItem> PRINTED_PAGES = REGISTRY.register("printed_pages", () -> new PrintoutItem(Items.properties().method_7889(1), PrintoutItem.Type.PAGES));
        public static final RegistryEntry<PrintoutItem> PRINTED_BOOK = REGISTRY.register("printed_book", () -> new PrintoutItem(Items.properties().method_7889(1), PrintoutItem.Type.BOOK));
        public static final RegistryEntry<class_1747> SPEAKER = Items.ofBlock(Blocks.SPEAKER, class_1747::new);
        public static final RegistryEntry<class_1747> DISK_DRIVE = Items.ofBlock(Blocks.DISK_DRIVE, class_1747::new);
        public static final RegistryEntry<class_1747> PRINTER = Items.ofBlock(Blocks.PRINTER, class_1747::new);
        public static final RegistryEntry<class_1747> MONITOR_NORMAL = Items.ofBlock(Blocks.MONITOR_NORMAL, class_1747::new);
        public static final RegistryEntry<class_1747> MONITOR_ADVANCED = Items.ofBlock(Blocks.MONITOR_ADVANCED, class_1747::new);
        public static final RegistryEntry<class_1747> WIRELESS_MODEM_NORMAL = Items.ofBlock(Blocks.WIRELESS_MODEM_NORMAL, class_1747::new);
        public static final RegistryEntry<class_1747> WIRELESS_MODEM_ADVANCED = Items.ofBlock(Blocks.WIRELESS_MODEM_ADVANCED, class_1747::new);
        public static final RegistryEntry<class_1747> WIRED_MODEM_FULL = Items.ofBlock(Blocks.WIRED_MODEM_FULL, class_1747::new);
        public static final RegistryEntry<CableBlockItem.Cable> CABLE = REGISTRY.register("cable", () -> new CableBlockItem.Cable((CableBlock)((Object)((Object)Blocks.CABLE.get())), Items.properties()));
        public static final RegistryEntry<CableBlockItem.WiredModem> WIRED_MODEM = REGISTRY.register("wired_modem", () -> new CableBlockItem.WiredModem((CableBlock)((Object)((Object)Blocks.CABLE.get())), Items.properties()));

        private static class_1792.class_1793 properties() {
            return new class_1792.class_1793();
        }

        private static <B extends class_2248, I extends class_1792> RegistryEntry<I> ofBlock(RegistryEntry<B> parent, BiFunction<B, class_1792.class_1793, I> supplier) {
            return REGISTRY.register(parent.id().method_12832(), () -> (class_1792)supplier.apply((class_2248)parent.get(), Items.properties()));
        }
    }

    public static class TurtleSerialisers {
        static final RegistrationHelper<TurtleUpgradeSerialiser<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(TurtleUpgradeSerialiser.registryId());
        public static final RegistryEntry<TurtleUpgradeSerialiser<TurtleSpeaker>> SPEAKER = REGISTRY.register("speaker", () -> TurtleUpgradeSerialiser.simpleWithCustomItem(TurtleSpeaker::new));
        public static final RegistryEntry<TurtleUpgradeSerialiser<TurtleCraftingTable>> WORKBENCH = REGISTRY.register("workbench", () -> TurtleUpgradeSerialiser.simpleWithCustomItem(TurtleCraftingTable::new));
        public static final RegistryEntry<TurtleUpgradeSerialiser<TurtleModem>> WIRELESS_MODEM_NORMAL = REGISTRY.register("wireless_modem_normal", () -> TurtleUpgradeSerialiser.simpleWithCustomItem((id, item) -> new TurtleModem((class_2960)id, (class_1799)item, false)));
        public static final RegistryEntry<TurtleUpgradeSerialiser<TurtleModem>> WIRELESS_MODEM_ADVANCED = REGISTRY.register("wireless_modem_advanced", () -> TurtleUpgradeSerialiser.simpleWithCustomItem((id, item) -> new TurtleModem((class_2960)id, (class_1799)item, true)));
        public static final RegistryEntry<TurtleUpgradeSerialiser<TurtleTool>> TOOL = REGISTRY.register("tool", () -> TurtleToolSerialiser.INSTANCE);
    }

    public static class PocketUpgradeSerialisers {
        static final RegistrationHelper<PocketUpgradeSerialiser<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(PocketUpgradeSerialiser.registryId());
        public static final RegistryEntry<PocketUpgradeSerialiser<PocketSpeaker>> SPEAKER = REGISTRY.register("speaker", () -> PocketUpgradeSerialiser.simpleWithCustomItem(PocketSpeaker::new));
        public static final RegistryEntry<PocketUpgradeSerialiser<PocketModem>> WIRELESS_MODEM_NORMAL = REGISTRY.register("wireless_modem_normal", () -> PocketUpgradeSerialiser.simpleWithCustomItem((id, item) -> new PocketModem((class_2960)id, (class_1799)item, false)));
        public static final RegistryEntry<PocketUpgradeSerialiser<PocketModem>> WIRELESS_MODEM_ADVANCED = REGISTRY.register("wireless_modem_advanced", () -> PocketUpgradeSerialiser.simpleWithCustomItem((id, item) -> new PocketModem((class_2960)id, (class_1799)item, true)));
    }

    public static class Menus {
        static final RegistrationHelper<class_3917<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41207);
        public static final RegistryEntry<class_3917<ComputerMenuWithoutInventory>> COMPUTER = REGISTRY.register("computer", () -> ContainerData.toType(ComputerContainerData::new, (id, inv, data) -> new ComputerMenuWithoutInventory((class_3917<? extends AbstractComputerMenu>)((class_3917)COMPUTER.get()), id, inv, (ComputerContainerData)data)));
        public static final RegistryEntry<class_3917<ComputerMenuWithoutInventory>> POCKET_COMPUTER = REGISTRY.register("pocket_computer", () -> ContainerData.toType(ComputerContainerData::new, (id, inv, data) -> new ComputerMenuWithoutInventory((class_3917<? extends AbstractComputerMenu>)((class_3917)POCKET_COMPUTER.get()), id, inv, (ComputerContainerData)data)));
        public static final RegistryEntry<class_3917<ComputerMenuWithoutInventory>> POCKET_COMPUTER_NO_TERM = REGISTRY.register("pocket_computer_no_term", () -> ContainerData.toType(ComputerContainerData::new, (id, inv, data) -> new ComputerMenuWithoutInventory((class_3917<? extends AbstractComputerMenu>)((class_3917)POCKET_COMPUTER_NO_TERM.get()), id, inv, (ComputerContainerData)data)));
        public static final RegistryEntry<class_3917<TurtleMenu>> TURTLE = REGISTRY.register("turtle", () -> ContainerData.toType(ComputerContainerData::new, TurtleMenu::ofMenuData));
        public static final RegistryEntry<class_3917<DiskDriveMenu>> DISK_DRIVE = REGISTRY.register("disk_drive", () -> new class_3917(DiskDriveMenu::new, class_7701.field_40182));
        public static final RegistryEntry<class_3917<PrinterMenu>> PRINTER = REGISTRY.register("printer", () -> new class_3917(PrinterMenu::new, class_7701.field_40182));
        public static final RegistryEntry<class_3917<HeldItemMenu>> PRINTOUT = REGISTRY.register("printout", () -> ContainerData.toType(HeldItemContainerData::new, HeldItemMenu::createPrintout));
        public static final RegistryEntry<class_3917<ViewComputerMenu>> VIEW_COMPUTER = REGISTRY.register("view_computer", () -> ContainerData.toType(ComputerContainerData::new, ViewComputerMenu::new));
    }

    static class ArgumentTypes {
        static final RegistrationHelper<class_2314<?, ?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41262);

        ArgumentTypes() {
        }

        private static <T extends ArgumentType<?>> void registerUnsafe(String name, Class<T> type, class_2314<?, ?> serializer) {
            REGISTRY.register(name, () -> PlatformHelper.get().registerArgumentTypeInfo(type, serializer));
        }

        private static <T extends ArgumentType<?>> void register(String name, Class<T> type, class_2314<T, ?> serializer) {
            REGISTRY.register(name, () -> PlatformHelper.get().registerArgumentTypeInfo(type, serializer));
        }

        private static <T extends ArgumentType<?>> void register(String name, Class<T> type, T instance) {
            ArgumentTypes.register(name, type, class_2319.method_41999(() -> instance));
        }

        static {
            ArgumentTypes.register("tracking_field", TrackingFieldArgumentType.class, TrackingFieldArgumentType.metric());
            ArgumentTypes.register("computer", ComputerArgumentType.class, ComputerArgumentType.oneComputer());
            ArgumentTypes.register("computers", ComputersArgumentType.class, new ComputersArgumentType.Info());
            ArgumentTypes.registerUnsafe("repeat", RepeatArgumentType.class, new RepeatArgumentType.Info());
        }
    }

    public static class LootItemConditionTypes {
        static final RegistrationHelper<class_5342> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41198);
        public static final RegistryEntry<class_5342> BLOCK_NAMED = REGISTRY.register("block_named", () -> ConstantLootConditionSerializer.type(BlockNamedEntityLootCondition.INSTANCE));
        public static final RegistryEntry<class_5342> PLAYER_CREATIVE = REGISTRY.register("player_creative", () -> ConstantLootConditionSerializer.type(PlayerCreativeLootCondition.INSTANCE));
        public static final RegistryEntry<class_5342> HAS_ID = REGISTRY.register("has_id", () -> ConstantLootConditionSerializer.type(HasComputerIdLootCondition.INSTANCE));
    }

    public static class RecipeSerializers {
        static final RegistrationHelper<class_1865<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_41216);
        public static final RegistryEntry<class_1865<CustomShapedRecipe>> SHAPED = REGISTRY.register("shaped", () -> CustomShapedRecipe.serialiser(CustomShapedRecipe::new));
        public static final RegistryEntry<class_1865<CustomShapelessRecipe>> SHAPELESS = REGISTRY.register("shapeless", () -> CustomShapelessRecipe.serialiser(CustomShapelessRecipe::new));
        public static final RegistryEntry<class_1865<ImpostorShapedRecipe>> IMPOSTOR_SHAPED = REGISTRY.register("impostor_shaped", () -> CustomShapedRecipe.serialiser(ImpostorShapedRecipe::new));
        public static final RegistryEntry<class_1865<ImpostorShapelessRecipe>> IMPOSTOR_SHAPELESS = REGISTRY.register("impostor_shapeless", () -> CustomShapelessRecipe.serialiser(ImpostorShapelessRecipe::new));
        public static final RegistryEntry<class_1866<ColourableRecipe>> DYEABLE_ITEM = RecipeSerializers.simple("colour", ColourableRecipe::new);
        public static final RegistryEntry<class_1866<ClearColourRecipe>> DYEABLE_ITEM_CLEAR = RecipeSerializers.simple("clear_colour", ClearColourRecipe::new);
        public static final RegistryEntry<class_1865<TurtleRecipe>> TURTLE = REGISTRY.register("turtle", () -> TurtleRecipe.validatingSerialiser(TurtleRecipe::of));
        public static final RegistryEntry<class_1866<TurtleUpgradeRecipe>> TURTLE_UPGRADE = RecipeSerializers.simple("turtle_upgrade", TurtleUpgradeRecipe::new);
        public static final RegistryEntry<class_1865<TurtleOverlayRecipe>> TURTLE_OVERLAY = REGISTRY.register("turtle_overlay", TurtleOverlayRecipe.Serializer::new);
        public static final RegistryEntry<class_1866<PocketComputerUpgradeRecipe>> POCKET_COMPUTER_UPGRADE = RecipeSerializers.simple("pocket_computer_upgrade", PocketComputerUpgradeRecipe::new);
        public static final RegistryEntry<class_1866<PrintoutRecipe>> PRINTOUT = RecipeSerializers.simple("printout", PrintoutRecipe::new);
        public static final RegistryEntry<class_1866<DiskRecipe>> DISK = RecipeSerializers.simple("disk", DiskRecipe::new);
        public static final RegistryEntry<class_1865<ComputerUpgradeRecipe>> COMPUTER_UPGRADE = REGISTRY.register("computer_upgrade", ComputerUpgradeRecipe.Serializer::new);

        private static <T extends class_1852> RegistryEntry<class_1866<T>> simple(String name, class_1866.class_7711<T> factory) {
            return REGISTRY.register(name, () -> new class_1866(factory));
        }
    }

    public static class Permissions {
        static final PermissionRegistry REGISTRY = PermissionRegistry.create();
        public static final Predicate<class_2168> PERMISSION_DUMP = REGISTRY.registerCommand("dump", UserLevel.OWNER_OP);
        public static final Predicate<class_2168> PERMISSION_SHUTDOWN = REGISTRY.registerCommand("shutdown", UserLevel.OWNER_OP);
        public static final Predicate<class_2168> PERMISSION_TURN_ON = REGISTRY.registerCommand("turn_on", UserLevel.OWNER_OP);
        public static final Predicate<class_2168> PERMISSION_TP = REGISTRY.registerCommand("tp", UserLevel.OP);
        public static final Predicate<class_2168> PERMISSION_TRACK = REGISTRY.registerCommand("track", UserLevel.OWNER_OP);
        public static final Predicate<class_2168> PERMISSION_QUEUE = REGISTRY.registerCommand("queue", UserLevel.ANYONE);
        public static final Predicate<class_2168> PERMISSION_VIEW = REGISTRY.registerCommand("view", UserLevel.OP);
    }

    static class CreativeTabs {
        static final RegistrationHelper<class_1761> REGISTRY = PlatformHelper.get().createRegistrationHelper(class_7924.field_44688);
        private static final RegistryEntry<class_1761> TAB = REGISTRY.register("tab", () -> PlatformHelper.get().newCreativeModeTab().method_47320(() -> new class_1799((class_1935)Items.COMPUTER_NORMAL.get())).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.computercraft")).method_47317((context, out) -> {
            out.method_45420(new class_1799((class_1935)Items.COMPUTER_NORMAL.get()));
            out.method_45420(new class_1799((class_1935)Items.COMPUTER_ADVANCED.get()));
            if (context.comp_1252()) {
                out.method_45420(new class_1799((class_1935)Items.COMPUTER_COMMAND.get()));
            }
            ModRegistry.addTurtle(out, (TurtleItem)Items.TURTLE_NORMAL.get());
            ModRegistry.addTurtle(out, (TurtleItem)Items.TURTLE_ADVANCED.get());
            ModRegistry.addPocket(out, (PocketComputerItem)Items.POCKET_COMPUTER_NORMAL.get());
            ModRegistry.addPocket(out, (PocketComputerItem)Items.POCKET_COMPUTER_ADVANCED.get());
            out.method_45421((class_1935)Items.WIRELESS_MODEM_NORMAL.get());
            out.method_45421((class_1935)Items.WIRELESS_MODEM_ADVANCED.get());
            out.method_45421((class_1935)Items.CABLE.get());
            out.method_45421((class_1935)Items.WIRED_MODEM.get());
            out.method_45421((class_1935)Items.WIRED_MODEM_FULL.get());
            out.method_45421((class_1935)Items.MONITOR_NORMAL.get());
            out.method_45421((class_1935)Items.MONITOR_ADVANCED.get());
            out.method_45421((class_1935)Items.SPEAKER.get());
            out.method_45421((class_1935)Items.PRINTER.get());
            out.method_45421((class_1935)Items.PRINTED_PAGE.get());
            out.method_45421((class_1935)Items.PRINTED_PAGES.get());
            out.method_45421((class_1935)Items.PRINTED_BOOK.get());
            out.method_45421((class_1935)Items.DISK_DRIVE.get());
            for (int colour = 0; colour < 16; ++colour) {
                out.method_45420(DiskItem.createFromIDAndColour(-1, null, Colour.VALUES[colour].getHex()));
            }
        }).method_47324());

        CreativeTabs() {
        }
    }
}

