/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.core.filesystem.SubMount;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_4538;

public class TreasureDiskItem
extends class_1792
implements IMedia {
    private static final String NBT_TITLE = "Title";
    private static final String NBT_COLOUR = "Colour";
    private static final String NBT_SUB_PATH = "SubPath";

    public TreasureDiskItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 tooltipOptions) {
        String label = TreasureDiskItem.getTitle(stack);
        if (!label.isEmpty()) {
            list.add((class_2561)class_2561.method_43470((String)label));
        }
    }

    public boolean doesSneakBypassUse(class_1799 stack, class_4538 world, class_2338 pos, class_1657 player) {
        return true;
    }

    @Override
    public String getLabel(class_1799 stack) {
        return TreasureDiskItem.getTitle(stack);
    }

    @Override
    @Nullable
    public Mount createDataMount(class_1799 stack, class_3218 level) {
        Mount rootTreasure = ComputerCraftAPI.createResourceMount(level.method_8503(), "computercraft", "lua/treasure");
        if (rootTreasure == null) {
            return null;
        }
        String subPath = TreasureDiskItem.getSubPath(stack);
        try {
            if (rootTreasure.exists(subPath)) {
                return new SubMount(rootTreasure, subPath);
            }
            if (rootTreasure.exists("deprecated/" + subPath)) {
                return new SubMount(rootTreasure, "deprecated/" + subPath);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class_1799 create(String subPath, int colourIndex) {
        class_1799 result = new class_1799((class_1935)ModRegistry.Items.TREASURE_DISK.get());
        class_2487 nbt = result.method_7948();
        nbt.method_10582(NBT_SUB_PATH, subPath);
        int slash = subPath.indexOf(47);
        if (slash >= 0) {
            String author = subPath.substring(0, slash);
            String title = subPath.substring(slash + 1);
            nbt.method_10582(NBT_TITLE, "\"" + title + "\" by " + author);
        } else {
            nbt.method_10582(NBT_TITLE, "untitled");
        }
        nbt.method_10569(NBT_COLOUR, Colour.values()[colourIndex].getHex());
        return result;
    }

    private static String getTitle(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_TITLE) ? nbt.method_10558(NBT_TITLE) : "'missingno' by how did you get this anyway?";
    }

    private static String getSubPath(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_SUB_PATH) ? nbt.method_10558(NBT_SUB_PATH) : "dan200/alongtimeago";
    }

    public static int getColour(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_COLOUR) ? nbt.method_10550(NBT_COLOUR) : Colour.BLUE.getHex();
    }
}

