/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.methods.PeripheralMethod;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.peripheral.generic.SaturatedMethod;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.server.MinecraftServer;

final class GenericPeripheralBuilder {
    private final MethodSupplier<PeripheralMethod> peripheralMethods;
    @Nullable
    private String name;
    private final Set<String> additionalTypes = new HashSet<String>(0);
    private final ArrayList<SaturatedMethod> methods = new ArrayList();

    GenericPeripheralBuilder(MinecraftServer server) {
        this.peripheralMethods = ServerContext.get(server).peripheralMethods();
    }

    @Nullable
    IPeripheral toPeripheral(class_2586 blockEntity, class_2350 side) {
        if (this.methods.isEmpty()) {
            return null;
        }
        this.methods.trimToSize();
        return new GenericPeripheral(blockEntity, side, this.name, this.additionalTypes, this.methods);
    }

    boolean addMethods(Object target) {
        return this.peripheralMethods.forEachSelfMethod(target, (name, method, info) -> {
            PeripheralType type;
            this.methods.add(new SaturatedMethod(target, name, (PeripheralMethod)method));
            PeripheralType peripheralType = type = info == null ? null : info.genericType();
            if (type != null && type.getPrimaryType() != null) {
                String primaryType = type.getPrimaryType();
                if (this.name == null || this.name.compareTo(primaryType) > 0) {
                    this.name = primaryType;
                }
            }
            if (type != null) {
                this.additionalTypes.addAll(type.getAdditionalTypes());
            }
        });
    }
}

