/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralBuilder;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPeripheralProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GenericPeripheralProvider.class);
    private static final List<Lookup<?>> lookups = List.of(InventoryMethods::extractContainer);

    @Nullable
    public static IPeripheral getPeripheral(class_1937 level, class_2338 pos, class_2350 side, @Nullable class_2586 blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        MinecraftServer server = level.method_8503();
        if (server == null) {
            LOG.warn("Fetching peripherals on a non-server level {}.", (Object)level, (Object)new IllegalStateException("Fetching peripherals on a non-server level."));
            return null;
        }
        GenericPeripheralBuilder builder = new GenericPeripheralBuilder(server);
        builder.addMethods(blockEntity);
        for (Lookup<?> lookup : lookups) {
            Object contents = lookup.find(level, pos, blockEntity.method_11010(), blockEntity, side);
            if (contents == null) continue;
            builder.addMethods(contents);
        }
        return builder.toPeripheral(blockEntity, side);
    }

    static interface Lookup<T> {
        @Nullable
        public T find(class_1937 var1, class_2338 var2, class_2680 var3, @Nullable class_2586 var4, class_2350 var5);
    }
}

