/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.base.Objects;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;

public class CableBlockEntity
extends class_2586 {
    private static final String NBT_PERIPHERAL_ENABLED = "PeripheralAccess";
    private boolean invalidPeripheral;
    private boolean peripheralAccessAllowed;
    private final WiredModemLocalPeripheral peripheral = new WiredModemLocalPeripheral(this::queueRefreshPeripheral);
    @Nullable
    private Runnable modemChanged;
    private boolean connectionsFormed = false;
    private final WiredModemElement cable = new CableElement();
    private final WiredNode node = this.cable.getNode();
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final WiredModemPeripheral modem = new WiredModemPeripheral(new ModemState(() -> TickScheduler.schedule(this.tickToken)), this.cable){

        @Override
        protected WiredModemLocalPeripheral getLocalPeripheral() {
            return CableBlockEntity.this.peripheral;
        }

        @Override
        public class_243 getPosition() {
            return class_243.method_24953((class_2382)CableBlockEntity.this.method_11016().method_10093(CableBlockEntity.this.getDirection()));
        }

        @Override
        public Object getTarget() {
            return CableBlockEntity.this;
        }
    };
    private final ComponentAccess<WiredElement> connectedElements = PlatformHelper.get().createWiredElementAccess(x -> this.connectionsChanged());

    public CableBlockEntity(class_2591<? extends CableBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    private void onRemove() {
        if (this.field_11863 == null || !this.field_11863.field_9236) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    public void method_11012() {
        super.method_11012();
        this.modem.removed();
        this.onRemove();
    }

    public void method_10996() {
        super.method_10996();
        TickScheduler.schedule(this.tickToken);
    }

    @Deprecated
    public void method_31664(class_2680 state) {
        class_2350 direction = this.getMaybeDirection();
        super.method_31664(state);
        if (this.getMaybeDirection() != direction && this.modemChanged != null) {
            this.modemChanged.run();
        }
    }

    @Nullable
    private class_2350 getMaybeDirection() {
        return ((CableModemVariant)((Object)this.method_11010().method_11654(CableBlock.MODEM))).getFacing();
    }

    private class_2350 getDirection() {
        class_2350 direction = this.getMaybeDirection();
        return direction == null ? class_2350.field_11043 : direction;
    }

    void neighborChanged(class_2338 neighbour) {
        class_2350 dir = this.getDirection();
        if (neighbour.equals((Object)this.method_11016().method_10093(dir)) && this.hasModem() && !this.method_11010().method_26184((class_4538)this.method_10997(), this.method_11016())) {
            if (this.hasCable()) {
                class_2248.method_9577((class_1937)this.method_10997(), (class_2338)this.method_11016(), (class_1799)new class_1799((class_1935)ModRegistry.Items.WIRED_MODEM.get()));
                this.method_10997().method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.None)));
                this.modemChanged();
                this.connectionsChanged();
            } else {
                class_2248.method_9577((class_1937)this.method_10997(), (class_2338)this.method_11016(), (class_1799)new class_1799((class_1935)ModRegistry.Items.WIRED_MODEM.get()));
                this.method_10997().method_8650(this.method_11016(), false);
            }
            return;
        }
        if (!this.field_11863.field_9236 && this.peripheralAccessAllowed) {
            class_2350 facing = this.getDirection();
            if (this.method_11016().method_10093(facing).equals((Object)neighbour)) {
                this.queueRefreshPeripheral();
            }
        }
    }

    private void queueRefreshPeripheral() {
        if (this.invalidPeripheral) {
            return;
        }
        this.invalidPeripheral = true;
        TickScheduler.schedule(this.tickToken);
    }

    private void refreshPeripheral() {
        this.invalidPeripheral = false;
        if (this.field_11863 != null && !this.method_11015() && this.peripheral.attach(this.field_11863, this.method_11016(), this.getDirection())) {
            this.updateConnectedPeripherals();
        }
    }

    class_1269 use(class_1657 player) {
        if (player.method_18276() || !player.method_7294()) {
            return class_1269.field_5811;
        }
        if (!this.canAttachPeripheral()) {
            return class_1269.field_5814;
        }
        if (this.method_10997().field_9236) {
            return class_1269.field_5812;
        }
        String oldName = this.peripheral.getConnectedName();
        this.togglePeripheralAccess();
        String newName = this.peripheral.getConnectedName();
        if (!Objects.equal((Object)newName, (Object)oldName)) {
            if (oldName != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"chat.computercraft.wired_modem.peripheral_disconnected", (Object[])new Object[]{ChatHelpers.copy(oldName)}), false);
            }
            if (newName != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"chat.computercraft.wired_modem.peripheral_connected", (Object[])new Object[]{ChatHelpers.copy(newName)}), false);
            }
        }
        return class_1269.field_21466;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.peripheralAccessAllowed = nbt.method_10577(NBT_PERIPHERAL_ENABLED) || nbt.method_10577("PeirpheralAccess");
        this.peripheral.read(nbt, "");
    }

    public void method_11007(class_2487 nbt) {
        nbt.method_10556(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        this.peripheral.write(nbt, "");
        super.method_11007(nbt);
    }

    private void updateBlockState() {
        CableModemVariant newVariant;
        class_2680 state = this.method_11010();
        CableModemVariant oldVariant = (CableModemVariant)((Object)state.method_11654(CableBlock.MODEM));
        if (oldVariant != (newVariant = CableModemVariant.from(oldVariant.getFacing(), this.modem.getModemState().isOpen(), this.peripheralAccessAllowed))) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)state.method_11657(CableBlock.MODEM, (Comparable)((Object)newVariant)));
        }
    }

    void blockTick() {
        if (this.method_10997().field_9236) {
            return;
        }
        if (this.invalidPeripheral) {
            this.refreshPeripheral();
        }
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
            if (this.peripheralAccessAllowed) {
                this.peripheral.attach(this.field_11863, this.field_11867, this.getDirection());
                this.updateConnectedPeripherals();
            }
        }
    }

    void connectionsChanged() {
        if (this.method_10997().field_9236) {
            return;
        }
        class_2680 state = this.method_11010();
        class_1937 world = this.method_10997();
        class_2338 current = this.method_11016();
        for (class_2350 facing : DirectionUtil.FACINGS) {
            WiredElement element;
            class_2338 offset = current.method_10093(facing);
            if (!world.method_8477(offset) || (element = this.connectedElements.get((class_3218)world, current, facing)) == null) continue;
            WiredNode node = element.getNode();
            if (CableBlock.canConnectIn(state, facing)) {
                this.node.connectTo(node);
                continue;
            }
            if (this.node.getNetwork() != node.getNetwork()) continue;
            this.node.disconnectFrom(node);
        }
    }

    void modemChanged() {
        if (this.modemChanged != null) {
            this.modemChanged.run();
        }
        if (this.method_10997().field_9236) {
            return;
        }
        if (!this.canAttachPeripheral() && this.peripheralAccessAllowed) {
            this.peripheralAccessAllowed = false;
            this.peripheral.detach();
            this.node.updatePeripherals(Collections.emptyMap());
            this.method_5431();
            this.updateBlockState();
        }
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            this.peripheral.attach(this.field_11863, this.method_11016(), this.getDirection());
            if (!this.peripheral.hasPeripheral()) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.peripheral.toMap());
        } else {
            this.peripheral.detach();
            this.peripheralAccessAllowed = false;
            this.node.updatePeripherals(Collections.emptyMap());
        }
        this.updateBlockState();
    }

    private void updateConnectedPeripherals() {
        Map<String, IPeripheral> peripherals = this.peripheral.toMap();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    @Nullable
    public WiredElement getWiredElement(@Nullable class_2350 direction) {
        return direction == null || CableBlock.canConnectIn(this.method_11010(), direction) ? this.cable : null;
    }

    @Nullable
    public IPeripheral getPeripheral(@Nullable class_2350 direction) {
        return direction == null || this.getMaybeDirection() == direction ? this.modem : null;
    }

    public void onModemChanged(Runnable callback) {
        this.modemChanged = callback;
    }

    boolean hasCable() {
        return (Boolean)this.method_11010().method_11654((class_2769)CableBlock.CABLE);
    }

    public boolean hasModem() {
        return this.method_11010().method_11654(CableBlock.MODEM) != CableModemVariant.None;
    }

    private boolean canAttachPeripheral() {
        return this.hasCable() && this.hasModem();
    }

    private final class CableElement
    extends WiredModemElement {
        private CableElement() {
        }

        @Override
        public class_1937 getLevel() {
            return CableBlockEntity.this.method_10997();
        }

        @Override
        public class_243 getPosition() {
            return class_243.method_24953((class_2382)CableBlockEntity.this.method_11016());
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            CableBlockEntity.this.modem.attachPeripheral(name, peripheral);
        }

        @Override
        protected void detachPeripheral(String name) {
            CableBlockEntity.this.modem.detachPeripheral(name);
        }
    }
}

