/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import dan200.computercraft.shared.platform.ContainerTransfer;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class FabricContainerTransfer
implements ContainerTransfer {
    private final Storage<ItemVariant> storage;

    private FabricContainerTransfer(Storage<ItemVariant> storage) {
        this.storage = storage;
    }

    public static ContainerTransfer of(Storage<ItemVariant> storage) {
        FabricContainerTransfer fabricContainerTransfer;
        if (storage instanceof SlottedStorage) {
            SlottedStorage inv = (SlottedStorage)storage;
            fabricContainerTransfer = new SlottedImpl((SlottedStorage<ItemVariant>)inv);
        } else {
            fabricContainerTransfer = new FabricContainerTransfer(storage);
        }
        return fabricContainerTransfer;
    }

    public static ContainerTransfer.Slotted of(SlottedStorage<ItemVariant> storage) {
        return new SlottedImpl(storage);
    }

    @Override
    public int moveTo(ContainerTransfer destination, int maxAmount) {
        GatePredicate predicate = new GatePredicate();
        long moved = StorageUtil.move(this.storage, ((FabricContainerTransfer)destination).storage, predicate, (long)maxAmount, null);
        if (moved > 0L) {
            return moved > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)moved;
        }
        return predicate.hasItem() ? -2 : -1;
    }

    private static final class SlottedImpl
    extends FabricContainerTransfer
    implements ContainerTransfer.Slotted {
        private final SlottedStorage<ItemVariant> storage;

        SlottedImpl(SlottedStorage<ItemVariant> storage) {
            super((Storage<ItemVariant>)storage);
            this.storage = storage;
        }

        @Override
        public ContainerTransfer rotate(int offset) {
            return offset == 0 ? this : SlottedImpl.of(new OffsetStorage(this.storage, offset));
        }

        @Override
        public ContainerTransfer singleSlot(int slot) {
            return SlottedImpl.of((SlottedStorage<ItemVariant>)this.storage.getSlot(slot));
        }
    }

    private static final class GatePredicate<T>
    implements Predicate<T> {
        @Nullable
        private T instance = null;

        private GatePredicate() {
        }

        @Override
        public boolean test(T o) {
            if (this.instance == null) {
                this.instance = o;
                return true;
            }
            return this.instance.equals(o);
        }

        boolean hasItem() {
            return this.instance != null;
        }
    }

    private record OffsetStorage(SlottedStorage<ItemVariant> storage, int offset) implements Storage<ItemVariant>
    {
        public boolean supportsInsertion() {
            for (SingleSlotStorage slot : this.storage.getSlots()) {
                if (!slot.supportsInsertion()) continue;
                return true;
            }
            return false;
        }

        public boolean supportsExtraction() {
            for (SingleSlotStorage slot : this.storage.getSlots()) {
                if (!slot.supportsExtraction()) continue;
                return true;
            }
            return false;
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            List slots = this.storage.getSlots();
            int size = slots.size();
            long transferred = 0L;
            for (int i = 0; i < size && (transferred += ((SingleSlotStorage)slots.get(this.wrap(i, size))).insert((Object)resource, maxAmount - transferred, transaction)) < maxAmount; ++i) {
            }
            return transferred;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            List slots = this.storage.getSlots();
            int size = slots.size();
            long transferred = 0L;
            for (int i = 0; i < size && (transferred += ((SingleSlotStorage)slots.get(this.wrap(i, size))).extract((Object)resource, maxAmount - transferred, transaction)) < maxAmount; ++i) {
            }
            return transferred;
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            final List slots = this.storage.getSlots();
            final int size = slots.size();
            return new Iterator<StorageView<ItemVariant>>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < size;
                }

                @Override
                public StorageView<ItemVariant> next() {
                    int slot;
                    if ((slot = this.i++) >= size) {
                        throw new NoSuchElementException();
                    }
                    return (StorageView)slots.get(this.wrap(slot, size));
                }
            };
        }

        int wrap(int slot, int size) {
            int actualSlot = slot + this.offset;
            return actualSlot >= size ? actualSlot - size : actualSlot;
        }
    }
}

