/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.combatroll.client.CombatRollClient;
import net.combatroll.client.MinecraftClientExtension;
import net.combatroll.client.RollManager;
import net.combatroll.client.gui.HudElement;
import net.combatroll.config.ClientConfig;
import net.combatroll.config.HudConfig;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class HudRenderHelper {
    private static final class_2960 ARROW = new class_2960("combatroll", "textures/hud/arrow.png");
    private static final class_2960 ARROW_BACKGROUND = new class_2960("combatroll", "textures/hud/arrow_background.png");

    public static void render(class_332 context, float tickDelta) {
        ViewModel viewModel;
        ClientConfig config = CombatRollClient.config;
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            viewModel = ViewModel.mock();
        } else {
            if (player.method_7337() && !config.showHUDInCreative) {
                return;
            }
            if (player.method_7325()) {
                return;
            }
            RollManager.CooldownInfo cooldownInfo = ((MinecraftClientExtension)client).getRollManager().getCooldown();
            if (!config.showWhenFull && cooldownInfo.availableRolls() == cooldownInfo.maxRolls()) {
                return;
            }
            viewModel = ViewModel.create(cooldownInfo, tickDelta);
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        HudElement rollWidget = ((HudConfig)CombatRollClient.hudConfig.value).rollWidget;
        class_241 originPoint = rollWidget.origin.getPoint(screenWidth, screenHeight);
        class_241 drawOffset = rollWidget.offset;
        int horizontalSpacing = 8;
        int biggestTextureSize = 15;
        int widgetWidth = biggestTextureSize + horizontalSpacing * viewModel.elements.size();
        int widgetHeight = biggestTextureSize;
        int drawX = (int)(originPoint.field_1343 + drawOffset.field_1343);
        int drawY = (int)(originPoint.field_1342 + drawOffset.field_1342 - (float)(widgetHeight / 2));
        RenderSystem.enableBlend();
        for (ViewModel.Element element : viewModel.elements()) {
            int x = 0;
            int y = 0;
            boolean u = false;
            int v = 0;
            int width = 0;
            int height = 0;
            int textureSize = 0;
            x = drawX;
            y = drawY;
            u = false;
            v = 0;
            textureSize = 15;
            height = 15;
            width = 15;
            context.method_51422(1.0f, 1.0f, 1.0f, (float)config.hudBackgroundOpacity / 100.0f);
            context.method_25290(ARROW_BACKGROUND, x, y, (float)u, (float)v, width, height, textureSize, textureSize);
            int color = element.color;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            int prevTextureSize = textureSize;
            textureSize = 13;
            int shift = (prevTextureSize - textureSize) / 2;
            width = textureSize;
            height = Math.round(element.full * (float)textureSize);
            x = drawX + shift;
            y = drawY + textureSize - height + shift;
            u = false;
            v = textureSize - height;
            context.method_51422(red, green, blue, element.full);
            context.method_25290(ARROW, x, y, (float)u, (float)v, width, height, textureSize, textureSize);
            drawX += horizontalSpacing;
        }
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private record ViewModel(List<Element> elements) {
        static ViewModel create(RollManager.CooldownInfo info, float tickDelta) {
            ClientConfig config = CombatRollClient.config;
            ArrayList<Element> elements = new ArrayList<Element>();
            for (int i = 0; i < info.maxRolls(); ++i) {
                int color = config.hudArrowColor;
                float full = 0.0f;
                if (i == info.availableRolls()) {
                    int sparkleTicks;
                    int missingTicks;
                    full = (float)info.elapsed() / (float)info.total();
                    full = Math.min(full, 1.0f);
                    if (config.playCooldownFlash && (missingTicks = info.total() - info.elapsed()) <= (sparkleTicks = 2)) {
                        float sparkle = (float)(sparkleTicks / 2) - ((float)(missingTicks - 1) + (1.0f - tickDelta)) / (float)sparkleTicks;
                        float red = (float)(color >> 16 & 0xFF) / 255.0f;
                        float green = (float)(color >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(color & 0xFF) / 255.0f;
                        int redBits = (int)(ViewModel.mixNumberFloat(red, 1.0f, sparkle) * 255.0f);
                        int greenBits = (int)(ViewModel.mixNumberFloat(green, 1.0f, sparkle) * 255.0f);
                        int blueBits = (int)(ViewModel.mixNumberFloat(blue, 1.0f, sparkle) * 255.0f);
                        color = redBits;
                        color = (color << 8) + greenBits;
                        color = (color << 8) + blueBits;
                    }
                }
                if (i < info.availableRolls()) {
                    full = 1.0f;
                }
                elements.add(new Element(color, full));
            }
            return new ViewModel(elements);
        }

        static ViewModel mock() {
            ClientConfig config = CombatRollClient.config;
            int color = config.hudArrowColor;
            return new ViewModel(List.of(new Element(color, 1.0f), new Element(color, 0.5f), new Element(color, 0.0f)));
        }

        private static float mixNumberFloat(float a, float b, float bias) {
            return a + (b - a) * bias;
        }

        record Element(int color, float full) {
        }
    }
}

