/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.command.commands;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.CommandHelpHandler;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.standard.StringArgument;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import cloud.commandframework.minecraft.extras.MinecraftHelp;
import cloud.commandframework.minecraft.extras.RichDescription;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.Commands;
import xyz.jpenilla.tabtps.common.command.TabTPSCommand;

public final class HelpCommand
extends TabTPSCommand {
    public HelpCommand(@NonNull TabTPS tabTPS, @NonNull Commands commands) {
        super(tabTPS, commands);
    }

    @Override
    public void register() {
        CommandArgument queryArgument = StringArgument.builder((String)"query").greedy().asOptional().withSuggestionsProvider(this::helpQuerySuggestions).build();
        this.commands.registerSubcommand(builder -> builder.literal("help", new String[0]).argument(queryArgument, (ArgumentDescription)RichDescription.of((ComponentLike)Messages.COMMAND_HELP_ARGUMENTS_QUERY)).meta(MinecraftExtrasMetaKeys.DESCRIPTION, (Object)Messages.COMMAND_HELP_DESCRIPTION.plain(new ComponentLike[0])).handler(this::executeHelp));
    }

    private void executeHelp(@NonNull CommandContext<Commander> context) {
        String query = (String)context.getOrDefault("query", null);
        this.help().queryCommands(query == null ? "" : query, (Object)((Commander)context.getSender()));
    }

    public @NonNull List<String> helpQuerySuggestions(@NonNull CommandContext<Commander> context, @NonNull String input) {
        return ((CommandHelpHandler.IndexHelpTopic)this.commands.commandManager().createCommandHelpHandler().queryHelp((Object)((Commander)context.getSender()), "")).getEntries().stream().map(CommandHelpHandler.VerboseHelpEntry::getSyntaxString).collect(Collectors.toList());
    }

    private @NonNull MinecraftHelp<Commander> help() {
        MinecraftHelp help = MinecraftHelp.createNative((String)"/tabtps help", this.commands.commandManager());
        help.setHelpColors(this.tabTPS.configManager().pluginSettings().helpColors().toCloud());
        help.messageProvider(HelpCommand::helpMessage);
        return help;
    }

    private static @NonNull Component helpMessage(@NonNull Commander sender, @NonNull String key, String ... args) {
        return Component.translatable((String)(Messages.bundleName() + "/help." + key), Arrays.stream(args).map(Component::text).collect(Collectors.toList()));
    }
}

