/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.display.task;

import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.User;
import xyz.jpenilla.tabtps.common.config.DisplayConfig;
import xyz.jpenilla.tabtps.common.config.Theme;
import xyz.jpenilla.tabtps.common.display.Display;
import xyz.jpenilla.tabtps.common.module.ModuleRenderer;

public final class BossBarDisplayTask
implements Display {
    private final TabTPS tabTPS;
    private final User<?> user;
    private final DisplayConfig.BossBarSettings settings;
    private final ModuleRenderer renderer;
    private final BossBar bar;

    public BossBarDisplayTask(@NonNull TabTPS tabTPS, @NonNull User<?> user, @NonNull DisplayConfig.BossBarSettings settings) {
        this.tabTPS = tabTPS;
        this.user = user;
        this.settings = settings;
        Theme theme = tabTPS.configManager().theme(settings.theme());
        this.renderer = ModuleRenderer.builder().modules(tabTPS, theme, user, settings.modules()).separator(settings.separator()).moduleRenderFunction(ModuleRenderer.standardRenderFunction(theme)).build();
        this.bar = BossBar.bossBar((Component)this.renderer.render(), (float)this.progress(), (BossBar.Color)this.color(), (BossBar.Overlay)this.overlay());
        user.showBossBar(this.bar);
    }

    private float progress() {
        switch (this.settings.fillMode()) {
            case MSPT: {
                return this.msptProgress();
            }
            case TPS: {
                return this.tpsProgress();
            }
            case REVERSE_MSPT: {
                return 1.0f - this.msptProgress();
            }
            case REVERSE_TPS: {
                return 1.0f - this.tpsProgress();
            }
        }
        throw new IllegalStateException("Unknown or invalid fill mode: " + (Object)((Object)this.settings.fillMode()));
    }

    private float msptProgress() {
        return BossBarDisplayTask.ensureInRange(this.tabTPS.platform().tickTimeService().averageMspt() / 50.0);
    }

    private float tpsProgress() {
        return BossBarDisplayTask.ensureInRange(this.tabTPS.platform().tickTimeService().recentTps()[0] / 20.0);
    }

    private static float ensureInRange(double value) {
        return (float)Math.max(0.0, Math.min(1.0, value));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color color() {
        switch (this.settings.fillMode()) {
            case MSPT: {
                double mspt = this.tabTPS.platform().tickTimeService().averageMspt();
                if (mspt < 25.0) {
                    return this.settings.colors().goodPerformance();
                }
                if (mspt < 40.0) {
                    return this.settings.colors().mediumPerformance();
                }
                return this.settings.colors().lowPerformance();
            }
            case TPS: {
                double tps = this.tabTPS.platform().tickTimeService().recentTps()[0];
                if (tps > 18.5) {
                    return this.settings.colors().goodPerformance();
                }
                if (tps > 15.0) {
                    return this.settings.colors().mediumPerformance();
                }
                return this.settings.colors().lowPerformance();
            }
        }
        throw new IllegalStateException("Unknown or invalid fill mode: " + (Object)((Object)this.settings.fillMode()));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay overlay() {
        return this.settings.overlay();
    }

    private void updateBar() {
        this.bar.progress(this.progress());
        this.bar.color(this.color());
        this.bar.name(this.renderer.render());
    }

    @Override
    public void disable() {
        this.user.hideBossBar(this.bar);
    }

    @Override
    public void run() {
        if (!this.user.online()) {
            this.user.bossBar().stopDisplay();
            return;
        }
        this.updateBar();
    }
}

