/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.util;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.DoubleSummaryStatistics;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class CPUMonitor {
    private int index = 0;
    private volatile double recentProcessCpuLoadSnapshot = 0.0;
    private volatile double recentSystemCpuLoadSnapshot = 0.0;
    private final double[] recentSystemUsage = new double[20];
    private final double[] recentProcessUsage = new double[20];
    private final ScheduledExecutorService executor;
    private final Future<?> monitorTask;

    public CPUMonitor() {
        ScheduledThreadPoolExecutor ex = new ScheduledThreadPoolExecutor(1);
        ex.setRemoveOnCancelPolicy(true);
        this.executor = Executors.unconfigurableScheduledExecutorService(ex);
        this.monitorTask = this.executor.scheduleAtFixedRate(this::recordUsage, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.monitorTask.cancel(false);
        this.executor.shutdown();
    }

    private void nextIndex() {
        ++this.index;
        if (this.index == 20) {
            this.index = 0;
        }
    }

    private void recordUsage() {
        this.recentProcessUsage[this.index] = CPUMonitor.currentProcessCpuLoad();
        this.recentSystemUsage[this.index] = CPUMonitor.currentSystemCpuLoad();
        this.recentProcessCpuLoadSnapshot = this.recentProcessCpuLoad();
        this.recentSystemCpuLoadSnapshot = this.recentSystemCpuLoad();
        this.nextIndex();
    }

    public double recentProcessCpuLoadSnapshot() {
        return this.recentProcessCpuLoadSnapshot;
    }

    public double recentSystemCpuLoadSnapshot() {
        return this.recentSystemCpuLoadSnapshot;
    }

    private double recentProcessCpuLoad() {
        return CPUMonitor.round(CPUMonitor.average(this.recentProcessUsage));
    }

    private double recentSystemCpuLoad() {
        return CPUMonitor.round(CPUMonitor.average(this.recentSystemUsage));
    }

    private static double average(double[] values) {
        DoubleSummaryStatistics statistics = new DoubleSummaryStatistics();
        for (double d : (double[])values.clone()) {
            if (d == 0.0 || Double.isNaN(d)) continue;
            statistics.accept(d);
        }
        return statistics.getAverage();
    }

    private static double round(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    private static double currentProcessCpuLoad() {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getProcessCpuLoad() * 100.0;
    }

    private static double currentSystemCpuLoad() {
        return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getSystemCpuLoad() * 100.0;
    }
}

