/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.util;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import net.kyori.adventure.util.UTF8ResourceBundleControl;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslatableProvider
implements ComponentLike {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslatableProvider.class);
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String PROPERTIES_EXTENSION = ".properties";
    private final String key;

    private TranslatableProvider(String bundleName, String key) {
        this.key = TranslatableProvider.formatKey(bundleName, key);
    }

    public TranslatableComponent plain(ComponentLike ... args) {
        return Component.translatable((String)this.key, (ComponentLike[])args);
    }

    public TranslatableComponent asComponent() {
        return this.plain(new ComponentLike[0]);
    }

    public TranslatableComponent.Builder builder() {
        return Component.translatable().key(this.key);
    }

    public TranslatableComponent build(Consumer<TranslatableComponent.Builder> op) {
        TranslatableComponent.Builder builder = this.builder();
        op.accept(builder);
        return (TranslatableComponent)builder.build();
    }

    public TranslatableComponent styled(TextColor color, ComponentLike ... args) {
        return Component.translatable((String)this.key, (TextColor)color, (ComponentLike[])args);
    }

    public TranslatableComponent styled(TextColor color, TextDecoration decoration, ComponentLike ... args) {
        return Component.translatable((String)this.key, (Style)Style.style((TextColor)color, (TextDecoration[])new TextDecoration[]{decoration}), (ComponentLike[])args);
    }

    public @NonNull String key() {
        return this.key;
    }

    public static TranslatableProvider create(String bundleName, String key) {
        return new TranslatableProvider(bundleName, key);
    }

    private static String formatKey(String bundleName, String key) {
        return bundleName + '/' + key;
    }

    public static void loadBundle(String bundleName, Class<?> clazz) {
        TranslationRegistry registry = TranslationRegistry.create((Key)Key.key((String)"tabtps", (String)bundleName));
        registry.defaultLocale(DEFAULT_LOCALE);
        TranslatableProvider.registerAll(registry, TranslatableProvider.availableLocales(bundleName, clazz), bundleName);
        GlobalTranslator.translator().addSource((Translator)registry);
    }

    private static void registerAll(TranslationRegistry registry, Set<Locale> locales, String bundleName) {
        for (Locale locale : locales) {
            ResourceBundle bundle = PropertyResourceBundle.getBundle(bundleName, locale, UTF8ResourceBundleControl.get());
            for (String key : bundle.keySet()) {
                try {
                    registry.register(TranslatableProvider.formatKey(bundleName, key), locale, new MessageFormat(TranslationRegistry.SINGLE_QUOTE_PATTERN.matcher(bundle.getString(key)).replaceAll("''")));
                }
                catch (ClassCastException | IllegalArgumentException | MissingResourceException ex) {
                    LOGGER.warn("Failed to load translation for key '{}' from bundle '{}' with the '{}' locale.", new Object[]{key, bundleName, locale.getDisplayName(), ex});
                }
            }
        }
    }

    private static Set<Locale> availableLocales(String bundleName, Class<?> clazz) {
        String bundlePath = bundleName.replace('.', '/');
        try {
            int exclamationIdx;
            URL sourceUrl = clazz.getProtectionDomain().getCodeSource().getLocation();
            if (sourceUrl.getProtocol().equals("jar") && (exclamationIdx = sourceUrl.getPath().lastIndexOf(33)) != -1) {
                sourceUrl = new URL(sourceUrl.getPath().substring(0, exclamationIdx));
            }
            Path codeSource = Paths.get(sourceUrl.toURI());
            HashSet<Locale> known = new HashSet<Locale>();
            TranslatableProvider.walkJar(codeSource, stream -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).filter(it -> it.endsWith(PROPERTIES_EXTENSION)).map(it -> it.replace('\\', '/')).map(it -> it.startsWith("/") ? it.substring(1) : it).filter(it -> it.startsWith(bundlePath)).map(it -> it.substring(bundlePath.length()).replaceFirst(PROPERTIES_EXTENSION, "")).filter(it -> it.isEmpty() || it.startsWith("_")).map(string -> {
                if (string.isEmpty()) {
                    return DEFAULT_LOCALE;
                }
                return Objects.requireNonNull(Translator.parseLocale((String)string.substring(1)), "Could not parse locale from: '" + string.substring(1) + "'");
            }).forEach(known::add));
            return known;
        }
        catch (IOException | URISyntaxException ex) {
            LOGGER.warn("Failed to discover available locales for bundle '{}'.", (Object)bundleName, (Object)ex);
            return ImmutableSet.of((Object)DEFAULT_LOCALE);
        }
    }

    private static void walkJar(Path jarPath, Consumer<Stream<Path>> user) throws IOException {
        if (Files.isDirectory(jarPath, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(jarPath, new FileVisitOption[0]);){
                user.accept(stream.map(it -> it.relativize(jarPath)));
            }
            return;
        }
        try (FileSystem jar = FileSystems.newFileSystem(jarPath, TranslatableProvider.class.getClassLoader());){
            Path root = jar.getRootDirectories().iterator().next();
            try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
                user.accept(stream);
            }
        }
    }
}

