/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.fabric;

import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.fabric.FabricServerCommandManager;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.TabTPSPlatform;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.DelegateUser;
import xyz.jpenilla.tabtps.common.command.commands.TickInfoCommand;
import xyz.jpenilla.tabtps.common.service.TickTimeService;
import xyz.jpenilla.tabtps.common.service.UserService;
import xyz.jpenilla.tabtps.common.util.UpdateChecker;
import xyz.jpenilla.tabtps.fabric.FabricUser;
import xyz.jpenilla.tabtps.fabric.command.FabricConsoleCommander;
import xyz.jpenilla.tabtps.fabric.command.FabricPingCommand;
import xyz.jpenilla.tabtps.fabric.command.FabricTickInfoCommandFormatter;
import xyz.jpenilla.tabtps.fabric.service.FabricUserService;

public final class TabTPSFabric
implements ModInitializer,
TabTPSPlatform<class_3222, FabricUser> {
    private static TabTPSFabric instance = null;
    private final Path configDirectory = FabricLoader.getInstance().getConfigDir().resolve("TabTPS");
    private final Logger logger = LoggerFactory.getLogger((String)"TabTPS");
    private final FabricUserService userService;
    private final TabTPS tabTPS;
    private final FabricServerCommandManager<Commander> commandManager;
    private MinecraftServer server;

    public TabTPSFabric() {
        if (instance != null) {
            throw new IllegalStateException("Cannot create a second instance of " + this.getClass().getName());
        }
        instance = this;
        this.userService = new FabricUserService(this);
        this.commandManager = new FabricServerCommandManager(CommandExecutionCoordinator.simpleCoordinator(), commandSourceStack -> {
            class_1297 entity = commandSourceStack.method_9228();
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                FabricUser user = this.userService().user(player);
                return new DelegateUser<class_3222, class_2168>(user, (class_2168)commandSourceStack);
            }
            return new FabricConsoleCommander((class_2168)commandSourceStack);
        }, commander -> {
            if (commander instanceof FabricConsoleCommander) {
                FabricConsoleCommander consoleCommander = (FabricConsoleCommander)commander;
                return consoleCommander.commandSourceStack();
            }
            if (commander instanceof DelegateUser) {
                DelegateUser user = (DelegateUser)commander;
                return (class_2168)user.c();
            }
            throw new IllegalArgumentException();
        });
        this.commandManager.brigadierManager().setNativeNumberSuggestions(false);
        this.tabTPS = new TabTPS(this);
        TickInfoCommand.withFormatter(this.tabTPS, this.tabTPS.commands(), new FabricTickInfoCommandFormatter(this)).register();
        new FabricPingCommand(this, this.tabTPS.commands()).register();
        this.logger.info("Done initializing TabTPS.");
    }

    public static @NonNull TabTPSFabric get() {
        return instance;
    }

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
            this.server = minecraftServer;
            CompletableFuture.runAsync(() -> UpdateChecker.checkVersion("1.3.18").forEach(arg_0 -> ((Logger)this.logger).info(arg_0)));
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(minecraftServer -> {
            if (this.tabTPS != null) {
                if (minecraftServer.method_3816()) {
                    this.tabTPS.shutdown();
                } else {
                    this.userService.flush();
                }
            }
            this.server = null;
        });
    }

    public @NonNull MinecraftServer server() {
        return Objects.requireNonNull(this.server, "server is null");
    }

    @Override
    public @NonNull UserService<class_3222, FabricUser> userService() {
        return this.userService;
    }

    @Override
    public @NonNull Path dataDirectory() {
        return this.configDirectory;
    }

    @Override
    public @NonNull TabTPS tabTPS() {
        return this.tabTPS;
    }

    @Override
    public @NonNull TickTimeService tickTimeService() {
        return (TickTimeService)this.server;
    }

    @Override
    public int maxPlayers() {
        return this.server().method_3802();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void onReload() {
        this.server().method_3760().method_14571().forEach(player -> this.server().method_3734().method_9241(player));
    }

    @Override
    public @NonNull Logger logger() {
        return this.logger;
    }

    public @NonNull FabricServerCommandManager<Commander> commandManager() {
        return this.commandManager;
    }
}

