/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.fabric.mixin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.BooleanSupplier;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import xyz.jpenilla.tabtps.common.service.TickTimeService;
import xyz.jpenilla.tabtps.common.util.RollingAverage;
import xyz.jpenilla.tabtps.common.util.TPSUtil;
import xyz.jpenilla.tabtps.common.util.TickTimes;
import xyz.jpenilla.tabtps.fabric.access.MinecraftServerAccess;

@Unique
@Mixin(value={MinecraftServer.class})
@Implements(value={@Interface(iface=TickTimeService.class, prefix="tabtps$")})
abstract class MinecraftServerMixin
implements MinecraftServerAccess {
    private final TickTimes tickTimes5s = new TickTimes(100);
    private final TickTimes tickTimes10s = new TickTimes(200);
    private final TickTimes tickTimes60s = new TickTimes(1200);
    private final RollingAverage tps5s = new RollingAverage(5);
    private final RollingAverage tps1m = new RollingAverage(60);
    private final RollingAverage tps5m = new RollingAverage(300);
    private final RollingAverage tps15m = new RollingAverage(900);
    private long previousTime;
    @Shadow
    private int field_4572;
    @Shadow
    @Final
    public long[] field_4573;

    MinecraftServerMixin() {
    }

    @Inject(method={"tickServer"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void injectTick(BooleanSupplier var1, CallbackInfo ci, long tickStartTimeNanos, long tickDurationNanos) {
        this.tickTimes5s.add(this.field_4572, tickDurationNanos);
        this.tickTimes10s.add(this.field_4572, tickDurationNanos);
        this.tickTimes60s.add(this.field_4572, tickDurationNanos);
        if (this.field_4572 % 20 == 0) {
            if (this.previousTime == 0L) {
                this.previousTime = tickStartTimeNanos - 50000000L;
            }
            long diff = tickStartTimeNanos - this.previousTime;
            this.previousTime = tickStartTimeNanos;
            BigDecimal currentTps = RollingAverage.TPS_BASE.divide(new BigDecimal(diff), 30, RoundingMode.HALF_UP);
            this.tps5s.add(currentTps, diff);
            this.tps1m.add(currentTps, diff);
            this.tps5m.add(currentTps, diff);
            this.tps15m.add(currentTps, diff);
        }
    }

    public double tabtps$averageMspt() {
        return TPSUtil.toMilliseconds(TPSUtil.average(this.field_4573));
    }

    public double @NonNull [] tabtps$recentTps() {
        double[] tps = new double[]{this.tps5s.average(), this.tps1m.average(), this.tps5m.average(), this.tps15m.average()};
        return tps;
    }

    @Override
    public @NonNull TickTimes tickTimes5s() {
        return this.tickTimes5s;
    }

    @Override
    public @NonNull TickTimes tickTimes10s() {
        return this.tickTimes10s;
    }

    @Override
    public @NonNull TickTimes tickTimes60s() {
        return this.tickTimes60s;
    }
}

