/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnifiedFallbackRuntime;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.AlmostUnifiedRuntimeImpl;
import com.almostreliable.unified.ReplacementData;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.ServerConfigs;
import com.almostreliable.unified.config.StartupConfig;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.recipe.unifier.RecipeHandlerFactory;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.TagReloadHandler;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AlmostUnified {
    public static final Logger LOG = LogManager.getLogger((String)"AlmostUnified");
    @Nullable
    private static AlmostUnifiedRuntime RUNTIME;
    @Nullable
    private static StartupConfig STARTUP_CONFIG;

    public static boolean isRuntimeLoaded() {
        return RUNTIME != null;
    }

    public static AlmostUnifiedRuntime getRuntime() {
        if (RUNTIME == null) {
            return AlmostUnifiedFallbackRuntime.getInstance();
        }
        return RUNTIME;
    }

    public static StartupConfig getStartupConfig() {
        if (STARTUP_CONFIG == null) {
            STARTUP_CONFIG = Config.load("startup", new StartupConfig.Serializer());
        }
        return STARTUP_CONFIG;
    }

    public static void onTagLoaderReload(Map<class_2960, Collection<class_6880<class_1792>>> tags) {
        RecipeHandlerFactory recipeHandlerFactory = new RecipeHandlerFactory();
        AlmostUnifiedPlatform.INSTANCE.bindRecipeHandlers(recipeHandlerFactory);
        ServerConfigs serverConfigs = ServerConfigs.load();
        UnifyConfig unifyConfig = serverConfigs.getUnifyConfig();
        TagReloadHandler.applyCustomTags(unifyConfig);
        TagOwnerships tagOwnerships = new TagOwnerships(unifyConfig.bakeAndValidateTags(tags), unifyConfig.getTagOwnerships());
        tagOwnerships.applyOwnerships(tags);
        ReplacementData replacementData = AlmostUnified.loadReplacementData(tags, unifyConfig, tagOwnerships);
        RUNTIME = new AlmostUnifiedRuntimeImpl(serverConfigs, replacementData.filteredTagMap(), replacementData.replacementMap(), recipeHandlerFactory);
    }

    public static void onRecipeManagerReload(Map<class_2960, JsonElement> recipes) {
        Preconditions.checkNotNull((Object)RUNTIME, (Object)"AlmostUnifiedRuntime was not loaded correctly");
        RUNTIME.run(recipes, AlmostUnified.getStartupConfig().isServerOnly());
    }

    private static ReplacementData loadReplacementData(Map<class_2960, Collection<class_6880<class_1792>>> tags, UnifyConfig unifyConfig, TagOwnerships tagOwnerships) {
        ReplacementData replacementData = ReplacementData.load(tags, unifyConfig, tagOwnerships);
        boolean needsRebuild = TagReloadHandler.applyInheritance(unifyConfig, replacementData);
        if (needsRebuild) {
            return ReplacementData.load(tags, unifyConfig, tagOwnerships);
        }
        return replacementData;
    }
}

