/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.api.recipe.RecipeUnifierBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GregTechModernRecipeUnifier
implements RecipeUnifier {
    private static final String CONTENT = "content";

    @Override
    public void collectUnifier(RecipeUnifierBuilder builder) {
        List.of("inputs", "tickInputs").forEach(key -> builder.put((String)key, (json, ctx) -> this.createContentReplacement((JsonElement)json, (RecipeContext)ctx, ctx::createIngredientReplacement)));
        List.of("outputs", "tickOutputs").forEach(key -> builder.put((String)key, (json, ctx) -> this.createContentReplacement((JsonElement)json, (RecipeContext)ctx, ctx::createResultReplacement)));
    }

    @Nullable
    private JsonElement createContentReplacement(@Nullable JsonElement json, RecipeContext ctx, Function<JsonElement, JsonElement> elementTransformer) {
        JsonObject jsonObject;
        JsonElement jsonElement;
        if (json instanceof JsonObject && (jsonElement = (jsonObject = (JsonObject)json).get("item")) instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            JsonArray result = new JsonArray();
            boolean changed = false;
            for (JsonElement element : jsonArray) {
                if (!(element instanceof JsonObject)) continue;
                JsonObject elementObject = (JsonObject)element;
                JsonElement replacement = elementTransformer.apply(elementObject.get(CONTENT));
                if (replacement != null) {
                    elementObject.add(CONTENT, replacement);
                    changed = true;
                }
                result.add((JsonElement)elementObject);
            }
            if (changed) {
                jsonObject.add("item", (JsonElement)result);
                return jsonObject;
            }
        }
        return null;
    }
}

