/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.jetbrains.annotations.Nullable;
import virtuoel.kanos_config.api.JsonConfigHandler;
import virtuoel.kanos_config.api.MutableConfigEntry;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.ModLoaderUtils;

public class ConfigSyncUtils {
    public static final Map<String, MutableConfigEntry<?>> CONFIGS = new HashMap();
    private static final Map<String, SyncableConfigEntry<?>> SYNCED_CONFIGS = new HashMap();
    private static final Map<String, ConfigEntryCodec<?>> SYNCED_CONFIG_CODECS = new HashMap();
    private static final Map<String, ConfigEntryCodec<?>> CODECS = new HashMap();
    private static final boolean NETWORKING_API_LOADED;

    public static void resetSyncedConfigs() {
        SYNCED_CONFIGS.values().forEach(entry -> entry.setSyncedValue(null));
    }

    public static void syncConfigs(Collection<class_3222> players) {
        for (class_3222 player : players) {
            ConfigSyncUtils.syncConfigs(player.field_13987, SYNCED_CONFIGS.values());
        }
    }

    public static void syncConfigs(class_3244 networkHandler) {
        ConfigSyncUtils.syncConfigs(networkHandler, SYNCED_CONFIGS.values());
    }

    public static void syncConfigs(class_3244 networkHandler, String ... configEntryKeys) {
        ArrayList entries = new ArrayList();
        for (String key : configEntryKeys) {
            SyncableConfigEntry<?> entry;
            if (!SYNCED_CONFIGS.containsKey(key) || (entry = SYNCED_CONFIGS.get(key)) == null) continue;
            entries.add(entry);
        }
        ConfigSyncUtils.syncConfigs(networkHandler, entries);
    }

    public static void syncConfigs(class_3244 networkHandler, Collection<SyncableConfigEntry<?>> configEntries) {
        if (NETWORKING_API_LOADED && ServerPlayNetworking.canSend((class_3244)networkHandler, (class_2960)Pehkui.CONFIG_SYNC_PACKET)) {
            networkHandler.method_14364((class_2596)ConfigSyncUtils.createConfigSyncPacket(configEntries));
        }
    }

    public static class_2658 createConfigSyncPacket(Collection<SyncableConfigEntry<?>> configEntries) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10804(configEntries.size());
        for (SyncableConfigEntry<?> entry : configEntries) {
            buffer.method_10814(entry.getName());
            SYNCED_CONFIG_CODECS.get(entry.getName()).write(buffer, entry);
        }
        return new class_2658(Pehkui.CONFIG_SYNC_PACKET, buffer);
    }

    public static Runnable readConfigs(class_2540 buffer) {
        int qty = buffer.method_10816();
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (int i = 0; i < qty; ++i) {
            String name = buffer.method_19772();
            SyncableConfigEntry<?> entry = SYNCED_CONFIGS.get(name);
            ConfigEntryCodec<?> codec = SYNCED_CONFIG_CODECS.get(name);
            if (entry == null) {
                Pehkui.LOGGER.warn("Received unknown config \"{}\" from server.", new Object[]{name});
                break;
            }
            if (codec == null) {
                Pehkui.LOGGER.warn("Codec \"{}\" not found. Could not parse config \"{}\" from server.", new Object[]{codec, name});
                break;
            }
            tasks.add(codec.read(buffer, entry));
        }
        return () -> tasks.forEach(Runnable::run);
    }

    public static <T> MutableConfigEntry<T> createConfigEntry(String name, T defaultValue, Supplier<T> supplier, Consumer<T> consumer) {
        if (SYNCED_CONFIGS.containsKey(name)) {
            SyncableConfigEntry<Object> entry = SYNCED_CONFIGS.get(name);
            if (entry == null) {
                entry = new SyncableConfigEntry<T>(name, defaultValue, supplier, consumer);
                SYNCED_CONFIGS.put(name, entry);
                CONFIGS.put(name, entry);
            }
            return entry;
        }
        NamedConfigEntry<T> entry = new NamedConfigEntry<T>(name, defaultValue, supplier, consumer);
        CONFIGS.put(name, entry);
        return entry;
    }

    public static void setupSyncableConfig(String name, String codecKey) {
        SYNCED_CONFIGS.put(name, null);
        SYNCED_CONFIG_CODECS.put(name, Objects.requireNonNull(CODECS.get(codecKey), String.format("Codec \"%s\" not found for config \"%s\"", codecKey, name)));
    }

    public static ArgumentBuilder<class_2168, ?> registerConfigCommands() {
        boolean splitConfigs = true;
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"config");
        ConfigSyncUtils.registerConfigSyncCommands(builder);
        ConfigSyncUtils.registerConfigFileCommands(builder);
        ConfigSyncUtils.registerConfigGetterCommands(builder, true);
        ConfigSyncUtils.registerConfigSetterCommands(builder, true);
        ConfigSyncUtils.registerConfigResetCommands(builder, true);
        return builder;
    }

    public static void registerConfigSyncCommands(ArgumentBuilder<class_2168, ?> configBuilder) {
        ArgumentBuilder builder = class_2170.method_9247((String)"sync").executes(context -> {
            ConfigSyncUtils.syncConfigs(((class_2168)context.getSource()).method_9225().method_8503().method_3760().method_14571());
            return 1;
        });
        configBuilder.then(builder);
    }

    public static void registerConfigFileCommands(ArgumentBuilder<class_2168, ?> configBuilder) {
        JsonConfigHandler config = (JsonConfigHandler)PehkuiConfig.BUILDER.config;
        configBuilder.then(class_2170.method_9247((String)"save").executes(context -> {
            JsonConfigHandler jsonConfigHandler = config;
            synchronized (jsonConfigHandler) {
                config.save();
            }
            return 1;
        })).then(class_2170.method_9247((String)"load").executes(context -> {
            JsonConfigHandler jsonConfigHandler = config;
            synchronized (jsonConfigHandler) {
                config.invalidate();
                config.get();
                ConfigSyncUtils.syncConfigs(((class_2168)context.getSource()).method_9225().method_8503().method_3760().method_14571());
            }
            return 1;
        })).then(class_2170.method_9247((String)"delete").executes(context -> {
            JsonConfigHandler jsonConfigHandler = config;
            synchronized (jsonConfigHandler) {
                config.onConfigChanged();
                try {
                    Files.deleteIfExists(FabricLoader.getInstance().getConfigDir().resolve("pehkui").resolve("config.json").normalize());
                    config.get();
                    ConfigSyncUtils.syncConfigs(((class_2168)context.getSource()).method_9225().method_8503().method_3760().method_14571());
                    return 1;
                }
                catch (IOException e) {
                    Pehkui.LOGGER.catching((Throwable)e);
                    return 0;
                }
            }
        }));
    }

    public static void registerConfigGetterCommands(ArgumentBuilder<class_2168, ?> configBuilder, boolean splitKeys) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"get");
        for (String key : CONFIGS.keySet()) {
            String[] stringArray;
            if (splitKeys) {
                stringArray = key.split("\\.");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = key;
            }
            String[] keys = stringArray;
            ArgumentBuilder root = class_2170.method_9247((String)keys[keys.length - 1]).executes(context -> {
                CommandUtils.sendFeedback((class_2168)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.config.get.value", "Config \"%s\" is currently set to \"%s\"", key, String.valueOf(CONFIGS.get(key).getValue())), false);
                return 1;
            });
            for (int i = keys.length - 2; i >= 0; --i) {
                LiteralArgumentBuilder temp = class_2170.method_9247((String)keys[i]);
                temp.then(root);
                root = temp;
            }
            builder.then(root);
        }
        configBuilder.then((ArgumentBuilder)builder);
    }

    public static void registerConfigSetterCommands(ArgumentBuilder<class_2168, ?> configBuilder, boolean splitKeys) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"set");
        ConfigSyncUtils.registerConfigModificationCommands(builder, true, splitKeys);
        configBuilder.then((ArgumentBuilder)builder);
    }

    public static void registerConfigResetCommands(ArgumentBuilder<class_2168, ?> configBuilder, boolean splitKeys) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"reset");
        ConfigSyncUtils.registerConfigModificationCommands(builder, false, splitKeys);
        builder.executes(context -> {
            for (Map.Entry<String, SyncableConfigEntry<?>> entry : SYNCED_CONFIGS.entrySet()) {
                entry.getValue().reset();
            }
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> I18nUtils.translate("commands.pehkui.debug.config.reset", "%s config entries have been reset to their default values", String.valueOf(SYNCED_CONFIGS.size())), false);
            for (class_3222 p : ((class_2168)context.getSource()).method_9225().method_8503().method_3760().method_14571()) {
                ConfigSyncUtils.syncConfigs(p.field_13987);
            }
            return 1;
        });
        configBuilder.then((ArgumentBuilder)builder);
    }

    private static void registerConfigModificationCommands(ArgumentBuilder<class_2168, ?> builder, boolean asSetterCommands, boolean splitKeys) {
        for (Map.Entry<String, SyncableConfigEntry<?>> entry : SYNCED_CONFIGS.entrySet()) {
            String[] stringArray;
            String key = entry.getKey();
            ConfigEntryCodec<?> codec = SYNCED_CONFIG_CODECS.get(key);
            ArgumentType<?> argType = codec.getArgumentType();
            if (argType == null) continue;
            if (splitKeys) {
                stringArray = key.split("\\.");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = key;
            }
            String[] keys = stringArray;
            ArgumentBuilder root = (asSetterCommands ? class_2170.method_9244((String)"value", argType) : class_2170.method_9247((String)keys[keys.length - 1])).executes(context -> {
                SyncableConfigEntry cfg = (SyncableConfigEntry)entry.getValue();
                String oldValue = String.valueOf(cfg.getValue());
                if (asSetterCommands) {
                    ConfigSyncUtils.setConfigValue(cfg, codec.getArgument(context, "value"));
                } else {
                    cfg.reset();
                }
                String newValue = String.valueOf(cfg.getValue());
                CommandUtils.sendFeedback((class_2168)context.getSource(), () -> I18nUtils.translate(String.format("commands.pehkui.debug.config.%s.value", asSetterCommands ? "changed" : "reset"), asSetterCommands ? "Config \"%s\" was changed from \"%s\" to \"%s\"" : "Config \"%s\" was reset from \"%s\" to default \"%s\"", key, oldValue, newValue), false);
                Set<SyncableConfigEntry<?>> cfgs = Collections.singleton(cfg);
                for (class_3222 p : ((class_2168)context.getSource()).method_9225().method_8503().method_3760().method_14571()) {
                    ConfigSyncUtils.syncConfigs(p.field_13987, cfgs);
                }
                return 1;
            });
            for (int i = keys.length - (asSetterCommands ? 1 : 2); i >= 0; --i) {
                LiteralArgumentBuilder temp = class_2170.method_9247((String)keys[i]);
                temp.then(root);
                root = temp;
            }
            builder.then(root);
        }
    }

    private static void setConfigValue(MutableConfigEntry cfg, Object value) {
        cfg.setValue(value);
    }

    static {
        CODECS.put("double", new ConfigEntryCodec<Double>((b, e) -> b.writeDouble(((Double)e.getValue()).doubleValue()), (b, e) -> {
            double v = b.readDouble();
            return () -> e.setSyncedValue(v);
        }, DoubleArgumentType::doubleArg, DoubleArgumentType::getDouble));
        CODECS.put("boolean", new ConfigEntryCodec<Boolean>((b, e) -> b.writeBoolean(((Boolean)e.getValue()).booleanValue()), (b, e) -> {
            boolean v = b.readBoolean();
            return () -> e.setSyncedValue(v);
        }, BoolArgumentType::bool, BoolArgumentType::getBool));
        CODECS.put("string_list", new ConfigEntryCodec((b, e) -> {
            List list = (List)e.getValue();
            b.method_10804(list.size());
            for (String v : list) {
                b.method_10814(v);
            }
        }, (b, e) -> {
            ArrayList<String> v = new ArrayList<String>();
            int size = b.method_10816();
            for (int i = 0; i < size; ++i) {
                v.add(b.method_19772());
            }
            return () -> e.setSyncedValue(v);
        }));
        NETWORKING_API_LOADED = ModLoaderUtils.isModLoaded("fabric-networking-api-v1");
    }

    private static class SyncableConfigEntry<T>
    extends NamedConfigEntry<T> {
        protected T syncedValue = null;

        public SyncableConfigEntry(String name, T defaultValue, Supplier<T> supplier, Consumer<T> consumer) {
            super(name, defaultValue, supplier, consumer);
        }

        public void setSyncedValue(T value) {
            this.syncedValue = value;
        }

        public boolean isSynced() {
            return this.syncedValue != null;
        }

        @Override
        public T get() {
            return this.isSynced() ? this.syncedValue : super.get();
        }

        @Override
        public void accept(T t) {
            this.setSyncedValue(null);
            super.accept(t);
        }

        @Override
        public T getValue() {
            return this.isSynced() ? this.syncedValue : super.getValue();
        }

        @Override
        public void setValue(T t) {
            this.setSyncedValue(null);
            super.setValue(t);
        }
    }

    private static class ConfigEntryCodec<T> {
        final BiConsumer<class_2540, SyncableConfigEntry<T>> writer;
        final BiFunction<class_2540, SyncableConfigEntry<T>, Runnable> reader;
        final Supplier<ArgumentType<T>> argumentGetter;
        final BiFunction<CommandContext<?>, String, T> argumentFunction;

        public ConfigEntryCodec(BiConsumer<class_2540, SyncableConfigEntry<T>> writer, BiFunction<class_2540, SyncableConfigEntry<T>, Runnable> reader) {
            this(writer, reader, () -> null, (c, n) -> null);
        }

        public ConfigEntryCodec(BiConsumer<class_2540, SyncableConfigEntry<T>> writer, BiFunction<class_2540, SyncableConfigEntry<T>, Runnable> reader, Supplier<ArgumentType<T>> argumentGetter, BiFunction<CommandContext<?>, String, T> argumentFunction) {
            this.writer = writer;
            this.reader = reader;
            this.argumentGetter = argumentGetter;
            this.argumentFunction = argumentFunction;
        }

        public void write(class_2540 buffer, SyncableConfigEntry<T> entry) {
            this.writer.accept(buffer, entry);
        }

        public Runnable read(class_2540 buffer, SyncableConfigEntry<T> entry) {
            return this.reader.apply(buffer, entry);
        }

        @Nullable
        public ArgumentType<T> getArgumentType() {
            return this.argumentGetter.get();
        }

        public T getArgument(CommandContext<?> context, String name) {
            return this.argumentFunction.apply(context, name);
        }
    }

    private static class NamedConfigEntry<T>
    implements MutableConfigEntry<T> {
        protected final String name;
        protected final Supplier<T> supplier;
        protected final Consumer<T> consumer;
        protected final T defaultValue;

        public NamedConfigEntry(String name, T defaultValue, Supplier<T> supplier, Consumer<T> consumer) {
            this.name = name;
            this.supplier = supplier;
            this.consumer = consumer;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public void reset() {
            this.setValue(this.defaultValue);
        }

        public T get() {
            return this.supplier.get();
        }

        public void accept(T t) {
            this.consumer.accept(t);
        }

        public T getValue() {
            return this.supplier.get();
        }

        public void setValue(T t) {
            this.consumer.accept(t);
        }
    }
}

