/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.jei;

import juuxel.adorn.AdornCommon;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.compat.jei.JeiRecipeTypes;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.recipe.BrewingRecipe;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.ItemBrewingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;

public final class BrewerCategory
implements IRecipeCategory<BrewingRecipe> {
    private static final class_2960 TEXTURE = AdornCommon.id("textures/gui/recipe_viewer/brewer_light.png");
    private final IDrawable background = new Background();
    private final IDrawable icon;
    private final IGuiHelper guiHelper;

    public BrewerCategory(IJeiHelpers helpers) {
        this.guiHelper = helpers.getGuiHelper();
        this.icon = this.guiHelper.createDrawableItemStack(AdornBlocks.INSTANCE.getBREWER().method_8389().method_7854());
    }

    public RecipeType<BrewingRecipe> getRecipeType() {
        return JeiRecipeTypes.BREWER;
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"category.adorn.brewer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder layoutBuilder, BrewingRecipe recipe, IFocusGroup focusGroup) {
        int leftX = 0;
        int topY = 0;
        IRecipeSlotBuilder firstSlot = layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 1, topY + 1);
        IRecipeSlotBuilder secondSlot = layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 61, topY + 1);
        IRecipeSlotBuilder resultSlot = layoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, leftX + 31, topY + 40);
        layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 4, topY + 39).addIngredients(class_1856.method_8091((class_1935[])new class_1935[]{AdornItems.INSTANCE.getMUG()}));
        long capacity = FluidBridge.get().getFluidUnit().getBucketVolume() * 2L;
        IRecipeSlotBuilder tank = layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 88, topY + 1).setFluidRenderer(capacity, false, 16, 59).setOverlay((IDrawable)this.guiHelper.createDrawable(TEXTURE, 154, 17, 16, 59), 0, 0);
        if (recipe instanceof ItemBrewingRecipe) {
            ItemBrewingRecipe r = (ItemBrewingRecipe)recipe;
            firstSlot.addIngredients(r.getFirstIngredient());
            secondSlot.addIngredients(r.getSecondIngredient());
            resultSlot.addItemStack(r.getResult());
        } else if (recipe instanceof FluidBrewingRecipe) {
            FluidBrewingRecipe r = (FluidBrewingRecipe)recipe;
            firstSlot.addIngredients(r.getFirstIngredient());
            secondSlot.addIngredients(r.getSecondIngredient());
            resultSlot.addItemStack(r.getResult());
            FluidIngredient ingredient = r.getFluid();
            long amount = FluidUnit.convert(ingredient.getAmount(), ingredient.getUnit(), FluidBridge.get().getFluidUnit());
            for (class_3611 fluid : ingredient.getFluid().getFluids()) {
                tank.addFluidStack(fluid, amount, ingredient.getNbt());
            }
        }
    }

    private static final class Background
    implements IDrawable {
        private Background() {
        }

        public int getWidth() {
            return 105;
        }

        public int getHeight() {
            return 61;
        }

        public void draw(class_332 context2, int offsetX, int offsetY) {
            context2.method_25302(TEXTURE, offsetX, offsetY, 49, 16, this.getWidth(), this.getHeight());
            float progressFraction = (float)(System.currentTimeMillis() % 4000L) / 4000.0f;
            int height = Math.round(progressFraction * 25.0f);
            context2.method_25302(TEXTURE, offsetX + 35, offsetY + 8, 176, 0, 8, height);
        }
    }
}

