/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.api.option.KeyedEnum;
import journeymap.client.ui.component.DropDownButton;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.common.properties.config.ConfigField;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4185;

public class PropertyDropdownButton<T>
extends DropDownButton
implements IConfigFieldHolder<ConfigField<T>> {
    protected final ConfigField<T> field;
    protected final String baseLabel;
    protected final String glyph = "\u21d5";
    protected final String labelPattern = "%1$s : %2$s %3$s %2$s";
    private final Collection<T> values;
    protected class_4185.class_4241 pressable;

    public PropertyDropdownButton(Collection<T> values, String label, ConfigField<T> field, class_4185.class_4241 pressable) {
        super("", pressable);
        this.pressable = pressable;
        this.field = field;
        this.baseLabel = label;
        this.values = values;
        this.setValue(field.get());
        this.disabledLabelColor = 0x404040;
        List<DropDownItem> items = this.setItems(values);
        super.setItems(items);
        this.setRenderDecorations(true);
        this.setRenderSolidBackground(true);
    }

    public PropertyDropdownButton(Collection<T> values, String label, ConfigField<T> field) {
        this(values, label, field, PropertyDropdownButton.emptyPressable());
    }

    protected List<DropDownItem> setItems(Collection<T> values) {
        ArrayList items = Lists.newArrayList();
        values.forEach(value -> {
            String label = value instanceof KeyedEnum ? Constants.getString(((KeyedEnum)value).getKey()) : Constants.getString(value.toString());
            items.add(new DropDownItem(this, value, label));
        });
        return items;
    }

    @Override
    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.setValue(selected.getId());
        this.onPress.onPress((class_4185)selected);
    }

    public void setValue(T value) {
        if (!this.field.get().equals(value)) {
            this.field.set((Object)value);
            this.field.save();
        }
        String label = value instanceof KeyedEnum ? Constants.getString(((KeyedEnum)value).getKey()) : Constants.getString(value.toString());
        this.method_25355((class_2561)Constants.getStringTextComponent(this.getFormattedLabel(label)));
    }

    public ConfigField<T> getField() {
        return this.field;
    }

    @Override
    public int getFitWidth(class_327 fr) {
        int max = fr.method_1727(this.method_25369().getString());
        for (DropDownItem item : this.items) {
            max = Math.max(max, fr.method_1727(this.getFormattedLabel(item.getLabel())));
        }
        return max + this.buttonBuffer;
    }

    @Override
    public int method_25368() {
        return this.field_22758;
    }

    @Override
    public void method_25358(int width) {
        if (this.paneScreen != null) {
            this.paneScreen.setPaneWidth(width);
        }
        super.method_25358(width);
    }

    @Override
    protected String getLabel(DropDownItem item) {
        return this.getFormattedLabel(item.getLabel());
    }

    protected String getFormattedLabel(String value) {
        return String.format("%1$s : %2$s %3$s %2$s", this.baseLabel, "\u21d5", value);
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get());
    }

    @Override
    public ConfigField<T> getConfigField() {
        return this.field;
    }
}

