/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.s2c;

import immersive_paintings.Main;
import immersive_paintings.cobalt.network.Message;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class PaintingListMessage
extends Message {
    private final Map<String, class_2487> paintings = new HashMap<String, class_2487>();
    private final boolean clear;

    public PaintingListMessage() {
        for (Map.Entry<class_2960, Painting> entry : ServerPaintingManager.getDatapackPaintings().entrySet()) {
            this.paintings.put(entry.getKey().toString(), entry.getValue().toNbt());
        }
        for (Map.Entry<class_2960, Painting> entry : ServerPaintingManager.get().getCustomServerPaintings().entrySet()) {
            this.paintings.put(entry.getKey().toString(), entry.getValue().toNbt());
        }
        this.clear = true;
    }

    @Override
    public void encode(class_2540 b) {
        b.writeInt(this.paintings.size());
        for (Map.Entry<String, class_2487> entry : this.paintings.entrySet()) {
            b.method_10814(entry.getKey());
            b.method_10794(entry.getValue());
        }
        b.writeBoolean(this.clear);
    }

    public PaintingListMessage(class_2540 b) {
        int size = b.readInt();
        for (int i = 0; i < size; ++i) {
            String key = b.method_19772();
            class_2487 value = b.method_10798();
            this.paintings.put(key, value);
        }
        this.clear = b.readBoolean();
    }

    public PaintingListMessage(class_2960 identifier, Painting painting) {
        this.paintings.put(identifier.toString(), painting == null ? null : painting.toNbt());
        this.clear = false;
    }

    @Override
    public void receive(class_1657 e) {
        Main.networkManager.handlePaintingListResponse(this);
    }

    public Map<class_2960, Painting> getPaintings() {
        HashMap<class_2960, Painting> paintings = new HashMap<class_2960, Painting>();
        for (Map.Entry<String, class_2487> entry : this.paintings.entrySet()) {
            class_2960 identifier = new class_2960(entry.getKey());
            if (entry.getValue() == null) {
                paintings.put(identifier, null);
                continue;
            }
            paintings.put(identifier, Painting.fromNbt(entry.getValue()));
        }
        return paintings;
    }

    public boolean shouldClear() {
        return this.clear;
    }
}

