/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import immersive_paintings.client.ClientUtils;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.network.c2s.ImageRequest;
import immersive_paintings.resources.Cache;
import immersive_paintings.resources.Painting;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ClientPaintingManager {
    static final Map<class_2960, Painting> paintings = new HashMap<class_2960, Painting>();

    public static Map<class_2960, Painting> getPaintings() {
        return paintings;
    }

    public static Painting getPainting(class_2960 identifier) {
        return paintings.getOrDefault(identifier, Painting.DEFAULT);
    }

    public static Painting.Texture getPaintingTexture(class_2960 identifier, Painting.Type type) {
        if (paintings.containsKey(identifier)) {
            Painting painting = paintings.get(identifier);
            Painting.Texture textureOriginal = painting.getTexture(type);
            Painting.Texture texture = painting.getTexture(textureOriginal.link);
            if (texture.image == null && !texture.requested) {
                texture.requested = true;
                Cache.get(texture).ifPresentOrElse(image -> {
                    texture.image = image;
                    ClientPaintingManager.registerImage(texture);
                }, () -> NetworkHandler.sendToServer(new ImageRequest(identifier, textureOriginal.link)));
            }
            if (texture.image == null) {
                for (Painting.Type t : Painting.Type.values()) {
                    Painting.Texture temporaryTexture = painting.getTexture(t);
                    if (temporaryTexture.image == null) continue;
                    return temporaryTexture;
                }
            }
            return texture;
        }
        return Painting.DEFAULT.texture;
    }

    public static void registerImage(Painting.Texture texture) {
        class_1011 nativeImage = ClientUtils.byteImageToNativeImage(texture.image);
        texture.textureIdentifier = class_310.method_1551().method_1531().method_4617("immersive_painting/" + texture.hash, new class_1043(nativeImage));
    }
}

