/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.items;

import com.chaosthedude.naturescompass.config.NaturesCompassConfig;
import com.chaosthedude.naturescompass.gui.GuiWrapper;
import com.chaosthedude.naturescompass.network.SyncPacket;
import com.chaosthedude.naturescompass.utils.BiomeUtils;
import com.chaosthedude.naturescompass.utils.CompassState;
import com.chaosthedude.naturescompass.utils.ItemUtils;
import com.chaosthedude.naturescompass.utils.PlayerUtils;
import com.chaosthedude.naturescompass.workers.BiomeSearchWorker;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class NaturesCompassItem
extends class_1792 {
    private BiomeSearchWorker worker;

    public NaturesCompassItem() {
        super((class_1792.class_1793)new FabricItemSettings().maxCount(1));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (!player.method_5715()) {
            if (world.field_9236) {
                class_1799 stack = ItemUtils.getHeldNatureCompass(player);
                GuiWrapper.openGUI(world, player, stack);
            } else {
                class_3218 serverWorld = (class_3218)world;
                class_3222 serverPlayer = (class_3222)player;
                boolean canTeleport = NaturesCompassConfig.allowTeleport && PlayerUtils.canTeleport(player);
                List<class_2960> allowedBiomeIDs = BiomeUtils.getAllowedBiomeIDs(world);
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)SyncPacket.ID, (class_2540)new SyncPacket(canTeleport, allowedBiomeIDs, BiomeUtils.getGeneratingDimensionsForAllowedBiomes(serverWorld)));
            }
        } else {
            if (this.worker != null) {
                this.worker.stop();
                this.worker = null;
            }
            this.setState(player.method_5998(hand), null, CompassState.INACTIVE, player);
        }
        return class_1271.method_22430((Object)player.method_5998(hand));
    }

    public void searchForBiome(class_3218 world, class_1657 player, class_2960 biomeID, class_2338 pos, class_1799 stack) {
        this.setSearching(stack, biomeID, player);
        Optional<class_1959> optionalBiome = BiomeUtils.getBiomeForIdentifier((class_1937)world, biomeID);
        if (optionalBiome.isPresent()) {
            if (this.worker != null) {
                this.worker.stop();
            }
            this.worker = new BiomeSearchWorker(world, player, stack, optionalBiome.get(), pos);
            this.worker.start();
        }
    }

    public void succeed(class_1799 stack, class_1657 player, int x, int z, int samples, boolean displayCoordinates) {
        this.setFound(stack, x, z, samples, player);
        this.setDisplayCoordinates(stack, displayCoordinates);
        this.worker = null;
    }

    public void fail(class_1799 stack, class_1657 player, int searchRadius, int samples) {
        this.setNotFound(stack, player, searchRadius, samples);
        this.worker = null;
    }

    public boolean isActive(class_1799 stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return this.getState(stack) != CompassState.INACTIVE;
        }
        return false;
    }

    public void setSearching(class_1799 stack, class_2960 biomeID, class_1657 player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10582("BiomeID", biomeID.toString());
            stack.method_7969().method_10569("State", CompassState.SEARCHING.getID());
            stack.method_7969().method_10569("SearchRadius", 0);
        }
    }

    public void setFound(class_1799 stack, int x, int z, int samples, class_1657 player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10569("State", CompassState.FOUND.getID());
            stack.method_7969().method_10569("FoundX", x);
            stack.method_7969().method_10569("FoundZ", z);
            stack.method_7969().method_10569("Samples", samples);
        }
    }

    public void setNotFound(class_1799 stack, class_1657 player, int searchRadius, int samples) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10569("State", CompassState.NOT_FOUND.getID());
            stack.method_7969().method_10569("SearchRadius", searchRadius);
            stack.method_7969().method_10569("Samples", samples);
        }
    }

    public void setInactive(class_1799 stack, class_1657 player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10569("State", CompassState.INACTIVE.getID());
        }
    }

    public void setState(class_1799 stack, class_2338 pos, CompassState state, class_1657 player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10569("State", state.getID());
        }
    }

    public void setDisplayCoordinates(class_1799 stack, boolean displayPosition) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10556("DisplayCoordinates", displayPosition);
        }
    }

    public void setFoundBiomeX(class_1799 stack, int x, class_1657 player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10569("FoundX", x);
        }
    }

    public void setFoundBiomeZ(class_1799 stack, int z, class_1657 player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10569("FoundZ", z);
        }
    }

    public void setBiomeID(class_1799 stack, class_2960 biomeID, class_1657 player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10582("BiomeID", biomeID.toString());
        }
    }

    public void setSearchRadius(class_1799 stack, int searchRadius, class_1657 player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10569("SearchRadius", searchRadius);
        }
    }

    public void setSamples(class_1799 stack, int samples, class_1657 player) {
        if (ItemUtils.verifyNBT(stack)) {
            stack.method_7969().method_10569("Samples", samples);
        }
    }

    public CompassState getState(class_1799 stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return CompassState.fromID(stack.method_7969().method_10550("State"));
        }
        return null;
    }

    public int getFoundBiomeX(class_1799 stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.method_7969().method_10550("FoundX");
        }
        return 0;
    }

    public int getFoundBiomeZ(class_1799 stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.method_7969().method_10550("FoundZ");
        }
        return 0;
    }

    public class_2960 getBiomeID(class_1799 stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return new class_2960(stack.method_7969().method_10558("BiomeID"));
        }
        return new class_2960("");
    }

    public int getSearchRadius(class_1799 stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.method_7969().method_10550("SearchRadius");
        }
        return -1;
    }

    public int getSamples(class_1799 stack) {
        if (ItemUtils.verifyNBT(stack)) {
            return stack.method_7969().method_10550("Samples");
        }
        return -1;
    }

    public int getDistanceToBiome(class_1657 player, class_1799 stack) {
        return BiomeUtils.getDistanceToBiome(player, this.getFoundBiomeX(stack), this.getFoundBiomeZ(stack));
    }

    public boolean shouldDisplayCoordinates(class_1799 stack) {
        if (ItemUtils.verifyNBT(stack) && stack.method_7969().method_10545("DisplayCoordinates")) {
            return stack.method_7969().method_10577("DisplayCoordinates");
        }
        return true;
    }
}

