/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import com.teamresourceful.resourcefullib.client.components.selection.SelectionList;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import java.util.ArrayList;
import java.util.List;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import me.codexadrian.tempad.client.gui.NewLocationScreen;
import me.codexadrian.tempad.client.widgets.TextButton;
import me.codexadrian.tempad.client.widgets.TextEntry;
import me.codexadrian.tempad.client.widgets.TimedoorSprite;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.network.NetworkHandler;
import me.codexadrian.tempad.common.network.messages.DeleteLocationPacket;
import me.codexadrian.tempad.common.network.messages.SummonTimedoorPacket;
import me.codexadrian.tempad.common.tempad.TempadItem;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class RunProgramScreen
extends class_437 {
    private static final class_2960 GRID = new class_2960("tempad", "textures/widget/tempad_grid.png");
    private static final int WIDTH = 256;
    private static final int HEIGHT = 160;
    private int mouseMovement;
    private int listSize;
    private final class_1268 hand;
    private boolean interfaceNeedsReload = false;
    private final TimedoorSprite timedoorSprite;
    private final List<LocationData> locations;
    private final List<class_4185> displayedInterfaceButtons = new ArrayList<class_4185>();
    private final List<class_4185> upNextButtons = new ArrayList<class_4185>();

    public RunProgramScreen(class_1268 hand, List<LocationData> locations) {
        super(class_2561.method_30163((String)""));
        this.hand = hand;
        this.timedoorSprite = new TimedoorSprite(0, 0, TempadClientConfig.color, 96);
        this.locations = locations;
    }

    protected void method_25426() {
        super.method_25426();
        int offset = 3;
        this.timedoorSprite.changePosition((this.field_22789 - 256) / 2 + 24, (this.field_22790 - 160) / 2 + offset + 16);
        int x = (this.field_22789 - 256) / 2 + offset + 144;
        int y = (this.field_22790 - 160) / 2 + offset + 32;
        SelectionList list = (SelectionList)this.method_37063((class_364)new SelectionList(x, y, 88, 90, 10, textEntry -> {
            if (textEntry != null) {
                this.locationButtonOnPress(textEntry.data);
            }
        }));
        list.updateEntries(this.locations.stream().map(TextEntry::new).toList());
        TextButton addLocation = new TextButton((this.field_22789 - 256) / 2 + offset + 144, (this.field_22790 - 160) / 2 + offset + 128 + 1, (class_2561)class_2561.method_43471((String)"gui.tempad.new_location"), -1, button -> this.field_22787.method_1507((class_437)new NewLocationScreen(this.hand)));
        this.method_37063((class_364)addLocation);
    }

    private void locationButtonOnPress(LocationData data) {
        class_5250 locationName = class_2561.method_48321((String)data.getLevelKey().method_29177().method_42093("dimension"), (String)data.getLevelKey().method_29177().toString()).method_27693(" [" + data.getBlockPos().method_23854() + "]");
        TextButton displayedLocation = new TextButton((this.field_22789 - 256) / 2 + 72 - this.field_22787.field_1772.method_27525((class_5348)locationName) / 2, (this.field_22790 - 160) / 2 + 4 + 128 - 20, (class_2561)locationName, TempadClientConfig.color, button1 -> {});
        this.upNextButtons.add(displayedLocation);
        class_5250 teleportText = class_2561.method_43471((String)"gui.tempad.teleport");
        class_1792 class_17922 = this.field_22787.field_1724.method_5998(this.hand).method_7909();
        if (class_17922 instanceof TempadItem) {
            TempadItem itemInHand = (TempadItem)class_17922;
            teleportButton = new TextButton((this.field_22789 - 256) / 2 + 72 - this.field_22787.field_1772.method_27525((class_5348)teleportText) / 2, (this.field_22790 - 160) / 2 + 4 + 128 - 10, (class_2561)teleportText, TempadClientConfig.color, button2 -> this.teleportAction(data), () -> itemInHand.getOption().canTimedoorOpen((class_1657)this.field_22787.field_1724, this.field_22787.field_1724.method_5998(this.hand)));
            this.upNextButtons.add(teleportButton);
        } else {
            teleportButton = new TextButton((this.field_22789 - 256) / 2 + 72 - this.field_22787.field_1772.method_27525((class_5348)teleportText) / 2, (this.field_22790 - 160) / 2 + 4 + 128 - 10, (class_2561)teleportText, TempadClientConfig.color, button2 -> this.teleportAction(data), () -> false);
            this.upNextButtons.add(teleportButton);
        }
        class_5250 deleteText = class_2561.method_43471((String)"gui.tempad.delete");
        TextButton deleteLocationButton = new TextButton((this.field_22789 - 256) / 2 + 72 - this.field_22787.field_1772.method_27525((class_5348)deleteText) / 2, (this.field_22790 - 160) / 2 + 4 + 128, (class_2561)deleteText, TempadClientConfig.color, button2 -> {
            class_310.method_1551().method_1507(null);
            NetworkHandler.CHANNEL.sendToServer((Packet)new DeleteLocationPacket(data.getId()));
        });
        this.upNextButtons.add(deleteLocationButton);
        this.interfaceNeedsReload = true;
    }

    private void teleportAction(LocationData data) {
        TempadItem tempadItem;
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        class_1799 itemInHand = this.field_22787.field_1724.method_5998(this.hand);
        class_1792 class_17922 = itemInHand.method_7909();
        if (class_17922 instanceof TempadItem && (tempadItem = (TempadItem)class_17922).getOption().canTimedoorOpen((class_1657)this.field_22787.field_1724, itemInHand)) {
            class_310.method_1551().method_1507(null);
            NetworkHandler.CHANNEL.sendToServer((Packet)new SummonTimedoorPacket(data.getId(), this.hand, TempadClientConfig.color));
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.interfaceNeedsReload) {
            this.displayedInterfaceButtons.forEach(x$0 -> this.method_37066((class_364)x$0));
            this.displayedInterfaceButtons.clear();
            this.displayedInterfaceButtons.addAll(this.upNextButtons);
            this.upNextButtons.clear();
            this.displayedInterfaceButtons.forEach(x$0 -> {
                class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
            });
            this.method_37066(this.timedoorSprite);
            this.method_37063(this.timedoorSprite);
            this.interfaceNeedsReload = false;
        }
    }

    private void renderOutline(@NotNull class_332 graphics) {
        int lineWidth = 4;
        graphics.method_25294((this.field_22789 - 256 - lineWidth) / 2, (this.field_22790 - 160 - lineWidth) / 2, (this.field_22789 + 256 + lineWidth) / 2, (this.field_22790 + 160 + lineWidth) / 2, TempadClientConfig.color | 0xFF000000);
    }

    private void renderGridBackground(@NotNull class_332 graphics, float red, float green, float blue) {
        RenderSystem.setShaderTexture((int)0, (class_2960)GRID);
        RenderSystem.setShaderColor((float)(red * 0.5f), (float)(green * 0.5f), (float)(blue * 0.5f), (float)1.0f);
        graphics.method_25293(GRID, (this.field_22789 - 256) / 2, (this.field_22790 - 160) / 2, 256, 160, 0.0f, 0.0f, 256, 160, 16, 16);
    }

    public void method_25420(@NotNull class_332 graphics) {
        super.method_25420(graphics);
        float red = (float)(TempadClientConfig.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(TempadClientConfig.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(TempadClientConfig.color & 0xFF) / 255.0f;
        this.renderOutline(graphics);
        this.renderGridBackground(graphics, red, green, blue);
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        graphics.method_25294((this.field_22789 - 256) / 2 + 144, (this.field_22790 - 160) / 2 + 32, (this.field_22789 - 256) / 2 + 240, (this.field_22790 - 160) / 2 + 128, -1);
        graphics.method_25294((this.field_22789 - 256) / 2 + 144 + 2, (this.field_22790 - 160) / 2 + 32 + 2, (this.field_22789 - 256) / 2 + 240 - 2, (this.field_22790 - 160) / 2 + 128 - 2, -15527149);
        this.renderHeaders(graphics);
    }

    private void renderHeaders(@NotNull class_332 graphics) {
        class_327 font = this.field_22787.field_1772;
        int cornerX = (this.field_22789 - 256) / 2 + 3;
        int cornerY = (this.field_22790 - 160) / 2 + 5;
        int x = cornerX + 144;
        int y = cornerY + 16;
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            graphics.method_27535(font, (class_2561)class_2561.method_43471((String)"gui.tempad.select_location"), x, y, -1);
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25421() {
        return false;
    }
}

