/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.render;

import me.codexadrian.tempad.common.entity.TimedoorEntity;
import me.codexadrian.tempad.common.utils.ShaderUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TimedoorRenderer
extends class_897<TimedoorEntity> {
    public TimedoorRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(TimedoorEntity entity, float yaw, float deltaTime, @NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, int light) {
        float width = 1.4f;
        float height = 2.3f;
        float depth = 0.4f;
        int closingTime = entity.getClosingTime();
        int tickLength = 8;
        int phaseLength = tickLength / 2;
        int ticks = entity.field_6012;
        float animation = ((float)ticks + deltaTime) / (float)tickLength;
        if (ticks < phaseLength) {
            width = class_3532.method_16439((float)(animation * 2.0f), (float)0.0f, (float)width);
            height = 0.2f;
        }
        if (ticks >= phaseLength && ticks < tickLength) {
            height = class_3532.method_16439((float)((animation - 0.5f) * 2.0f), (float)0.2f, (float)height);
        }
        if (closingTime != -1) {
            if (ticks > closingTime && ticks < closingTime + phaseLength) {
                height = class_3532.method_16439((float)(1.0f - (animation - (float)closingTime / (float)tickLength) * 2.0f), (float)0.2f, (float)height);
            }
            if (ticks >= closingTime + phaseLength) {
                width = class_3532.method_16439((float)(1.0f - (animation - (float)closingTime / (float)tickLength - 0.5f) * 2.0f), (float)0.0f, (float)width);
                height = 0.2f;
            }
        }
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(entity.method_36454()));
        poseStack.method_46416(0.0f, 1.15f, 0.0f);
        Matrix4f model = poseStack.method_23760().method_23761();
        this.renderTimedoor(model, multiBufferSource, width, height, depth, light, entity.getColor());
        super.method_3936((class_1297)entity, yaw, deltaTime, poseStack, multiBufferSource, light);
        poseStack.method_22909();
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull TimedoorEntity entity) {
        return new class_2960("tempad", "");
    }

    public void renderTimedoor(Matrix4f model, class_4597 multiBufferSource, float width, float height, float depth, int i, int color) {
        float xBound = width * 0.5f;
        float yBound = height * 0.5f - 0.01f;
        float zBound = depth * -0.5f;
        class_4588 buffer = multiBufferSource.getBuffer(ShaderUtils.getTimedoorShaderType());
        float red = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float green = (float)((color & 0xFF00) >> 8) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = 1.0f;
        buffer.method_22918(model, -xBound, yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, -yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, -yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, yBound, zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, -yBound, zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, -yBound, zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, yBound, zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, yBound, zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, yBound, zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, -yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, -yBound, zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, -yBound, zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, -yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, yBound, zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, -yBound, zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, -yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, -xBound, yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, -yBound, -zBound).method_22915(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, -yBound, zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22916(i).method_1344();
        buffer.method_22918(model, xBound, yBound, zBound).method_22915(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22916(i).method_1344();
    }
}

