/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.entity;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.codexadrian.tempad.common.config.TempadConfig;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.entity.fabric.TimedoorEntityImpl;
import me.codexadrian.tempad.common.registry.TempadRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimedoorEntity
extends class_1297 {
    public static final int ANIMATION_LENGTH = 8;
    private static final class_2940<Integer> CLOSING_TIME = class_2945.method_12791(TimedoorEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> COLOR = class_2945.method_12791(TimedoorEntity.class, (class_2941)class_2943.field_13327);
    private LocationData locationData = null;
    private UUID owner = null;
    private UUID linkedPortalId = null;
    private TimedoorEntity linkedPortalEntity = null;

    public TimedoorEntity(class_1299<TimedoorEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5693() {
        this.field_6011.method_12784(CLOSING_TIME, (Object)TempadConfig.timedoorWait);
        this.field_6011.method_12784(COLOR, (Object)-37120);
    }

    protected void method_5749(class_2487 compoundTag) {
        if (compoundTag.method_10545("location")) {
            this.setLocation(LocationData.fromTag(compoundTag.method_10562("location")));
        }
        this.setClosingTime(compoundTag.method_10550("closing_time"));
        if (compoundTag.method_25928("owner")) {
            this.setOwner(compoundTag.method_25926("owner"));
        }
        this.setColor(compoundTag.method_10550("outline_color"));
        if (compoundTag.method_10545("linked_portal")) {
            this.setLinkedPortalId(compoundTag.method_25926("linked_portal"));
        }
    }

    protected void method_5652(@NotNull class_2487 compoundTag) {
        if (this.locationData != null) {
            compoundTag.method_10566("location", (class_2520)this.locationData.toTag());
        }
        compoundTag.method_10569("closing_time", this.getClosingTime());
        if (this.owner != null) {
            compoundTag.method_25927("owner", this.getOwner());
        }
        compoundTag.method_10569("outline_color", this.getColor());
        if (this.getLinkedPortalId() != null) {
            compoundTag.method_25927("linked_portal", this.getLinkedPortalId());
        }
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    public void method_5773() {
        List entities;
        class_238 box = this.method_5829();
        if (this.method_5735() == class_2350.field_11043 || this.method_5735() == class_2350.field_11035) {
            box = box.method_1009(0.5, 0.0, 0.0);
        }
        if (this.method_5735() == class_2350.field_11034 || this.method_5735() == class_2350.field_11039) {
            box = box.method_1009(0.0, 0.0, 0.5);
        }
        if (this.getLocation() != null && !(entities = this.method_37908().method_8390(class_1297.class, box, entity -> !(entity instanceof TimedoorEntity) && entity.method_5822() && !(entity instanceof class_1540) && !(entity instanceof class_1530))).isEmpty() && !this.method_37908().method_8608()) {
            class_3218 destinationLevel = Objects.requireNonNull(this.method_37908().method_8503()).method_3847(this.getLocation().getLevelKey());
            entities.stream().flatMap(entity -> entity.method_5668().method_24204()).distinct().forEach(entity -> {
                class_1657 player;
                entity.method_5772();
                class_243 deltaMovement = entity.method_18798();
                class_2338 pos = this.getLocation().getBlockPos();
                if (destinationLevel != null) {
                    if (!this.getLocation().getLevelKey().method_29177().equals((Object)this.method_37908().method_27983().method_29177())) {
                        TimedoorEntity.teleportEntity(destinationLevel, pos, deltaMovement, entity);
                    } else {
                        entity.method_20620((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
                        entity.method_18799(deltaMovement);
                        entity.field_6007 = true;
                    }
                }
                if (this.getLinkedPortalEntity() != null) {
                    this.getLinkedPortalEntity().resetClosingTime();
                }
                this.resetClosingTime();
                if (entity instanceof class_1657 && (player = (class_1657)entity).method_5667().equals(this.getOwner())) {
                    this.setClosingTime(this.field_6012 + TempadConfig.timedoorAddWaitTime);
                    if (this.getLinkedPortalEntity() != null) {
                        this.getLinkedPortalEntity().setClosingTime(this.getLinkedPortalEntity().field_6012 + TempadConfig.timedoorAddWaitTime);
                    }
                }
            });
            if (this.getLinkedPortalEntity() == null) {
                TimedoorEntity recipientPortal = new TimedoorEntity((class_1299<TimedoorEntity>)((class_1299)TempadRegistry.TIMEDOOR_ENTITY.get()), (class_1937)destinationLevel);
                recipientPortal.setOwner(this.getOwner());
                recipientPortal.setClosingTime(TempadConfig.timedoorAddWaitTime);
                recipientPortal.setLocation(null);
                recipientPortal.setColor(this.getColor());
                this.setLinkedPortalId(recipientPortal.method_5667());
                recipientPortal.setLinkedPortalId(this.method_5667());
                class_2338 position = this.getLocation().getBlockPos().method_10079(this.method_5735(), 1);
                recipientPortal.method_5814((double)position.method_10263() + 0.5, position.method_10264(), (double)position.method_10260() + 0.5);
                recipientPortal.method_36456(this.method_36454());
                this.method_37908().method_8649((class_1297)recipientPortal);
            }
        }
        if (this.field_6012 > this.getClosingTime() + 8 && this.getClosingTime() != -1) {
            if (this.getLinkedPortalEntity() != null) {
                this.getLinkedPortalEntity().setLinkedPortalId(null);
            }
            this.setLinkedPortalId(null);
            this.method_31472();
        }
    }

    public void setLocation(LocationData location) {
        this.locationData = location;
    }

    @Nullable
    public LocationData getLocation() {
        return this.locationData;
    }

    public int getClosingTime() {
        return (Integer)this.field_6011.method_12789(CLOSING_TIME);
    }

    public void setClosingTime(int closingTime) {
        this.field_6011.method_12778(CLOSING_TIME, (Object)closingTime);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public UUID getLinkedPortalId() {
        return this.linkedPortalId;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void teleportEntity(class_3218 destinationLevel, class_2338 pos, class_243 deltaMovement, class_1297 entity) {
        void var3_3;
        void var2_2;
        void var1_1;
        TimedoorEntityImpl.teleportEntity(destinationLevel, (class_2338)var1_1, (class_243)var2_2, (class_1297)var3_3);
    }

    public TimedoorEntity getLinkedPortalEntity() {
        if (!this.method_37908().method_8608() && this.linkedPortalEntity == null) {
            class_3218 serverLevel = (class_3218)this.method_37908();
            this.linkedPortalEntity = (TimedoorEntity)serverLevel.method_14190(this.linkedPortalId);
        }
        return this.linkedPortalEntity;
    }

    public void setLinkedPortalId(UUID id) {
        this.linkedPortalId = id;
        this.linkedPortalEntity = null;
    }

    public void setColor(int color) {
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    public void resetClosingTime() {
        if (this.getClosingTime() != -1) {
            this.setClosingTime(this.field_6012 + TempadConfig.timedoorWait);
        }
    }
}

